/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.output;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.pircbotx.Channel;
import org.pircbotx.PircBotX;
import org.pircbotx.UserHostmask;
import org.pircbotx.hooks.ListenerAdapter;
import org.pircbotx.hooks.events.PartEvent;
import org.pircbotx.output.GenericChannelUserOutput;

public class OutputChannel
implements GenericChannelUserOutput {
    @NonNull
    protected final PircBotX bot;
    @NonNull
    protected final Channel channel;

    public void part() {
        this.bot.sendRaw().rawLine("PART " + this.channel.getName());
    }

    public void part(String reason) {
        this.bot.sendRaw().rawLine("PART " + this.channel.getName() + " :" + reason);
    }

    @Override
    public void message(String message) {
        this.bot.sendIRC().message(this.channel.getName(), message);
    }

    public void message(UserHostmask user, String message) {
        if (user == null) {
            throw new IllegalArgumentException("Can't send message to null user");
        }
        this.message(user.getNick() + ": " + message);
    }

    @Override
    public void action(String action) {
        this.bot.sendIRC().action(this.channel.getName(), action);
    }

    @Override
    public void notice(String notice) {
        this.bot.sendIRC().notice(this.channel.getName(), notice);
    }

    public void invite(Channel otherChannel) {
        if (otherChannel == null) {
            throw new IllegalArgumentException("Can't send invite to null invite channel");
        }
        this.bot.sendIRC().invite(otherChannel.getName(), this.channel.getName());
    }

    public void invite(@NonNull UserHostmask user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.bot.sendIRC().invite(user.getNick(), this.channel.getName());
    }

    public void invite(@NonNull String target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.bot.sendIRC().invite(target, this.channel.getName());
    }

    public void ctcpCommand(String command) {
        this.bot.sendIRC().ctcpCommand(this.channel.getName(), command);
    }

    public void cycle() {
        this.cycle("");
    }

    public void cycle(final String key) {
        final String channelName = this.channel.getName();
        this.bot.getConfiguration().getListenerManager().addListener(new ListenerAdapter(){

            @Override
            public void onPart(PartEvent event) throws Exception {
                if (event.getBot() == OutputChannel.this.bot) {
                    OutputChannel.this.bot.sendIRC().joinChannel(channelName, key);
                    OutputChannel.this.bot.getConfiguration().getListenerManager().removeListener(this);
                }
            }
        });
        this.part();
    }

    public void who() {
        this.bot.sendRaw().rawLine("WHO " + this.channel.getName());
    }

    public void getMode() {
        this.bot.sendRaw().rawLine("MODE " + this.channel.getName());
    }

    public void setMode(String mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Can't set mode on channel to null");
        }
        this.bot.sendIRC().mode(this.channel.getName(), mode);
    }

    public void setMode(String mode, Object ... args) {
        if (mode == null) {
            throw new IllegalArgumentException("Can't set mode on channel to null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Can't set mode arguments to null");
        }
        this.setMode(mode + " " + StringUtils.join((Object[])args, (String)" "));
    }

    public void setMode(String mode, UserHostmask user) {
        if (mode == null) {
            throw new IllegalArgumentException("Can't set user mode on channel to null");
        }
        if (user == null) {
            throw new IllegalArgumentException("Can't set user mode on null user");
        }
        this.setMode(mode + " " + user.getNick());
    }

    public void setChannelLimit(int limit) {
        this.setMode("+l", limit);
    }

    public void removeChannelLimit() {
        this.setMode("-l");
    }

    public void setChannelKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Can't set channel key to null");
        }
        this.setMode("+k", key);
    }

    public void removeChannelKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Can't remove channel key with null key");
        }
        this.setMode("-k", key);
    }

    public void setInviteOnly() {
        this.setMode("+i");
    }

    public void removeInviteOnly() {
        this.setMode("-i");
    }

    public void setModerated() {
        this.setMode("+m");
    }

    public void removeModerated() {
        this.setMode("-m");
    }

    public void setNoExternalMessages() {
        this.setMode("+n");
    }

    public void removeNoExternalMessages() {
        this.setMode("-n");
    }

    public void setSecret() {
        this.setMode("+s");
    }

    public void removeSecret() {
        this.setMode("-s");
    }

    public void setTopicProtection() {
        this.setMode("+t");
    }

    public void removeTopicProtection() {
        this.setMode("-t");
    }

    public void setChannelPrivate() {
        this.setMode("+p");
    }

    public void removeChannelPrivate() {
        this.setMode("-p");
    }

    public void ban(String hostmask) {
        if (hostmask == null) {
            throw new IllegalArgumentException("Can't set ban on null hostmask");
        }
        this.bot.sendRaw().rawLine("MODE " + this.channel.getName() + " +b " + hostmask);
    }

    public void unBan(String hostmask) {
        if (hostmask == null) {
            throw new IllegalArgumentException("Can't remove ban on null hostmask");
        }
        this.bot.sendRaw().rawLine("MODE " + this.channel.getName() + " -b " + hostmask);
    }

    public void op(UserHostmask user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't set op on null user");
        }
        this.setMode("+o " + user.getNick());
    }

    public void deOp(UserHostmask user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't remove op on null user");
        }
        this.setMode("-o " + user.getNick());
    }

    public void voice(UserHostmask user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't set voice on null user");
        }
        this.setMode("+v " + user.getNick());
    }

    public void deVoice(UserHostmask user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't remove voice on null user");
        }
        this.setMode("-v " + user.getNick());
    }

    public void halfOp(UserHostmask user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't set halfop on null user");
        }
        this.setMode("+h " + user.getNick());
    }

    public void deHalfOp(UserHostmask user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't remove halfop on null user");
        }
        this.setMode("-h " + user.getNick());
    }

    public void owner(UserHostmask user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't set owner on null user");
        }
        this.setMode("+q " + user.getNick());
    }

    public void deOwner(UserHostmask user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't remove owner on null user");
        }
        this.setMode("-q " + user.getNick());
    }

    public void superOp(UserHostmask user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't set super op on null user");
        }
        this.setMode("+a " + user.getNick());
    }

    public void deSuperOp(UserHostmask user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't remove super op on null user");
        }
        this.setMode("-a " + user.getNick());
    }

    public void setTopic(String topic) {
        if (topic == null) {
            throw new IllegalArgumentException("Can't set topic to null");
        }
        this.bot.sendRaw().rawLine("TOPIC " + this.channel.getName() + " :" + topic);
    }

    public void kick(UserHostmask user) {
        this.kick(user, "");
    }

    public void kick(UserHostmask user, String reason) {
        if (user == null) {
            throw new IllegalArgumentException("Can't kick null user");
        }
        this.bot.sendRaw().rawLine("KICK " + this.channel.getName() + " " + user.getNick() + " :" + reason);
    }

    public OutputChannel(@NonNull PircBotX bot, @NonNull Channel channel) {
        if (bot == null) {
            throw new NullPointerException("bot is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.bot = bot;
        this.channel = channel;
    }
}

