/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import javax.annotation.Nullable;
import lombok.NonNull;
import org.pircbotx.Channel;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.types.GenericChannelModeRecipientEvent;

public class SuperOpEvent
extends Event
implements GenericChannelModeRecipientEvent {
    protected final Channel channel;
    protected final UserHostmask userHostmask;
    protected final User user;
    protected final UserHostmask recipientHostmask;
    protected final User recipient;
    protected final boolean isSuperOp;

    public SuperOpEvent(PircBotX bot, @NonNull Channel channel, @NonNull UserHostmask userHostmask, User user, @NonNull UserHostmask recipientHostmask, User recipient, boolean isSuperOp) {
        super(bot);
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (recipientHostmask == null) {
            throw new NullPointerException("recipientHostmask is marked non-null but is null");
        }
        this.channel = channel;
        this.userHostmask = userHostmask;
        this.user = user;
        this.recipientHostmask = recipientHostmask;
        this.recipient = recipient;
        this.isSuperOp = isSuperOp;
    }

    @Override
    public void respond(String response) {
        this.getChannel().send().message(this.getUser(), response);
    }

    public boolean isSuperOp() {
        return this.isSuperOp;
    }

    public String toString() {
        return "SuperOpEvent(channel=" + this.getChannel() + ", userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ", recipientHostmask=" + this.getRecipientHostmask() + ", recipient=" + this.getRecipient() + ", isSuperOp=" + this.isSuperOp() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuperOpEvent)) {
            return false;
        }
        SuperOpEvent other = (SuperOpEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSuperOp() != other.isSuperOp()) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        UserHostmask this$recipientHostmask = this.getRecipientHostmask();
        UserHostmask other$recipientHostmask = other.getRecipientHostmask();
        if (this$recipientHostmask == null ? other$recipientHostmask != null : !((Object)this$recipientHostmask).equals(other$recipientHostmask)) {
            return false;
        }
        User this$recipient = this.getRecipient();
        User other$recipient = other.getRecipient();
        return !(this$recipient == null ? other$recipient != null : !((Object)this$recipient).equals(other$recipient));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SuperOpEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSuperOp() ? 79 : 97);
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        UserHostmask $recipientHostmask = this.getRecipientHostmask();
        result = result * 59 + ($recipientHostmask == null ? 43 : ((Object)$recipientHostmask).hashCode());
        User $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : ((Object)$recipient).hashCode());
        return result;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    public UserHostmask getRecipientHostmask() {
        return this.recipientHostmask;
    }

    @Override
    public User getRecipient() {
        return this.recipient;
    }
}

