/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableMap;
import lombok.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.UserHostmask;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.types.GenericChannelUserEvent;
import org.pircbotx.hooks.types.GenericSnapshotEvent;
import org.pircbotx.snapshot.ChannelSnapshot;
import org.pircbotx.snapshot.UserChannelDaoSnapshot;
import org.pircbotx.snapshot.UserSnapshot;

public class PartEvent
extends Event
implements GenericChannelUserEvent,
GenericSnapshotEvent {
    protected final UserChannelDaoSnapshot userChannelDaoSnapshot;
    protected final ChannelSnapshot channel;
    protected final UserHostmask userHostmask;
    protected final UserSnapshot user;
    protected final String channelName;
    protected final String reason;
    protected final ImmutableMap<String, String> tags;

    public PartEvent(PircBotX bot, UserChannelDaoSnapshot daoSnapshot, ChannelSnapshot channel, @NonNull String channelName, @NonNull UserHostmask userHostmask, UserSnapshot user, @NonNull String reason, ImmutableMap<String, String> tags) {
        super(bot);
        if (channelName == null) {
            throw new NullPointerException("channelName is marked non-null but is null");
        }
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        this.userChannelDaoSnapshot = daoSnapshot;
        this.channel = channel;
        this.channelName = channelName;
        this.userHostmask = userHostmask;
        this.user = user;
        this.reason = reason;
        this.tags = tags;
    }

    @Deprecated
    public UserChannelDaoSnapshot getDaoSnapshot() {
        return this.userChannelDaoSnapshot;
    }

    @Override
    public void respond(String response) {
        this.getChannel().send().message(response);
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getReason() {
        return this.reason;
    }

    public ImmutableMap<String, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "PartEvent(userChannelDaoSnapshot=" + this.getUserChannelDaoSnapshot() + ", channel=" + this.getChannel() + ", userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ", channelName=" + this.getChannelName() + ", reason=" + this.getReason() + ", tags=" + this.getTags() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartEvent)) {
            return false;
        }
        PartEvent other = (PartEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserChannelDaoSnapshot this$userChannelDaoSnapshot = this.getUserChannelDaoSnapshot();
        UserChannelDaoSnapshot other$userChannelDaoSnapshot = other.getUserChannelDaoSnapshot();
        if (this$userChannelDaoSnapshot == null ? other$userChannelDaoSnapshot != null : !this$userChannelDaoSnapshot.equals(other$userChannelDaoSnapshot)) {
            return false;
        }
        ChannelSnapshot this$channel = this.getChannel();
        ChannelSnapshot other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        UserSnapshot this$user = this.getUser();
        UserSnapshot other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$channelName = this.getChannelName();
        String other$channelName = other.getChannelName();
        if (this$channelName == null ? other$channelName != null : !this$channelName.equals(other$channelName)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        ImmutableMap<String, String> this$tags = this.getTags();
        ImmutableMap<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !this$tags.equals(other$tags));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PartEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UserChannelDaoSnapshot $userChannelDaoSnapshot = this.getUserChannelDaoSnapshot();
        result = result * 59 + ($userChannelDaoSnapshot == null ? 43 : $userChannelDaoSnapshot.hashCode());
        ChannelSnapshot $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        UserSnapshot $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $channelName = this.getChannelName();
        result = result * 59 + ($channelName == null ? 43 : $channelName.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        ImmutableMap<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        return result;
    }

    @Override
    public UserChannelDaoSnapshot getUserChannelDaoSnapshot() {
        return this.userChannelDaoSnapshot;
    }

    @Override
    public ChannelSnapshot getChannel() {
        return this.channel;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    public UserSnapshot getUser() {
        return this.user;
    }
}

