/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.pircbotx.Channel;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.types.GenericChannelUserEvent;

public class ModeEvent
extends Event
implements GenericChannelUserEvent {
    protected final Channel channel;
    protected final UserHostmask userHostmask;
    protected final User user;
    protected final String mode;
    protected final ImmutableList<String> modeParsed;
    protected final ImmutableMap<String, String> tags;

    public ModeEvent(PircBotX bot, @NonNull Channel channel, UserHostmask userHostmask, User user, @NonNull String mode, @NonNull ImmutableList<String> modeParsed, ImmutableMap<String, String> tags) {
        super(bot);
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        if (modeParsed == null) {
            throw new NullPointerException("modeParsed is marked non-null but is null");
        }
        this.channel = channel;
        this.userHostmask = userHostmask;
        this.user = user;
        this.mode = mode;
        this.modeParsed = modeParsed;
        this.tags = tags;
    }

    @Override
    public void respond(String response) {
        this.getChannel().send().message(this.getUser(), response);
    }

    public String getMode() {
        return this.mode;
    }

    public ImmutableList<String> getModeParsed() {
        return this.modeParsed;
    }

    public ImmutableMap<String, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "ModeEvent(channel=" + this.getChannel() + ", userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ", mode=" + this.getMode() + ", modeParsed=" + this.getModeParsed() + ", tags=" + this.getTags() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeEvent)) {
            return false;
        }
        ModeEvent other = (ModeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        ImmutableList<String> this$modeParsed = this.getModeParsed();
        ImmutableList<String> other$modeParsed = other.getModeParsed();
        if (this$modeParsed == null ? other$modeParsed != null : !this$modeParsed.equals(other$modeParsed)) {
            return false;
        }
        ImmutableMap<String, String> this$tags = this.getTags();
        ImmutableMap<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !this$tags.equals(other$tags));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ModeEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        ImmutableList<String> $modeParsed = this.getModeParsed();
        result = result * 59 + ($modeParsed == null ? 43 : $modeParsed.hashCode());
        ImmutableMap<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        return result;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }
}

