/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.dcc.ReceiveFileTransfer;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.types.GenericDCCEvent;

public class IncomingFileTransferEvent
extends Event
implements GenericDCCEvent {
    protected final User user;
    protected final UserHostmask userHostmask;
    protected final String rawFilename;
    protected final String safeFilename;
    protected final InetAddress address;
    protected final int port;
    protected final long filesize;
    protected final String token;
    protected final boolean passive;

    public IncomingFileTransferEvent(PircBotX bot, @NonNull UserHostmask userHostmask, User user, @NonNull String rawFilename, @NonNull String safeFilename, @NonNull InetAddress address, int port, long filesize, String token, boolean passive) {
        super(bot);
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (rawFilename == null) {
            throw new NullPointerException("rawFilename is marked non-null but is null");
        }
        if (safeFilename == null) {
            throw new NullPointerException("safeFilename is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.user = user;
        this.userHostmask = userHostmask;
        this.rawFilename = rawFilename;
        this.safeFilename = safeFilename;
        this.address = address;
        this.port = port;
        this.filesize = filesize;
        this.token = token;
        this.passive = passive;
    }

    @Deprecated
    public String getTransferToken() {
        return this.getToken();
    }

    public ReceiveFileTransfer accept(@NonNull File destination) throws IOException {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        return ((PircBotX)this.getBot()).getDccHandler().acceptFileTransfer(this, destination);
    }

    public ReceiveFileTransfer acceptResume(@NonNull File destination, long startPosition) throws IOException, InterruptedException {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        return ((PircBotX)this.getBot()).getDccHandler().acceptFileTransferResume(this, destination, startPosition);
    }

    @Override
    public void respond(String response) {
        this.getUser().send().message(response);
    }

    public String getRawFilename() {
        return this.rawFilename;
    }

    public String getSafeFilename() {
        return this.safeFilename;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public String toString() {
        return "IncomingFileTransferEvent(user=" + this.getUser() + ", userHostmask=" + this.getUserHostmask() + ", rawFilename=" + this.getRawFilename() + ", safeFilename=" + this.getSafeFilename() + ", address=" + this.getAddress() + ", port=" + this.getPort() + ", filesize=" + this.getFilesize() + ", token=" + this.getToken() + ", passive=" + this.isPassive() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IncomingFileTransferEvent)) {
            return false;
        }
        IncomingFileTransferEvent other = (IncomingFileTransferEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getFilesize() != other.getFilesize()) {
            return false;
        }
        if (this.isPassive() != other.isPassive()) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        String this$rawFilename = this.getRawFilename();
        String other$rawFilename = other.getRawFilename();
        if (this$rawFilename == null ? other$rawFilename != null : !this$rawFilename.equals(other$rawFilename)) {
            return false;
        }
        String this$safeFilename = this.getSafeFilename();
        String other$safeFilename = other.getSafeFilename();
        if (this$safeFilename == null ? other$safeFilename != null : !this$safeFilename.equals(other$safeFilename)) {
            return false;
        }
        InetAddress this$address = this.getAddress();
        InetAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IncomingFileTransferEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPort();
        long $filesize = this.getFilesize();
        result = result * 59 + (int)($filesize >>> 32 ^ $filesize);
        result = result * 59 + (this.isPassive() ? 79 : 97);
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        String $rawFilename = this.getRawFilename();
        result = result * 59 + ($rawFilename == null ? 43 : $rawFilename.hashCode());
        String $safeFilename = this.getSafeFilename();
        result = result * 59 + ($safeFilename == null ? 43 : $safeFilename.hashCode());
        InetAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean isPassive() {
        return this.passive;
    }
}

