/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableList;
import lombok.NonNull;
import org.pircbotx.ChannelListEntry;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.Event;

public class ChannelInfoEvent
extends Event {
    protected final ImmutableList<ChannelListEntry> list;

    public ChannelInfoEvent(PircBotX bot, @NonNull ImmutableList<ChannelListEntry> list) {
        super(bot);
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        this.list = list;
    }

    @Override
    public void respond(String response) {
        ((PircBotX)this.getBot()).sendRaw().rawLine(response);
    }

    public ImmutableList<ChannelListEntry> getList() {
        return this.list;
    }

    public String toString() {
        return "ChannelInfoEvent(list=" + this.getList() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelInfoEvent)) {
            return false;
        }
        ChannelInfoEvent other = (ChannelInfoEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImmutableList<ChannelListEntry> this$list = this.getList();
        ImmutableList<ChannelListEntry> other$list = other.getList();
        return !(this$list == null ? other$list != null : !this$list.equals(other$list));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChannelInfoEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ImmutableList<ChannelListEntry> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : $list.hashCode());
        return result;
    }
}

