/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.dcc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import org.pircbotx.User;
import org.pircbotx.dcc.DccState;
import org.pircbotx.dcc.SendFileTransfer;
import org.pircbotx.exception.DccException;

public class ReceiveFileTransferAcknowlegement
extends Thread {
    protected User user;
    protected SendFileTransfer sendFileTransfer;
    protected SocketChannel inChannel;
    protected FileChannel outChannel;
    protected ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[4]);
    protected Boolean running = true;
    protected long totalBytesAcknowleged = 0L;
    protected int previousBytesAcknowleged = 0;

    public ReceiveFileTransferAcknowlegement(User user, SendFileTransfer sendFileTransfer, SocketChannel inChannel, FileChannel outChannel) {
        this.user = user;
        this.inChannel = inChannel;
        this.outChannel = outChannel;
        this.sendFileTransfer = sendFileTransfer;
    }

    protected void receiveAcknowledge() throws IOException {
        this.inChannel.read(this.byteBuffer);
        this.byteBuffer.clear();
        int bytesAcknowledged = this.byteBuffer.getInt(0);
        if (bytesAcknowledged != (int)(this.totalBytesAcknowleged / 0xFFFFFFFEL) && this.totalBytesAcknowleged != (long)bytesAcknowledged) {
            this.totalBytesAcknowleged += (long)(bytesAcknowledged - this.previousBytesAcknowleged);
            this.sendFileTransfer.fileTransferStatus.bytesAcknowledged = this.totalBytesAcknowleged;
            this.previousBytesAcknowleged = bytesAcknowledged;
        }
    }

    @Override
    public void run() {
        block3: {
            try {
                this.totalBytesAcknowleged = this.outChannel.position();
                this.previousBytesAcknowleged = (int)this.totalBytesAcknowleged;
                while (this.running.booleanValue() && this.totalBytesAcknowleged != this.outChannel.size()) {
                    this.receiveAcknowledge();
                }
            }
            catch (IOException e) {
                if (this.sendFileTransfer == null) break block3;
                this.sendFileTransfer.fileTransferStatus.exception = new DccException(DccException.Reason.FILE_TRANSFER_CANCELLED, this.user, "User closed socket", e);
                this.sendFileTransfer.fileTransferStatus.dccState = DccState.ERROR;
            }
        }
    }
}

