/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.dcc;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import lombok.NonNull;
import org.pircbotx.Configuration;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.dcc.DccHandler;
import org.pircbotx.dcc.DccState;
import org.pircbotx.dcc.FileTransferStatus;
import org.pircbotx.exception.DccException;
import org.pircbotx.hooks.events.FileTransferCompleteEvent;

public abstract class FileTransfer {
    @NonNull
    protected final PircBotX bot;
    @NonNull
    protected final Configuration configuration;
    @NonNull
    protected final DccHandler dccHandler;
    @NonNull
    protected Socket socket;
    @NonNull
    protected final User user;
    @NonNull
    protected final File file;
    protected FileTransferStatus fileTransferStatus;
    protected DccHandler.PendingFileTransfer pendingFileTransfer;
    protected final Object stateLock = new Object();

    public FileTransfer(PircBotX bot, DccHandler dccHandler, DccHandler.PendingFileTransfer pendingFileTransfer, File file) {
        this.bot = bot;
        this.configuration = bot.getConfiguration();
        this.pendingFileTransfer = pendingFileTransfer;
        this.user = pendingFileTransfer.user;
        this.file = file;
        this.dccHandler = dccHandler;
        this.fileTransferStatus = new FileTransferStatus(pendingFileTransfer.fileSize, pendingFileTransfer.position);
    }

    private void connectSocket() throws IOException {
        this.socket = this.dccHandler.establishSocketConnection(this.pendingFileTransfer);
    }

    public void shutdown() {
        this.fileTransferStatus.dccState = DccState.SHUTDOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void transfer() {
        if (this.fileTransferStatus.dccState != DccState.INIT) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.fileTransferStatus.dccState != DccState.INIT) {
                    throw new RuntimeException("Cannot receive file twice (Current state: " + (Object)((Object)this.fileTransferStatus.dccState) + ")");
                }
            }
        }
        this.fileTransferStatus.dccState = DccState.CONNECTING;
        try {
            this.connectSocket();
            this.fileTransferStatus.dccState = DccState.RUNNING;
            this.transferFile();
            this.bot.getConfiguration().getListenerManager().onEvent(new FileTransferCompleteEvent(this.bot, this.fileTransferStatus, this.user, this.getFile().getName(), this.socket != null ? this.socket.getInetAddress() : null, this.socket != null ? this.socket.getLocalPort() : 0, this.fileTransferStatus.fileSize, this.pendingFileTransfer.passive, true));
        }
        catch (SocketTimeoutException e) {
            this.fileTransferStatus.dccState = DccState.ERROR;
            this.fileTransferStatus.exception = new DccException(DccException.Reason.FILE_TRANSFER_TIMEOUT, this.user, "Socket connection timeout", e);
            this.bot.getConfiguration().getListenerManager().onEvent(new FileTransferCompleteEvent(this.bot, this.fileTransferStatus, this.user, this.getFile().getName(), this.socket != null ? this.socket.getInetAddress() : null, this.socket != null ? this.socket.getLocalPort() : 0, this.fileTransferStatus.fileSize, this.pendingFileTransfer.passive, true));
        }
        catch (IOException e2) {
            this.fileTransferStatus.dccState = DccState.ERROR;
            this.fileTransferStatus.exception = new DccException(DccException.Reason.FILE_TRANSFER_TIMEOUT, this.user, "General IOException", e2);
            this.bot.getConfiguration().getListenerManager().onEvent(new FileTransferCompleteEvent(this.bot, this.fileTransferStatus, this.user, this.getFile().getName(), this.socket != null ? this.socket.getInetAddress() : null, this.socket != null ? this.socket.getLocalPort() : 0, this.fileTransferStatus.fileSize, this.pendingFileTransfer.passive, true));
            {
                catch (Throwable throwable) {
                    this.bot.getConfiguration().getListenerManager().onEvent(new FileTransferCompleteEvent(this.bot, this.fileTransferStatus, this.user, this.getFile().getName(), this.socket != null ? this.socket.getInetAddress() : null, this.socket != null ? this.socket.getLocalPort() : 0, this.fileTransferStatus.fileSize, this.pendingFileTransfer.passive, true));
                    throw throwable;
                }
            }
        }
    }

    protected abstract void transferFile();

    @NonNull
    public User getUser() {
        return this.user;
    }

    @NonNull
    public File getFile() {
        return this.file;
    }

    public FileTransferStatus getFileTransferStatus() {
        return this.fileTransferStatus;
    }
}

