/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.dcc;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import org.pircbotx.User;
import org.pircbotx.exception.DccException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Chat {
    private static final Logger log = LoggerFactory.getLogger(Chat.class);
    public static final Marker INPUT_CHAT_MARKER = MarkerFactory.getMarker((String)"pircbotx.dccChat.input");
    public static final Marker OUTPUT_CHAT_MARKER = MarkerFactory.getMarker((String)"pircbotx.dccChat.output");
    protected User user;
    protected BufferedReader bufferedReader;
    protected BufferedWriter bufferedWriter;
    protected Socket socket;
    protected boolean finished;

    protected Chat(User user, Socket socket, Charset encoding) throws IOException {
        Preconditions.checkNotNull((Object)user, (Object)"User cannot be null");
        Preconditions.checkNotNull((Object)socket, (Object)"Socket cannot be null");
        Preconditions.checkNotNull((Object)encoding, (Object)"Encoding cannot be null");
        this.user = user;
        this.socket = socket;
        this.bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), encoding));
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), encoding));
    }

    public String readLine() throws IOException {
        if (this.finished) {
            throw new DccException(DccException.Reason.CHAT_NOT_CONNECTED, this.user, "Chat has already finished");
        }
        String line = this.bufferedReader.readLine();
        log.info(INPUT_CHAT_MARKER, "<<<" + line);
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLine(String line) throws IOException {
        Preconditions.checkNotNull((Object)line, (Object)"Line cannot be null");
        if (this.finished) {
            throw new DccException(DccException.Reason.CHAT_NOT_CONNECTED, this.user, "Chat has already finished");
        }
        BufferedWriter bufferedWriter = this.bufferedWriter;
        synchronized (bufferedWriter) {
            log.info(OUTPUT_CHAT_MARKER, ">>>" + line);
            this.bufferedWriter.write(line + "\r\n");
            this.bufferedWriter.flush();
        }
    }

    public void close() throws IOException {
        if (this.finished) {
            throw new DccException(DccException.Reason.CHAT_NOT_CONNECTED, this.user, "Chat has already finished");
        }
        this.finished = true;
        this.socket.close();
    }

    public User getUser() {
        return this.user;
    }

    public BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    public BufferedWriter getBufferedWriter() {
        return this.bufferedWriter;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

