/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.pircbotx.PircBotX;
import org.pircbotx.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfo {
    private static final Logger log = LoggerFactory.getLogger(ServerInfo.class);
    protected final PircBotX bot;
    protected String serverName;
    protected String serverVersion;
    protected String userModes;
    protected LinkedHashMap<String, String> isupportRaw = new LinkedHashMap();
    protected String prefixes;
    protected String channelTypes;
    protected String channelModes;
    protected int maxModes;
    protected int maxChannels;
    protected String chanlimit;
    protected int maxNickLength;
    protected int maxBans;
    protected ImmutableMap<String, Integer> maxList;
    protected String network;
    protected String exceptBans;
    protected String exceptInvites;
    protected String invites;
    protected boolean wallOps;
    protected boolean wallVoices;
    protected String statusMessage;
    protected String caseMapping;
    protected String eList;
    protected int topicLength;
    protected int kickLength;
    protected int channelLength;
    protected String channelIDLength;
    protected String standard;
    protected int silence;
    protected boolean RFC2812;
    protected boolean penalty;
    protected boolean forcedNickChanges;
    protected boolean safeList;
    protected int awayLength;
    protected boolean noQuit;
    protected boolean userIPExists;
    protected boolean cPrivMsgExists;
    protected boolean cNoticeExists;
    protected int maxTargets;
    protected boolean knockExists;
    protected boolean vChannels;
    protected int watchMax;
    protected boolean whoX;
    protected boolean callerID;
    protected boolean accept;
    protected String language;
    protected String extBanPrefix;
    protected String extBanList;
    protected String motd;
    protected int highestConnections;
    protected int highestClients;
    protected int totalUsers;
    protected int totalInvisibleUsers;
    protected int totalServers;
    protected int totalOperatorsOnline;
    protected int totalUnknownConnections;
    protected int totalChannelsFormed;
    protected int serverUsers;
    protected int connectedServers;

    public void parse(int code, List<String> parsedLine) {
        if (code == 4) {
            this.parse004(parsedLine);
        } else if (code == 5) {
            this.parse005(parsedLine);
        }
    }

    protected void parse004(List<String> parsedLine) {
        this.serverName = Utils.tryGetIndex(parsedLine, 1, null);
        this.serverVersion = Utils.tryGetIndex(parsedLine, 2, null);
        this.userModes = Utils.tryGetIndex(parsedLine, 3, null);
        this.channelModes = Utils.tryGetIndex(parsedLine, 4, null);
    }

    protected void parse005(List<String> parsedLine) {
        for (String curItem : parsedLine) {
            String[] itemParts = curItem.split("=", 2);
            String key = itemParts[0];
            String value = itemParts.length == 2 ? itemParts[1] : "";
            this.isupportRaw.put(key, value);
            if (key.equalsIgnoreCase("PREFIX")) {
                this.prefixes = value;
                continue;
            }
            if (key.equalsIgnoreCase("CHANTYPES")) {
                this.channelTypes = value;
                continue;
            }
            if (key.equalsIgnoreCase("CHANMODES")) {
                this.channelModes = value;
                continue;
            }
            if (key.equalsIgnoreCase("MODES")) {
                this.maxModes = ServerInfo.tryParseInt("MODES", value);
                continue;
            }
            if (key.equalsIgnoreCase("MAXCHANNELS")) {
                this.maxChannels = ServerInfo.tryParseInt("MAXCHANNELS", value);
                continue;
            }
            if (key.equalsIgnoreCase("CHANLIMIT")) {
                this.chanlimit = value;
                continue;
            }
            if (key.equalsIgnoreCase("NICKLEN")) {
                this.maxNickLength = ServerInfo.tryParseInt("NICKLEN", value);
                continue;
            }
            if (key.equalsIgnoreCase("MAXBANS")) {
                this.maxBans = ServerInfo.tryParseInt("MAXBANS", value);
                continue;
            }
            if (key.equalsIgnoreCase("MAXLIST")) {
                StringTokenizer maxListTokens = new StringTokenizer(value, ":,");
                ImmutableMap.Builder maxListBuilder = ImmutableMap.builder();
                while (maxListTokens.hasMoreTokens()) {
                    String next = maxListTokens.nextToken();
                    maxListBuilder.put((Object)next, (Object)ServerInfo.tryParseInt("MAXLIST>" + next, maxListTokens.nextToken()));
                }
                this.maxList = maxListBuilder.build();
                continue;
            }
            if (key.equalsIgnoreCase("NETWORK")) {
                this.network = value;
                continue;
            }
            if (key.equalsIgnoreCase("EXCEPTS")) {
                this.exceptBans = value;
                continue;
            }
            if (key.equalsIgnoreCase("INVEX")) {
                this.exceptInvites = value;
                continue;
            }
            if (key.equalsIgnoreCase("WALLCHOPS")) {
                this.wallOps = true;
                continue;
            }
            if (key.equalsIgnoreCase("WALLVOICES")) {
                this.wallVoices = true;
                continue;
            }
            if (key.equalsIgnoreCase("STATUSMSG")) {
                this.statusMessage = value;
                continue;
            }
            if (key.equalsIgnoreCase("CASEMAPPING")) {
                this.caseMapping = value;
                continue;
            }
            if (key.equalsIgnoreCase("ELIST")) {
                this.eList = value;
                continue;
            }
            if (key.equalsIgnoreCase("TOPICLEN")) {
                this.topicLength = ServerInfo.tryParseInt("TOPICLEN", value);
                continue;
            }
            if (key.equalsIgnoreCase("KICKLEN")) {
                this.kickLength = ServerInfo.tryParseInt("KICKLEN", value);
                continue;
            }
            if (key.equalsIgnoreCase("CHANNELLEN")) {
                this.channelLength = ServerInfo.tryParseInt("CHANNELLEN", value);
                continue;
            }
            if (key.equalsIgnoreCase("CHIDLEN")) {
                this.channelIDLength = "!:" + ServerInfo.tryParseInt("CHIDLEN", value);
                continue;
            }
            if (key.equalsIgnoreCase("IDCHAN")) {
                this.channelIDLength = value;
                continue;
            }
            if (key.equalsIgnoreCase("STD")) {
                this.standard = value;
                continue;
            }
            if (key.equalsIgnoreCase("SILENCE")) {
                this.silence = ServerInfo.tryParseInt("SILENCE", value);
                continue;
            }
            if (key.equalsIgnoreCase("RFC2812")) {
                this.RFC2812 = true;
                continue;
            }
            if (key.equalsIgnoreCase("PENALTY")) {
                this.penalty = true;
                continue;
            }
            if (key.equalsIgnoreCase("CPRIVMSG")) {
                this.cPrivMsgExists = true;
                continue;
            }
            if (key.equalsIgnoreCase("CNOTICE")) {
                this.cNoticeExists = true;
                continue;
            }
            if (key.equalsIgnoreCase("SAFELIST")) {
                this.safeList = true;
                continue;
            }
            if (key.equalsIgnoreCase("KNOCK")) {
                this.knockExists = true;
                continue;
            }
            if (key.equalsIgnoreCase("WHOX")) {
                this.whoX = true;
                continue;
            }
            if (key.equalsIgnoreCase("CALLERID") || key.equalsIgnoreCase("ACCEPT")) {
                this.callerID = true;
                continue;
            }
            if (key.equalsIgnoreCase("USERIP")) {
                this.userIPExists = true;
                continue;
            }
            if (key.equalsIgnoreCase("CNOTICE")) {
                this.cNoticeExists = true;
                continue;
            }
            if (!key.equalsIgnoreCase("EXTBAN")) continue;
            if (value.contains(",")) {
                String[] valueSplit = StringUtils.split((String)value, (String)",", (int)2);
                if (valueSplit.length == 2) {
                    this.extBanPrefix = valueSplit[0];
                    this.extBanList = valueSplit[1];
                    continue;
                }
                this.extBanPrefix = null;
                this.extBanList = valueSplit[0];
                continue;
            }
            this.extBanList = value;
        }
    }

    private static int tryParseInt(String name, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.warn("Unparsable server info key '{}' value '{}' {}", new Object[]{name, value, ExceptionUtils.getMessage((Throwable)e)});
            return -1;
        }
    }

    public ImmutableMap<String, String> getIsupportRaw() {
        return ImmutableMap.copyOf(this.isupportRaw);
    }

    public String getISupportValue(String key) {
        return this.isupportRaw.get(key);
    }

    public <T extends PircBotX> T getBot() {
        return (T)this.bot;
    }

    public ServerInfo(PircBotX bot) {
        this.bot = bot;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public String getUserModes() {
        return this.userModes;
    }

    public String getPrefixes() {
        return this.prefixes;
    }

    public String getChannelTypes() {
        return this.channelTypes;
    }

    public String getChannelModes() {
        return this.channelModes;
    }

    public int getMaxModes() {
        return this.maxModes;
    }

    public int getMaxChannels() {
        return this.maxChannels;
    }

    public String getChanlimit() {
        return this.chanlimit;
    }

    public int getMaxNickLength() {
        return this.maxNickLength;
    }

    public int getMaxBans() {
        return this.maxBans;
    }

    public ImmutableMap<String, Integer> getMaxList() {
        return this.maxList;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getExceptBans() {
        return this.exceptBans;
    }

    public String getExceptInvites() {
        return this.exceptInvites;
    }

    public String getInvites() {
        return this.invites;
    }

    public boolean isWallOps() {
        return this.wallOps;
    }

    public boolean isWallVoices() {
        return this.wallVoices;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getCaseMapping() {
        return this.caseMapping;
    }

    public String getEList() {
        return this.eList;
    }

    public int getTopicLength() {
        return this.topicLength;
    }

    public int getKickLength() {
        return this.kickLength;
    }

    public int getChannelLength() {
        return this.channelLength;
    }

    public String getChannelIDLength() {
        return this.channelIDLength;
    }

    public String getStandard() {
        return this.standard;
    }

    public int getSilence() {
        return this.silence;
    }

    public boolean isRFC2812() {
        return this.RFC2812;
    }

    public boolean isPenalty() {
        return this.penalty;
    }

    public boolean isForcedNickChanges() {
        return this.forcedNickChanges;
    }

    public boolean isSafeList() {
        return this.safeList;
    }

    public int getAwayLength() {
        return this.awayLength;
    }

    public boolean isNoQuit() {
        return this.noQuit;
    }

    public boolean isUserIPExists() {
        return this.userIPExists;
    }

    public boolean isCPrivMsgExists() {
        return this.cPrivMsgExists;
    }

    public boolean isCNoticeExists() {
        return this.cNoticeExists;
    }

    public int getMaxTargets() {
        return this.maxTargets;
    }

    public boolean isKnockExists() {
        return this.knockExists;
    }

    public boolean isVChannels() {
        return this.vChannels;
    }

    public int getWatchMax() {
        return this.watchMax;
    }

    public boolean isWhoX() {
        return this.whoX;
    }

    public boolean isCallerID() {
        return this.callerID;
    }

    public boolean isAccept() {
        return this.accept;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getExtBanPrefix() {
        return this.extBanPrefix;
    }

    public String getExtBanList() {
        return this.extBanList;
    }

    public String getMotd() {
        return this.motd;
    }

    public int getHighestConnections() {
        return this.highestConnections;
    }

    public int getHighestClients() {
        return this.highestClients;
    }

    public int getTotalUsers() {
        return this.totalUsers;
    }

    public int getTotalInvisibleUsers() {
        return this.totalInvisibleUsers;
    }

    public int getTotalServers() {
        return this.totalServers;
    }

    public int getTotalOperatorsOnline() {
        return this.totalOperatorsOnline;
    }

    public int getTotalUnknownConnections() {
        return this.totalUnknownConnections;
    }

    public int getTotalChannelsFormed() {
        return this.totalChannelsFormed;
    }

    public int getServerUsers() {
        return this.serverUsers;
    }

    public int getConnectedServers() {
        return this.connectedServers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerInfo)) {
            return false;
        }
        ServerInfo other = (ServerInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxModes() != other.getMaxModes()) {
            return false;
        }
        if (this.getMaxChannels() != other.getMaxChannels()) {
            return false;
        }
        if (this.getMaxNickLength() != other.getMaxNickLength()) {
            return false;
        }
        if (this.getMaxBans() != other.getMaxBans()) {
            return false;
        }
        if (this.isWallOps() != other.isWallOps()) {
            return false;
        }
        if (this.isWallVoices() != other.isWallVoices()) {
            return false;
        }
        if (this.getTopicLength() != other.getTopicLength()) {
            return false;
        }
        if (this.getKickLength() != other.getKickLength()) {
            return false;
        }
        if (this.getChannelLength() != other.getChannelLength()) {
            return false;
        }
        if (this.getSilence() != other.getSilence()) {
            return false;
        }
        if (this.isRFC2812() != other.isRFC2812()) {
            return false;
        }
        if (this.isPenalty() != other.isPenalty()) {
            return false;
        }
        if (this.isForcedNickChanges() != other.isForcedNickChanges()) {
            return false;
        }
        if (this.isSafeList() != other.isSafeList()) {
            return false;
        }
        if (this.getAwayLength() != other.getAwayLength()) {
            return false;
        }
        if (this.isNoQuit() != other.isNoQuit()) {
            return false;
        }
        if (this.isUserIPExists() != other.isUserIPExists()) {
            return false;
        }
        if (this.isCPrivMsgExists() != other.isCPrivMsgExists()) {
            return false;
        }
        if (this.isCNoticeExists() != other.isCNoticeExists()) {
            return false;
        }
        if (this.getMaxTargets() != other.getMaxTargets()) {
            return false;
        }
        if (this.isKnockExists() != other.isKnockExists()) {
            return false;
        }
        if (this.isVChannels() != other.isVChannels()) {
            return false;
        }
        if (this.getWatchMax() != other.getWatchMax()) {
            return false;
        }
        if (this.isWhoX() != other.isWhoX()) {
            return false;
        }
        if (this.isCallerID() != other.isCallerID()) {
            return false;
        }
        if (this.isAccept() != other.isAccept()) {
            return false;
        }
        if (this.getHighestConnections() != other.getHighestConnections()) {
            return false;
        }
        if (this.getHighestClients() != other.getHighestClients()) {
            return false;
        }
        if (this.getTotalUsers() != other.getTotalUsers()) {
            return false;
        }
        if (this.getTotalInvisibleUsers() != other.getTotalInvisibleUsers()) {
            return false;
        }
        if (this.getTotalServers() != other.getTotalServers()) {
            return false;
        }
        if (this.getTotalOperatorsOnline() != other.getTotalOperatorsOnline()) {
            return false;
        }
        if (this.getTotalUnknownConnections() != other.getTotalUnknownConnections()) {
            return false;
        }
        if (this.getTotalChannelsFormed() != other.getTotalChannelsFormed()) {
            return false;
        }
        if (this.getServerUsers() != other.getServerUsers()) {
            return false;
        }
        if (this.getConnectedServers() != other.getConnectedServers()) {
            return false;
        }
        Object this$bot = this.getBot();
        Object other$bot = other.getBot();
        if (this$bot == null ? other$bot != null : !this$bot.equals(other$bot)) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        if (this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName)) {
            return false;
        }
        String this$serverVersion = this.getServerVersion();
        String other$serverVersion = other.getServerVersion();
        if (this$serverVersion == null ? other$serverVersion != null : !this$serverVersion.equals(other$serverVersion)) {
            return false;
        }
        String this$userModes = this.getUserModes();
        String other$userModes = other.getUserModes();
        if (this$userModes == null ? other$userModes != null : !this$userModes.equals(other$userModes)) {
            return false;
        }
        ImmutableMap<String, String> this$isupportRaw = this.getIsupportRaw();
        ImmutableMap<String, String> other$isupportRaw = other.getIsupportRaw();
        if (this$isupportRaw == null ? other$isupportRaw != null : !this$isupportRaw.equals(other$isupportRaw)) {
            return false;
        }
        String this$prefixes = this.getPrefixes();
        String other$prefixes = other.getPrefixes();
        if (this$prefixes == null ? other$prefixes != null : !this$prefixes.equals(other$prefixes)) {
            return false;
        }
        String this$channelTypes = this.getChannelTypes();
        String other$channelTypes = other.getChannelTypes();
        if (this$channelTypes == null ? other$channelTypes != null : !this$channelTypes.equals(other$channelTypes)) {
            return false;
        }
        String this$channelModes = this.getChannelModes();
        String other$channelModes = other.getChannelModes();
        if (this$channelModes == null ? other$channelModes != null : !this$channelModes.equals(other$channelModes)) {
            return false;
        }
        String this$chanlimit = this.getChanlimit();
        String other$chanlimit = other.getChanlimit();
        if (this$chanlimit == null ? other$chanlimit != null : !this$chanlimit.equals(other$chanlimit)) {
            return false;
        }
        ImmutableMap<String, Integer> this$maxList = this.getMaxList();
        ImmutableMap<String, Integer> other$maxList = other.getMaxList();
        if (this$maxList == null ? other$maxList != null : !this$maxList.equals(other$maxList)) {
            return false;
        }
        String this$network = this.getNetwork();
        String other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
            return false;
        }
        String this$exceptBans = this.getExceptBans();
        String other$exceptBans = other.getExceptBans();
        if (this$exceptBans == null ? other$exceptBans != null : !this$exceptBans.equals(other$exceptBans)) {
            return false;
        }
        String this$exceptInvites = this.getExceptInvites();
        String other$exceptInvites = other.getExceptInvites();
        if (this$exceptInvites == null ? other$exceptInvites != null : !this$exceptInvites.equals(other$exceptInvites)) {
            return false;
        }
        String this$invites = this.getInvites();
        String other$invites = other.getInvites();
        if (this$invites == null ? other$invites != null : !this$invites.equals(other$invites)) {
            return false;
        }
        String this$statusMessage = this.getStatusMessage();
        String other$statusMessage = other.getStatusMessage();
        if (this$statusMessage == null ? other$statusMessage != null : !this$statusMessage.equals(other$statusMessage)) {
            return false;
        }
        String this$caseMapping = this.getCaseMapping();
        String other$caseMapping = other.getCaseMapping();
        if (this$caseMapping == null ? other$caseMapping != null : !this$caseMapping.equals(other$caseMapping)) {
            return false;
        }
        String this$eList = this.getEList();
        String other$eList = other.getEList();
        if (this$eList == null ? other$eList != null : !this$eList.equals(other$eList)) {
            return false;
        }
        String this$channelIDLength = this.getChannelIDLength();
        String other$channelIDLength = other.getChannelIDLength();
        if (this$channelIDLength == null ? other$channelIDLength != null : !this$channelIDLength.equals(other$channelIDLength)) {
            return false;
        }
        String this$standard = this.getStandard();
        String other$standard = other.getStandard();
        if (this$standard == null ? other$standard != null : !this$standard.equals(other$standard)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$extBanPrefix = this.getExtBanPrefix();
        String other$extBanPrefix = other.getExtBanPrefix();
        if (this$extBanPrefix == null ? other$extBanPrefix != null : !this$extBanPrefix.equals(other$extBanPrefix)) {
            return false;
        }
        String this$extBanList = this.getExtBanList();
        String other$extBanList = other.getExtBanList();
        if (this$extBanList == null ? other$extBanList != null : !this$extBanList.equals(other$extBanList)) {
            return false;
        }
        String this$motd = this.getMotd();
        String other$motd = other.getMotd();
        return !(this$motd == null ? other$motd != null : !this$motd.equals(other$motd));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxModes();
        result = result * 59 + this.getMaxChannels();
        result = result * 59 + this.getMaxNickLength();
        result = result * 59 + this.getMaxBans();
        result = result * 59 + (this.isWallOps() ? 79 : 97);
        result = result * 59 + (this.isWallVoices() ? 79 : 97);
        result = result * 59 + this.getTopicLength();
        result = result * 59 + this.getKickLength();
        result = result * 59 + this.getChannelLength();
        result = result * 59 + this.getSilence();
        result = result * 59 + (this.isRFC2812() ? 79 : 97);
        result = result * 59 + (this.isPenalty() ? 79 : 97);
        result = result * 59 + (this.isForcedNickChanges() ? 79 : 97);
        result = result * 59 + (this.isSafeList() ? 79 : 97);
        result = result * 59 + this.getAwayLength();
        result = result * 59 + (this.isNoQuit() ? 79 : 97);
        result = result * 59 + (this.isUserIPExists() ? 79 : 97);
        result = result * 59 + (this.isCPrivMsgExists() ? 79 : 97);
        result = result * 59 + (this.isCNoticeExists() ? 79 : 97);
        result = result * 59 + this.getMaxTargets();
        result = result * 59 + (this.isKnockExists() ? 79 : 97);
        result = result * 59 + (this.isVChannels() ? 79 : 97);
        result = result * 59 + this.getWatchMax();
        result = result * 59 + (this.isWhoX() ? 79 : 97);
        result = result * 59 + (this.isCallerID() ? 79 : 97);
        result = result * 59 + (this.isAccept() ? 79 : 97);
        result = result * 59 + this.getHighestConnections();
        result = result * 59 + this.getHighestClients();
        result = result * 59 + this.getTotalUsers();
        result = result * 59 + this.getTotalInvisibleUsers();
        result = result * 59 + this.getTotalServers();
        result = result * 59 + this.getTotalOperatorsOnline();
        result = result * 59 + this.getTotalUnknownConnections();
        result = result * 59 + this.getTotalChannelsFormed();
        result = result * 59 + this.getServerUsers();
        result = result * 59 + this.getConnectedServers();
        Object $bot = this.getBot();
        result = result * 59 + ($bot == null ? 43 : $bot.hashCode());
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        String $serverVersion = this.getServerVersion();
        result = result * 59 + ($serverVersion == null ? 43 : $serverVersion.hashCode());
        String $userModes = this.getUserModes();
        result = result * 59 + ($userModes == null ? 43 : $userModes.hashCode());
        ImmutableMap<String, String> $isupportRaw = this.getIsupportRaw();
        result = result * 59 + ($isupportRaw == null ? 43 : $isupportRaw.hashCode());
        String $prefixes = this.getPrefixes();
        result = result * 59 + ($prefixes == null ? 43 : $prefixes.hashCode());
        String $channelTypes = this.getChannelTypes();
        result = result * 59 + ($channelTypes == null ? 43 : $channelTypes.hashCode());
        String $channelModes = this.getChannelModes();
        result = result * 59 + ($channelModes == null ? 43 : $channelModes.hashCode());
        String $chanlimit = this.getChanlimit();
        result = result * 59 + ($chanlimit == null ? 43 : $chanlimit.hashCode());
        ImmutableMap<String, Integer> $maxList = this.getMaxList();
        result = result * 59 + ($maxList == null ? 43 : $maxList.hashCode());
        String $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        String $exceptBans = this.getExceptBans();
        result = result * 59 + ($exceptBans == null ? 43 : $exceptBans.hashCode());
        String $exceptInvites = this.getExceptInvites();
        result = result * 59 + ($exceptInvites == null ? 43 : $exceptInvites.hashCode());
        String $invites = this.getInvites();
        result = result * 59 + ($invites == null ? 43 : $invites.hashCode());
        String $statusMessage = this.getStatusMessage();
        result = result * 59 + ($statusMessage == null ? 43 : $statusMessage.hashCode());
        String $caseMapping = this.getCaseMapping();
        result = result * 59 + ($caseMapping == null ? 43 : $caseMapping.hashCode());
        String $eList = this.getEList();
        result = result * 59 + ($eList == null ? 43 : $eList.hashCode());
        String $channelIDLength = this.getChannelIDLength();
        result = result * 59 + ($channelIDLength == null ? 43 : $channelIDLength.hashCode());
        String $standard = this.getStandard();
        result = result * 59 + ($standard == null ? 43 : $standard.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $extBanPrefix = this.getExtBanPrefix();
        result = result * 59 + ($extBanPrefix == null ? 43 : $extBanPrefix.hashCode());
        String $extBanList = this.getExtBanList();
        result = result * 59 + ($extBanList == null ? 43 : $extBanList.hashCode());
        String $motd = this.getMotd();
        result = result * 59 + ($motd == null ? 43 : $motd.hashCode());
        return result;
    }

    public String toString() {
        return "ServerInfo(bot=" + this.getBot() + ", serverName=" + this.getServerName() + ", serverVersion=" + this.getServerVersion() + ", userModes=" + this.getUserModes() + ", isupportRaw=" + this.getIsupportRaw() + ", prefixes=" + this.getPrefixes() + ", channelTypes=" + this.getChannelTypes() + ", channelModes=" + this.getChannelModes() + ", maxModes=" + this.getMaxModes() + ", maxChannels=" + this.getMaxChannels() + ", chanlimit=" + this.getChanlimit() + ", maxNickLength=" + this.getMaxNickLength() + ", maxBans=" + this.getMaxBans() + ", maxList=" + this.getMaxList() + ", network=" + this.getNetwork() + ", exceptBans=" + this.getExceptBans() + ", exceptInvites=" + this.getExceptInvites() + ", invites=" + this.getInvites() + ", wallOps=" + this.isWallOps() + ", wallVoices=" + this.isWallVoices() + ", statusMessage=" + this.getStatusMessage() + ", caseMapping=" + this.getCaseMapping() + ", eList=" + this.getEList() + ", topicLength=" + this.getTopicLength() + ", kickLength=" + this.getKickLength() + ", channelLength=" + this.getChannelLength() + ", channelIDLength=" + this.getChannelIDLength() + ", standard=" + this.getStandard() + ", silence=" + this.getSilence() + ", RFC2812=" + this.isRFC2812() + ", penalty=" + this.isPenalty() + ", forcedNickChanges=" + this.isForcedNickChanges() + ", safeList=" + this.isSafeList() + ", awayLength=" + this.getAwayLength() + ", noQuit=" + this.isNoQuit() + ", userIPExists=" + this.isUserIPExists() + ", cPrivMsgExists=" + this.isCPrivMsgExists() + ", cNoticeExists=" + this.isCNoticeExists() + ", maxTargets=" + this.getMaxTargets() + ", knockExists=" + this.isKnockExists() + ", vChannels=" + this.isVChannels() + ", watchMax=" + this.getWatchMax() + ", whoX=" + this.isWhoX() + ", callerID=" + this.isCallerID() + ", accept=" + this.isAccept() + ", language=" + this.getLanguage() + ", extBanPrefix=" + this.getExtBanPrefix() + ", extBanList=" + this.getExtBanList() + ", motd=" + this.getMotd() + ", highestConnections=" + this.getHighestConnections() + ", highestClients=" + this.getHighestClients() + ", totalUsers=" + this.getTotalUsers() + ", totalInvisibleUsers=" + this.getTotalInvisibleUsers() + ", totalServers=" + this.getTotalServers() + ", totalOperatorsOnline=" + this.getTotalOperatorsOnline() + ", totalUnknownConnections=" + this.getTotalUnknownConnections() + ", totalChannelsFormed=" + this.getTotalChannelsFormed() + ", serverUsers=" + this.getServerUsers() + ", connectedServers=" + this.getConnectedServers() + ")";
    }

    protected void setMotd(String motd) {
        this.motd = motd;
    }
}

