/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.pircbotx.Configuration;
import org.pircbotx.PircBotX;
import org.pircbotx.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBotManager {
    private static final Logger log = LoggerFactory.getLogger(MultiBotManager.class);
    protected static final AtomicInteger MANAGER_COUNT = new AtomicInteger();
    protected final int managerNumber;
    protected final LinkedHashMap<PircBotX, ListenableFuture<Void>> runningBots = new LinkedHashMap();
    protected final BiMap<PircBotX, Integer> runningBotsNumbers = HashBiMap.create();
    protected final Object runningBotsLock = new Object[0];
    protected final ListeningExecutorService botPool;
    protected List<PircBotX> startQueue = new ArrayList<PircBotX>();
    protected Service.State state = Service.State.NEW;
    protected final Object stateLock = new Object[0];

    public MultiBotManager() {
        this.managerNumber = MANAGER_COUNT.getAndIncrement();
        ThreadPoolExecutor defaultPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        defaultPool.allowCoreThreadTimeOut(true);
        this.botPool = MoreExecutors.listeningDecorator((ExecutorService)defaultPool);
    }

    public MultiBotManager(ExecutorService botPool) {
        Preconditions.checkNotNull((Object)botPool, (Object)"Bot pool cannot be null");
        this.botPool = MoreExecutors.listeningDecorator((ExecutorService)botPool);
        this.managerNumber = MANAGER_COUNT.getAndIncrement();
    }

    public void addBot(Configuration config) {
        this.addNetwork(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetwork(Configuration config) {
        Object object = this.stateLock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)config, (Object)"Configuration cannot be null");
            if (this.state != Service.State.NEW && this.state != Service.State.RUNNING) {
                throw new RuntimeException("MultiBotManager is not running. State: " + this.state);
            }
            this.addNetwork(new PircBotX(config));
        }
    }

    public void addBot(PircBotX bot) {
        this.addNetwork(bot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetwork(PircBotX bot) {
        Object object = this.stateLock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)bot, (Object)"Bot cannot be null");
            Preconditions.checkArgument((!bot.isConnected() ? 1 : 0) != 0, (Object)"Bot must not already be connected");
            if (this.state == Service.State.NEW) {
                log.debug("Not started yet, add to queue");
                this.startQueue.add(bot);
            } else if (this.state == Service.State.RUNNING) {
                log.debug("Already running, start bot immediately");
                this.startBot(bot);
            } else {
                throw new RuntimeException("MultiBotManager is not running. State: " + this.state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != Service.State.NEW) {
                throw new RuntimeException("MultiBotManager has already been started. State: " + this.state);
            }
            this.state = Service.State.STARTING;
        }
        for (PircBotX bot : this.startQueue) {
            this.startBot(bot);
        }
        this.startQueue.clear();
        object = this.stateLock;
        synchronized (object) {
            this.state = Service.State.RUNNING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenableFuture<Void> startBot(PircBotX bot) {
        Preconditions.checkNotNull((Object)bot, (Object)"Bot cannot be null");
        ListenableFuture future = this.botPool.submit((Callable)new BotRunner(bot));
        Object object = this.runningBotsLock;
        synchronized (object) {
            this.runningBots.put(bot, (ListenableFuture<Void>)future);
            this.runningBotsNumbers.put((Object)bot, (Object)bot.getBotId());
        }
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new BotFutureCallback(bot), (Executor)MoreExecutors.directExecutor());
        return future;
    }

    public void stop() {
        this.stop("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String quitMessage) {
        Iterator<PircBotX> iterator = this.stateLock;
        synchronized (iterator) {
            if (this.state != Service.State.RUNNING) {
                throw new RuntimeException("MultiBotManager cannot be stopped again or before starting. State: " + this.state);
            }
            this.state = Service.State.STOPPING;
        }
        for (PircBotX bot : this.runningBots.keySet()) {
            if (!bot.isConnected()) continue;
            bot.sendIRC().quitServer(quitMessage);
        }
        this.botPool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAndWait() throws InterruptedException {
        this.stop();
        Joiner commaJoiner = Joiner.on((String)", ");
        do {
            Object object = this.runningBotsLock;
            synchronized (object) {
                log.debug("Waiting 5 seconds for bot(s) [{}] to terminate ", (Object)commaJoiner.join(this.runningBots.values()));
            }
        } while (!this.botPool.awaitTermination(5L, TimeUnit.SECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedSet<PircBotX> getBots() {
        Object object = this.runningBotsLock;
        synchronized (object) {
            return ImmutableSortedSet.copyOf(this.runningBots.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <B extends PircBotX> B getBotById(int id) {
        Object object = this.runningBotsLock;
        synchronized (object) {
            return (B)((PircBotX)this.runningBotsNumbers.inverse().get((Object)id));
        }
    }

    protected void executeBot(PircBotX bot) throws Exception {
        bot.startBot();
    }

    protected class BotRunner
    implements Callable<Void> {
        @NonNull
        protected final PircBotX bot;

        @Override
        public Void call() throws Exception {
            Thread.currentThread().setName("botPool" + MultiBotManager.this.managerNumber + "-bot" + this.bot.getBotId());
            Utils.addBotToMDC(this.bot);
            MultiBotManager.this.executeBot(this.bot);
            return null;
        }

        public BotRunner(PircBotX bot) {
            if (bot == null) {
                throw new NullPointerException("bot is marked non-null but is null");
            }
            this.bot = bot;
        }
    }

    protected class BotFutureCallback
    implements FutureCallback<Void> {
        protected final Logger log = LoggerFactory.getLogger(this.getClass());
        @NonNull
        protected final PircBotX bot;

        public void onSuccess(Void result) {
            this.log.debug("Bot #" + this.bot.getBotId() + " finished");
            this.remove();
        }

        public void onFailure(Throwable t) {
            this.log.error("Bot exited with Exception", t);
            this.remove();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove() {
            Object object = MultiBotManager.this.runningBotsLock;
            synchronized (object) {
                MultiBotManager.this.runningBots.remove(this.bot);
                MultiBotManager.this.runningBotsNumbers.remove((Object)this.bot);
                if (MultiBotManager.this.runningBots.isEmpty() && MultiBotManager.this.state == Service.State.STOPPING) {
                    Object object2 = MultiBotManager.this.stateLock;
                    synchronized (object2) {
                        if (MultiBotManager.this.state == Service.State.STOPPING) {
                            MultiBotManager.this.state = Service.State.TERMINATED;
                        }
                    }
                }
            }
        }

        public BotFutureCallback(PircBotX bot) {
            if (bot == null) {
                throw new NullPointerException("bot is marked non-null but is null");
            }
            this.bot = bot;
        }
    }
}

