/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.pircbotx.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentServer
implements Closeable,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(IdentServer.class);
    protected static final int DEFAULT_PORT = 113;
    protected static IdentServer server;
    protected static final Object INSTANCE_CREATE_LOCK;
    protected final InetAddress localAddress;
    protected final Charset encoding;
    protected final ServerSocket serverSocket;
    protected final List<IdentEntry> identEntries = new ArrayList<IdentEntry>();
    protected Thread runningThread;
    protected int port;

    public static void startServer() {
        IdentServer.startServer(Charset.defaultCharset(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServer(Charset encoding, InetAddress localAddress) {
        Object object = INSTANCE_CREATE_LOCK;
        synchronized (object) {
            IdentServer.startServer(encoding, localAddress, 113);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void startServer(Charset encoding, InetAddress localAddress, int port) {
        Object object = INSTANCE_CREATE_LOCK;
        synchronized (object) {
            if (server != null) {
                throw new RuntimeException("Already created an IdentServer instance");
            }
            server = new IdentServer(encoding, localAddress, port);
            server.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopServer() throws IOException {
        Object object = INSTANCE_CREATE_LOCK;
        synchronized (object) {
            if (server == null) {
                throw new RuntimeException("Never created an IdentServer");
            }
            server.doClose();
            server = null;
        }
    }

    protected IdentServer(Charset encoding, InetAddress localAddress, int port) {
        try {
            this.encoding = encoding;
            this.localAddress = localAddress;
            this.serverSocket = new ServerSocket(port, 50, localAddress);
            this.port = port;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create server socket for IdentServer on " + localAddress.toString() + ", port " + port, e);
        }
    }

    public void start() {
        this.runningThread = new Thread(this);
        this.runningThread.setName("IdentServer");
        this.runningThread.start();
    }

    @Override
    public void run() {
        log.info("IdentServer running on port " + this.serverSocket.getLocalPort());
        while (!this.serverSocket.isClosed()) {
            Socket socket = null;
            try {
                String line;
                socket = this.serverSocket.accept();
                BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), this.encoding));
                OutputStreamWriter writer = new OutputStreamWriter(socket.getOutputStream(), this.encoding);
                InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
                String response = this.handleNextConnection(remoteAddress, line = reader.readLine());
                if (response == null) continue;
                writer.write(response);
                writer.flush();
            }
            catch (Exception e) {
                if (this.serverSocket.isClosed()) {
                    log.debug("Server socket closed, exiting connection loop");
                    return;
                }
                throw new RuntimeException("Exception encountered when opening user socket", e);
            }
            finally {
                try {
                    if (socket == null) continue;
                    socket.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception encountered when closing user socket", e);
                }
            }
        }
        if (!this.serverSocket.isClosed()) {
            try {
                this.close();
            }
            catch (IOException e) {
                log.error("Cannot close IdentServer socket", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleNextConnection(InetSocketAddress remoteAddress, String line) throws IOException {
        String response;
        if (StringUtils.isBlank((CharSequence)line)) {
            log.error("Ignoring connection from " + remoteAddress + ", received blank line");
            return null;
        }
        String[] parsedLine = StringUtils.split((String)line, (String)", ");
        if (parsedLine.length != 2) {
            log.error("Ignoring connection from " + remoteAddress + ", recieved unknown line: " + line);
            return null;
        }
        int localPort = Utils.tryParseInt(parsedLine[0], -1);
        int remotePort = Utils.tryParseInt(parsedLine[1], -1);
        if (localPort == -1 || remotePort == -1) {
            log.error("Ignoring connection from " + remoteAddress + ", recieved unparsable line: " + line);
            return null;
        }
        log.debug("Received ident request from " + remoteAddress + ": " + line);
        IdentEntry identEntry = null;
        List<IdentEntry> list = this.identEntries;
        synchronized (list) {
            for (IdentEntry curIdentEntry : this.identEntries) {
                if (!curIdentEntry.getRemoteAddress().equals(remoteAddress.getAddress()) || curIdentEntry.getRemotePort() != remotePort || curIdentEntry.getLocalPort() != localPort) continue;
                identEntry = curIdentEntry;
                break;
            }
        }
        if (identEntry == null) {
            response = localPort + ", " + remotePort + " : ERROR : NO-USER";
            log.error("Unknown ident " + line + " from " + remoteAddress + ", responding with: " + response);
            return response;
        }
        response = line + " : USERID : UNIX : " + identEntry.getLogin();
        log.debug("Responded to ident request from " + remoteAddress + " with: " + response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addIdentEntry(InetAddress remoteAddress, int remotePort, int localPort, String login) {
        List<IdentEntry> list = this.identEntries;
        synchronized (list) {
            log.debug("Added ident entry for address " + remoteAddress + " on port " + remotePort + " for local port " + localPort + " for " + login);
            this.identEntries.add(new IdentEntry(remoteAddress, remotePort, localPort, login));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeIdentEntry(InetAddress remoteAddress, int remotePort, int localPort, String login) {
        List<IdentEntry> list = this.identEntries;
        synchronized (list) {
            log.debug("Removed ident entry for address " + remoteAddress + " on port " + remotePort + " for local port " + localPort + " for " + login);
            Iterator<IdentEntry> itr = this.identEntries.iterator();
            while (itr.hasNext()) {
                IdentEntry curEntry = itr.next();
                if (!curEntry.getRemoteAddress().equals(remoteAddress) || curEntry.getRemotePort() != remotePort || curEntry.getLocalPort() != localPort || !curEntry.getLogin().equals(login)) continue;
                itr.remove();
            }
        }
    }

    protected int getPort() {
        Preconditions.checkState((!this.serverSocket.isClosed() ? 1 : 0) != 0, (Object)"Server socket is not open");
        return this.serverSocket.getLocalPort();
    }

    @Override
    public void close() throws IOException {
        IdentServer.stopServer();
    }

    protected void doClose() throws IOException {
        this.serverSocket.close();
        this.identEntries.clear();
        log.info("Closed ident server on port " + this.port + "/" + this.serverSocket.getLocalPort());
    }

    protected static void setServer(IdentServer server) {
        IdentServer.server = server;
    }

    protected static IdentServer getServer() {
        return server;
    }

    static {
        INSTANCE_CREATE_LOCK = new Object();
    }

    protected static class IdentEntry {
        protected final InetAddress remoteAddress;
        protected final int remotePort;
        protected final int localPort;
        protected final String login;

        public IdentEntry(InetAddress remoteAddress, int remotePort, int localPort, String login) {
            this.remoteAddress = remoteAddress;
            this.remotePort = remotePort;
            this.localPort = localPort;
            this.login = login;
        }

        public InetAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        public int getRemotePort() {
            return this.remotePort;
        }

        public int getLocalPort() {
            return this.localPort;
        }

        public String getLogin() {
            return this.login;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdentEntry)) {
                return false;
            }
            IdentEntry other = (IdentEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRemotePort() != other.getRemotePort()) {
                return false;
            }
            if (this.getLocalPort() != other.getLocalPort()) {
                return false;
            }
            InetAddress this$remoteAddress = this.getRemoteAddress();
            InetAddress other$remoteAddress = other.getRemoteAddress();
            if (this$remoteAddress == null ? other$remoteAddress != null : !((Object)this$remoteAddress).equals(other$remoteAddress)) {
                return false;
            }
            String this$login = this.getLogin();
            String other$login = other.getLogin();
            return !(this$login == null ? other$login != null : !this$login.equals(other$login));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IdentEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRemotePort();
            result = result * 59 + this.getLocalPort();
            InetAddress $remoteAddress = this.getRemoteAddress();
            result = result * 59 + ($remoteAddress == null ? 43 : ((Object)$remoteAddress).hashCode());
            String $login = this.getLogin();
            result = result * 59 + ($login == null ? 43 : $login.hashCode());
            return result;
        }

        public String toString() {
            return "IdentServer.IdentEntry(remoteAddress=" + this.getRemoteAddress() + ", remotePort=" + this.getRemotePort() + ", localPort=" + this.getLocalPort() + ", login=" + this.getLogin() + ")";
        }
    }
}

