/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot.v2;

import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.ircbot.v2.IRCConnection;
import hudson.plugins.ircbot.v2.PircListener;

public class IRCPrivateChat
implements IMChat {
    private final PircListener listener;
    private final String nick;
    private final String chatPartner;
    private final IRCConnection connection;

    public IRCPrivateChat(IRCConnection connection, PircListener listener, String nick, String chatPartner) {
        this.connection = connection;
        this.listener = listener;
        this.nick = nick;
        this.chatPartner = chatPartner;
    }

    public String getNickName(String senderId) {
        return senderId;
    }

    public String getIMId(String senderId) {
        return senderId;
    }

    public boolean isMultiUserChat() {
        return false;
    }

    public boolean isCommandsAccepted() {
        return true;
    }

    public void addMessageListener(IMMessageListener listener) {
        this.listener.addMessageListener(this.nick, this.chatPartner, listener);
    }

    public void removeMessageListener(IMMessageListener listener) {
        this.listener.removeMessageListener(this.nick, listener);
    }

    public void sendMessage(String message) throws IMException {
        this.connection.send(this.chatPartner, message);
    }
}

