/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.output;

import com.google.common.base.Joiner;
import java.net.InetAddress;
import org.pircbotx.PircBotX;
import org.pircbotx.dcc.DccHandler;

public class OutputDCC {
    protected static final Joiner SPACE_JOINER = Joiner.on((char)' ');
    protected final PircBotX bot;

    public void dcc(String target, String service, Object ... parameters) {
        this.bot.sendIRC().ctcpCommand(target, SPACE_JOINER.join((Object)"DCC", (Object)service, parameters));
    }

    public void fileRequest(String target, String filename, InetAddress senderAddress, int senderPort, long filesize) {
        this.dcc(target, "SEND", filename, DccHandler.addressToInteger(senderAddress), senderPort, filesize);
    }

    public void fileResumeRequest(String target, String filename, int senderPort, long position) {
        this.dcc(target, "RESUME", filename, senderPort, position);
    }

    public void fileResumeAccept(String target, String filename, int senderPort, long position) {
        this.dcc(target, "ACCEPT", filename, senderPort, position);
    }

    public void filePassiveRequest(String target, String filename, InetAddress senderAddress, long filesize, String transferToken) {
        this.dcc(target, "SEND", filename, DccHandler.addressToInteger(senderAddress), 0, filesize, transferToken);
    }

    public void filePassiveAccept(String target, String filename, InetAddress receiverAddress, int receiverPort, long filesize, String transferToken) {
        this.dcc(target, "SEND", filename, DccHandler.addressToInteger(receiverAddress), receiverPort, filesize, transferToken);
    }

    public void filePassiveResumeRequest(String target, String filename, long position, String transferToken) {
        this.dcc(target, "RESUME", filename, 0, position, transferToken);
    }

    public void filePassiveResumeAccept(String target, String filename, long position, String transferToken) {
        this.dcc(target, "ACCEPT", filename, 0, position, transferToken);
    }

    public void chatRequest(String target, InetAddress address, int port) {
        this.dcc(target, "CHAT", "chat", DccHandler.addressToInteger(address), port);
    }

    public void chatPassiveRequest(String target, InetAddress address, String chatToken) {
        this.dcc(target, "CHAT", "chat", DccHandler.addressToInteger(address), 0, chatToken);
    }

    public void chatPassiveAccept(String target, InetAddress address, int port, String chatToken) {
        this.dcc(target, "CHAT", "chat", DccHandler.addressToInteger(address), port, chatToken);
    }

    public OutputDCC(PircBotX bot) {
        this.bot = bot;
    }
}

