/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.managers;

import org.pircbotx.PircBotX;
import org.pircbotx.Utils;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.Listener;
import org.pircbotx.hooks.events.ExceptionEvent;
import org.pircbotx.hooks.events.ListenerExceptionEvent;
import org.pircbotx.hooks.managers.ListenerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractListenerManager
implements ListenerManager {
    private static final Logger log = LoggerFactory.getLogger(ListenerManager.class);
    private final Logger sublog = LoggerFactory.getLogger(this.getClass());

    protected void executeListener(Listener listener, Event event) {
        this.executeListener(listener, event, "Failed in " + this.getClass().getName());
    }

    protected void executeListener(Listener listener, Event event, String debug) {
        try {
            listener.onEvent(event);
        }
        catch (Exception listenerException) {
            if (event instanceof ExceptionEvent) {
                log.error("Encountered exception while processing {}, NOT dispatching another ExceptionEvent to stop potential StackOverflow", event.getClass(), (Object)listenerException);
            }
            this.onEvent(new ListenerExceptionEvent((PircBotX)event.getBot(), listenerException, debug, listener, event));
        }
    }

    @Override
    public void onEvent(Event event) {
        if (event.getBot() != null) {
            Utils.addBotToMDC(event.getBot());
        }
        this.sublog.debug("Recieved event " + event);
    }

    protected static class ExecuteListenerRunnable
    implements Runnable {
        protected final AbstractListenerManager listenerManager;
        protected final Listener listener;
        protected final Event event;

        @Override
        public void run() {
            this.listenerManager.executeListener(this.listener, this.event);
        }

        public ExecuteListenerRunnable(AbstractListenerManager listenerManager, Listener listener, Event event) {
            this.listenerManager = listenerManager;
            this.listener = listener;
            this.event = event;
        }
    }
}

