/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableList;
import lombok.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.Event;

public class WhoisEvent
extends Event {
    @NonNull
    protected final String nick;
    @NonNull
    protected final String login;
    @NonNull
    protected final String hostname;
    @NonNull
    protected final String realname;
    @NonNull
    protected final ImmutableList<String> channels;
    @NonNull
    protected final String server;
    @NonNull
    protected final String serverInfo;
    protected final long idleSeconds;
    protected final long signOnTime;
    protected final String registeredAs;
    protected final boolean exists;
    protected final String awayMessage;
    protected final boolean secureConnection;
    protected final boolean ircOp;

    WhoisEvent(PircBotX bot, @NonNull Builder builder) {
        super(bot);
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.nick = builder.nick;
        this.login = builder.login;
        this.hostname = builder.hostname;
        this.realname = builder.realname;
        this.channels = builder.channels;
        this.server = builder.server;
        this.serverInfo = builder.serverInfo;
        this.idleSeconds = builder.idleSeconds;
        this.signOnTime = builder.signOnTime;
        this.registeredAs = builder.registeredAs;
        this.exists = builder.exists;
        this.awayMessage = builder.awayMessage;
        this.secureConnection = builder.secureConnection;
        this.ircOp = builder.ircOp;
    }

    public static Builder builder() {
        return new Builder().channels((ImmutableList<String>)ImmutableList.of());
    }

    public boolean isRegistered() {
        return this.registeredAs != null;
    }

    @Override
    public void respond(String response) {
        ((PircBotX)this.getBot()).sendIRC().message(this.getNick(), response);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhoisEvent)) {
            return false;
        }
        WhoisEvent other = (WhoisEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getIdleSeconds() != other.getIdleSeconds()) {
            return false;
        }
        if (this.getSignOnTime() != other.getSignOnTime()) {
            return false;
        }
        if (this.isExists() != other.isExists()) {
            return false;
        }
        if (this.isSecureConnection() != other.isSecureConnection()) {
            return false;
        }
        if (this.isIrcOp() != other.isIrcOp()) {
            return false;
        }
        String this$nick = this.getNick();
        String other$nick = other.getNick();
        if (this$nick == null ? other$nick != null : !this$nick.equals(other$nick)) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$realname = this.getRealname();
        String other$realname = other.getRealname();
        if (this$realname == null ? other$realname != null : !this$realname.equals(other$realname)) {
            return false;
        }
        ImmutableList<String> this$channels = this.getChannels();
        ImmutableList<String> other$channels = other.getChannels();
        if (this$channels == null ? other$channels != null : !this$channels.equals(other$channels)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$serverInfo = this.getServerInfo();
        String other$serverInfo = other.getServerInfo();
        if (this$serverInfo == null ? other$serverInfo != null : !this$serverInfo.equals(other$serverInfo)) {
            return false;
        }
        String this$registeredAs = this.getRegisteredAs();
        String other$registeredAs = other.getRegisteredAs();
        if (this$registeredAs == null ? other$registeredAs != null : !this$registeredAs.equals(other$registeredAs)) {
            return false;
        }
        String this$awayMessage = this.getAwayMessage();
        String other$awayMessage = other.getAwayMessage();
        return !(this$awayMessage == null ? other$awayMessage != null : !this$awayMessage.equals(other$awayMessage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WhoisEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $idleSeconds = this.getIdleSeconds();
        result = result * 59 + (int)($idleSeconds >>> 32 ^ $idleSeconds);
        long $signOnTime = this.getSignOnTime();
        result = result * 59 + (int)($signOnTime >>> 32 ^ $signOnTime);
        result = result * 59 + (this.isExists() ? 79 : 97);
        result = result * 59 + (this.isSecureConnection() ? 79 : 97);
        result = result * 59 + (this.isIrcOp() ? 79 : 97);
        String $nick = this.getNick();
        result = result * 59 + ($nick == null ? 43 : $nick.hashCode());
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $realname = this.getRealname();
        result = result * 59 + ($realname == null ? 43 : $realname.hashCode());
        ImmutableList<String> $channels = this.getChannels();
        result = result * 59 + ($channels == null ? 43 : $channels.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $serverInfo = this.getServerInfo();
        result = result * 59 + ($serverInfo == null ? 43 : $serverInfo.hashCode());
        String $registeredAs = this.getRegisteredAs();
        result = result * 59 + ($registeredAs == null ? 43 : $registeredAs.hashCode());
        String $awayMessage = this.getAwayMessage();
        result = result * 59 + ($awayMessage == null ? 43 : $awayMessage.hashCode());
        return result;
    }

    @NonNull
    public String getNick() {
        return this.nick;
    }

    @NonNull
    public String getLogin() {
        return this.login;
    }

    @NonNull
    public String getHostname() {
        return this.hostname;
    }

    @NonNull
    public String getRealname() {
        return this.realname;
    }

    @NonNull
    public ImmutableList<String> getChannels() {
        return this.channels;
    }

    @NonNull
    public String getServer() {
        return this.server;
    }

    @NonNull
    public String getServerInfo() {
        return this.serverInfo;
    }

    public long getIdleSeconds() {
        return this.idleSeconds;
    }

    public long getSignOnTime() {
        return this.signOnTime;
    }

    public String getRegisteredAs() {
        return this.registeredAs;
    }

    public boolean isExists() {
        return this.exists;
    }

    public String getAwayMessage() {
        return this.awayMessage;
    }

    public boolean isSecureConnection() {
        return this.secureConnection;
    }

    public boolean isIrcOp() {
        return this.ircOp;
    }

    public static class Builder {
        private String nick;
        private String login;
        private String hostname;
        private String realname;
        private ImmutableList<String> channels;
        private String server;
        private String serverInfo;
        private long idleSeconds;
        private long signOnTime;
        private String registeredAs;
        private boolean exists;
        private String awayMessage;
        private boolean secureConnection;
        private boolean ircOp;

        public WhoisEvent generateEvent(PircBotX bot) {
            return new WhoisEvent(bot, this);
        }

        Builder() {
        }

        public Builder nick(@NonNull String nick) {
            if (nick == null) {
                throw new NullPointerException("nick is marked non-null but is null");
            }
            this.nick = nick;
            return this;
        }

        public Builder login(@NonNull String login) {
            if (login == null) {
                throw new NullPointerException("login is marked non-null but is null");
            }
            this.login = login;
            return this;
        }

        public Builder hostname(@NonNull String hostname) {
            if (hostname == null) {
                throw new NullPointerException("hostname is marked non-null but is null");
            }
            this.hostname = hostname;
            return this;
        }

        public Builder realname(@NonNull String realname) {
            if (realname == null) {
                throw new NullPointerException("realname is marked non-null but is null");
            }
            this.realname = realname;
            return this;
        }

        public Builder channels(@NonNull ImmutableList<String> channels) {
            if (channels == null) {
                throw new NullPointerException("channels is marked non-null but is null");
            }
            this.channels = channels;
            return this;
        }

        public Builder server(@NonNull String server) {
            if (server == null) {
                throw new NullPointerException("server is marked non-null but is null");
            }
            this.server = server;
            return this;
        }

        public Builder serverInfo(@NonNull String serverInfo) {
            if (serverInfo == null) {
                throw new NullPointerException("serverInfo is marked non-null but is null");
            }
            this.serverInfo = serverInfo;
            return this;
        }

        public Builder idleSeconds(long idleSeconds) {
            this.idleSeconds = idleSeconds;
            return this;
        }

        public Builder signOnTime(long signOnTime) {
            this.signOnTime = signOnTime;
            return this;
        }

        public Builder registeredAs(String registeredAs) {
            this.registeredAs = registeredAs;
            return this;
        }

        public Builder exists(boolean exists) {
            this.exists = exists;
            return this;
        }

        public Builder awayMessage(String awayMessage) {
            this.awayMessage = awayMessage;
            return this;
        }

        public Builder secureConnection(boolean secureConnection) {
            this.secureConnection = secureConnection;
            return this;
        }

        public Builder ircOp(boolean ircOp) {
            this.ircOp = ircOp;
            return this;
        }

        public String toString() {
            return "WhoisEvent.Builder(nick=" + this.nick + ", login=" + this.login + ", hostname=" + this.hostname + ", realname=" + this.realname + ", channels=" + this.channels + ", server=" + this.server + ", serverInfo=" + this.serverInfo + ", idleSeconds=" + this.idleSeconds + ", signOnTime=" + this.signOnTime + ", registeredAs=" + this.registeredAs + ", exists=" + this.exists + ", awayMessage=" + this.awayMessage + ", secureConnection=" + this.secureConnection + ", ircOp=" + this.ircOp + ")";
        }
    }
}

