/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableList;
import lombok.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.Event;

public class ServerResponseEvent
extends Event {
    protected final int code;
    protected final String rawLine;
    protected final ImmutableList<String> parsedResponse;

    public ServerResponseEvent(PircBotX bot, int code, @NonNull String rawLine, @NonNull ImmutableList<String> parsedResponse) {
        super(bot);
        if (rawLine == null) {
            throw new NullPointerException("rawLine is marked non-null but is null");
        }
        if (parsedResponse == null) {
            throw new NullPointerException("parsedResponse is marked non-null but is null");
        }
        this.code = code;
        this.rawLine = rawLine;
        this.parsedResponse = parsedResponse;
    }

    @Override
    public void respond(String response) {
        ((PircBotX)this.getBot()).sendRaw().rawLine(response);
    }

    public int getCode() {
        return this.code;
    }

    public String getRawLine() {
        return this.rawLine;
    }

    public ImmutableList<String> getParsedResponse() {
        return this.parsedResponse;
    }

    public String toString() {
        return "ServerResponseEvent(code=" + this.getCode() + ", rawLine=" + this.getRawLine() + ", parsedResponse=" + this.getParsedResponse() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerResponseEvent)) {
            return false;
        }
        ServerResponseEvent other = (ServerResponseEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$rawLine = this.getRawLine();
        String other$rawLine = other.getRawLine();
        if (this$rawLine == null ? other$rawLine != null : !this$rawLine.equals(other$rawLine)) {
            return false;
        }
        ImmutableList<String> this$parsedResponse = this.getParsedResponse();
        ImmutableList<String> other$parsedResponse = other.getParsedResponse();
        return !(this$parsedResponse == null ? other$parsedResponse != null : !this$parsedResponse.equals(other$parsedResponse));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ServerResponseEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCode();
        String $rawLine = this.getRawLine();
        result = result * 59 + ($rawLine == null ? 43 : $rawLine.hashCode());
        ImmutableList<String> $parsedResponse = this.getParsedResponse();
        result = result * 59 + ($parsedResponse == null ? 43 : $parsedResponse.hashCode());
        return result;
    }
}

