/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.types.GenericMessageEvent;

public class PrivateMessageEvent
extends Event
implements GenericMessageEvent {
    protected final UserHostmask userHostmask;
    protected final User user;
    protected final String message;
    protected final ImmutableMap<String, String> tags;

    public PrivateMessageEvent(PircBotX bot, @NonNull UserHostmask userHostmask, User user, @NonNull String message, ImmutableMap<String, String> tags) {
        super(bot);
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.userHostmask = userHostmask;
        this.user = user;
        this.message = message;
        this.tags = tags;
    }

    @Override
    public void respond(String response) {
        this.respondWith(response);
    }

    @Override
    public void respondWith(String fullLine) {
        this.getUser().send().message(fullLine);
    }

    @Override
    public void respondPrivateMessage(String message) {
        this.respond(message);
    }

    @Override
    public ImmutableMap<String, String> getV3Tags() {
        return this.tags;
    }

    public ImmutableMap<String, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "PrivateMessageEvent(userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ", message=" + this.getMessage() + ", tags=" + this.getTags() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrivateMessageEvent)) {
            return false;
        }
        PrivateMessageEvent other = (PrivateMessageEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        ImmutableMap<String, String> this$tags = this.getTags();
        ImmutableMap<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !this$tags.equals(other$tags));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PrivateMessageEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        ImmutableMap<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        return result;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

