/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import javax.annotation.Nullable;
import lombok.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.Event;

public class NickAlreadyInUseEvent
extends Event {
    protected final String usedNick;
    protected final String autoNewNick;
    protected final boolean autoNickChange;

    public NickAlreadyInUseEvent(PircBotX bot, @NonNull String usedNick, @Nullable String autoNewNick, boolean autoNickChange) {
        super(bot);
        if (usedNick == null) {
            throw new NullPointerException("usedNick is marked non-null but is null");
        }
        this.usedNick = usedNick;
        this.autoNewNick = autoNewNick;
        this.autoNickChange = autoNickChange;
    }

    @Override
    public void respond(@Nullable String newNick) {
        ((PircBotX)this.getBot()).sendIRC().changeNick(newNick);
    }

    public String getUsedNick() {
        return this.usedNick;
    }

    public String getAutoNewNick() {
        return this.autoNewNick;
    }

    public boolean isAutoNickChange() {
        return this.autoNickChange;
    }

    public String toString() {
        return "NickAlreadyInUseEvent(usedNick=" + this.getUsedNick() + ", autoNewNick=" + this.getAutoNewNick() + ", autoNickChange=" + this.isAutoNickChange() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NickAlreadyInUseEvent)) {
            return false;
        }
        NickAlreadyInUseEvent other = (NickAlreadyInUseEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAutoNickChange() != other.isAutoNickChange()) {
            return false;
        }
        String this$usedNick = this.getUsedNick();
        String other$usedNick = other.getUsedNick();
        if (this$usedNick == null ? other$usedNick != null : !this$usedNick.equals(other$usedNick)) {
            return false;
        }
        String this$autoNewNick = this.getAutoNewNick();
        String other$autoNewNick = other.getAutoNewNick();
        return !(this$autoNewNick == null ? other$autoNewNick != null : !this$autoNewNick.equals(other$autoNewNick));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NickAlreadyInUseEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAutoNickChange() ? 79 : 97);
        String $usedNick = this.getUsedNick();
        result = result * 59 + ($usedNick == null ? 43 : $usedNick.hashCode());
        String $autoNewNick = this.getAutoNewNick();
        result = result * 59 + ($autoNewNick == null ? 43 : $autoNewNick.hashCode());
        return result;
    }
}

