/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import javax.annotation.Nullable;
import lombok.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.types.GenericUserEvent;

public class InviteEvent
extends Event
implements GenericUserEvent {
    protected final User user;
    protected final UserHostmask userHostmask;
    protected final String channel;

    public InviteEvent(PircBotX bot, @NonNull UserHostmask userHostmask, User user, @NonNull String channel) {
        super(bot);
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.user = user;
        this.userHostmask = userHostmask;
        this.channel = channel;
    }

    @Override
    public void respond(String response) {
        this.getUserHostmask().send().message(response);
    }

    public String getChannel() {
        return this.channel;
    }

    public String toString() {
        return "InviteEvent(user=" + this.getUser() + ", userHostmask=" + this.getUserHostmask() + ", channel=" + this.getChannel() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InviteEvent)) {
            return false;
        }
        InviteEvent other = (InviteEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        return !(this$channel == null ? other$channel != null : !this$channel.equals(other$channel));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InviteEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        return result;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }
}

