/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import java.net.InetAddress;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.dcc.FileTransferStatus;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.types.GenericDCCEvent;

public class FileTransferCompleteEvent
extends Event
implements GenericDCCEvent {
    protected final User user;
    protected final FileTransferStatus transferStatus;
    protected final String fileName;
    protected final InetAddress address;
    protected final int port;
    protected final long filesize;
    protected final boolean passive;
    protected final boolean outbound;

    public FileTransferCompleteEvent(PircBotX bot, @NonNull FileTransferStatus transferStatus, User user, @NonNull String fileName, InetAddress address, int port, long filesize, boolean passive, boolean outbound) {
        super(bot);
        if (transferStatus == null) {
            throw new NullPointerException("transferStatus is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        this.user = user;
        this.transferStatus = transferStatus;
        this.fileName = fileName;
        this.address = address;
        this.port = port;
        this.filesize = filesize;
        this.passive = passive;
        this.outbound = outbound;
    }

    @Override
    public void respond(String response) {
        this.getUser().send().message(response);
    }

    @Override
    public String getToken() {
        return null;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return null;
    }

    public String toString() {
        return "FileTransferCompleteEvent(user=" + this.getUser() + ", transferStatus=" + this.getTransferStatus() + ", fileName=" + this.getFileName() + ", address=" + this.getAddress() + ", port=" + this.getPort() + ", filesize=" + this.getFilesize() + ", passive=" + this.isPassive() + ", outbound=" + this.isOutbound() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileTransferCompleteEvent)) {
            return false;
        }
        FileTransferCompleteEvent other = (FileTransferCompleteEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getFilesize() != other.getFilesize()) {
            return false;
        }
        if (this.isPassive() != other.isPassive()) {
            return false;
        }
        if (this.isOutbound() != other.isOutbound()) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        FileTransferStatus this$transferStatus = this.getTransferStatus();
        FileTransferStatus other$transferStatus = other.getTransferStatus();
        if (this$transferStatus == null ? other$transferStatus != null : !this$transferStatus.equals(other$transferStatus)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        InetAddress this$address = this.getAddress();
        InetAddress other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FileTransferCompleteEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPort();
        long $filesize = this.getFilesize();
        result = result * 59 + (int)($filesize >>> 32 ^ $filesize);
        result = result * 59 + (this.isPassive() ? 79 : 97);
        result = result * 59 + (this.isOutbound() ? 79 : 97);
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        FileTransferStatus $transferStatus = this.getTransferStatus();
        result = result * 59 + ($transferStatus == null ? 43 : $transferStatus.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        InetAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    public FileTransferStatus getTransferStatus() {
        return this.transferStatus;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public long getFilesize() {
        return this.filesize;
    }

    @Override
    public boolean isPassive() {
        return this.passive;
    }

    public boolean isOutbound() {
        return this.outbound;
    }
}

