/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.Listener;
import org.pircbotx.hooks.types.GenericEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForQueue
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(WaitForQueue.class);
    protected final PircBotX bot;
    protected LinkedBlockingQueue<Event> eventQueue = new LinkedBlockingQueue();
    protected WaitForQueueListener listener;

    public WaitForQueue(@NonNull PircBotX bot) {
        if (bot == null) {
            throw new NullPointerException("bot is marked non-null but is null");
        }
        this.bot = bot;
        this.listener = new WaitForQueueListener();
        bot.getConfiguration().getListenerManager().addListener(this.listener);
    }

    WaitForQueue() {
        this.bot = null;
    }

    public <E extends GenericEvent> E waitFor(@NonNull Class<E> eventClass) throws InterruptedException {
        if (eventClass == null) {
            throw new NullPointerException("eventClass is marked non-null but is null");
        }
        return this.waitFor(eventClass, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public <E extends GenericEvent> Event waitFor(Class<? extends E> ... eventClasses) throws InterruptedException {
        if (eventClasses == null) {
            throw new NullPointerException("eventClasses is marked non-null but is null");
        }
        return this.waitFor(Arrays.asList(eventClasses));
    }

    public <E extends GenericEvent> Event waitFor(@NonNull List<Class<? extends E>> eventClasses) throws InterruptedException {
        if (eventClasses == null) {
            throw new NullPointerException("eventClasses is marked non-null but is null");
        }
        return this.waitFor(eventClasses, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public <E extends GenericEvent> E waitFor(@NonNull Class<E> eventClass, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        if (eventClass == null) {
            throw new NullPointerException("eventClass is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        ArrayList<Class<E>> eventList = new ArrayList<Class<E>>();
        eventList.add(eventClass);
        return (E)this.waitFor((List)eventList, timeout, unit);
    }

    public <E extends GenericEvent> Event waitFor(@NonNull List<Class<? extends E>> eventClasses, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        Event curEvent;
        if (eventClasses == null) {
            throw new NullPointerException("eventClasses is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        block0: while (true) {
            Class<E> curEventClass;
            if ((curEvent = this.eventQueue.poll(timeout, unit)) == null) {
                return null;
            }
            Iterator<Class<E>> iterator = eventClasses.iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (!(curEventClass = iterator.next()).isInstance(curEvent));
            break;
        }
        return curEvent;
    }

    @Override
    public void close() {
        this.bot.getConfiguration().getListenerManager().removeListener(this.listener);
        this.eventQueue.clear();
    }

    protected class WaitForQueueListener
    implements Listener {
        protected WaitForQueueListener() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            WaitForQueue.this.eventQueue.add(event);
        }
    }
}

