/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.dcc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import org.pircbotx.PircBotX;
import org.pircbotx.dcc.DccHandler;
import org.pircbotx.dcc.DccState;
import org.pircbotx.dcc.FileTransfer;
import org.pircbotx.dcc.ReceiveFileTransferAcknowlegement;
import org.pircbotx.exception.DccException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendFileTransfer
extends FileTransfer {
    private static final Logger log = LoggerFactory.getLogger(SendFileTransfer.class);
    private ReceiveFileTransferAcknowlegement acknowledgement;
    long bytesToTransfer = 8192L;

    public SendFileTransfer(PircBotX bot, DccHandler dccHandler, DccHandler.PendingFileTransfer pendingFileTransfer, File file) {
        super(bot, dccHandler, pendingFileTransfer, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transferFile() {
        try (SocketChannel outChannel = this.socket.getChannel();
             FileInputStream inputStream = new FileInputStream(this.file);
             FileChannel inChannel = inputStream.getChannel();){
            this.acknowledgement = new ReceiveFileTransferAcknowlegement(this.user, this, outChannel, inChannel);
            this.acknowledgement.start();
            this.fileTransferStatus.start();
            inChannel.position(this.fileTransferStatus.startPosition);
            while (inChannel.position() < this.fileTransferStatus.fileSize) {
                if (this.dccHandler.shuttingDown || this.fileTransferStatus.dccState == DccState.SHUTDOWN) {
                    this.acknowledgement.running = false;
                    break;
                }
                if (this.fileTransferStatus.dccState == DccState.ERROR) {
                    throw this.fileTransferStatus.exception;
                }
                if (this.bytesToTransfer > this.fileTransferStatus.fileSize - inChannel.position()) {
                    this.bytesToTransfer = this.fileTransferStatus.fileSize - inChannel.position();
                }
                inChannel.transferTo(inChannel.position(), this.bytesToTransfer, outChannel);
                inChannel.position(inChannel.position() + this.bytesToTransfer);
                this.fileTransferStatus.bytesTransfered = inChannel.position();
            }
            this.fileTransferStatus.dccState = DccState.WAITING;
            log.info("Send file transfer of file {} entered {} state for client acknowledgement", (Object)this.file.getName(), (Object)this.fileTransferStatus.dccState);
            try {
                this.acknowledgement.join();
                this.fileTransferStatus.join();
                this.fileTransferStatus.dccState = DccState.DONE;
            }
            catch (InterruptedException e) {
                this.fileTransferStatus.dccState = DccState.ERROR;
                log.error("Send file transfer of file {} failed to clean up gracefully! Please report this error with logs.", (Object)this.file.getName(), (Object)e);
            }
        }
        catch (IOException e) {
            this.fileTransferStatus.dccState = DccState.ERROR;
            this.fileTransferStatus.exception = new DccException(DccException.Reason.FILE_TRANSFER_CANCELLED, this.user, "User closed socket", e);
        }
        finally {
            log.info("Send file transfer of file {} ended with state {}", (Object)this.file.getName(), (Object)this.fileTransferStatus.dccState);
        }
    }
}

