/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.dcc;

import java.util.concurrent.TimeUnit;
import org.pircbotx.dcc.DccState;
import org.pircbotx.exception.DccException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransferStatus
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(FileTransferStatus.class);
    protected DccState dccState = DccState.INIT;
    protected long startPosition = 0L;
    protected long fileSize = 0L;
    protected long bytesTransfered = 0L;
    protected long bytesAcknowledged = 0L;
    protected long bytesPerSecond = 0L;
    protected long averageBytesPerSecond = 0L;
    protected DccException exception;

    public FileTransferStatus(long fileSize, long startPosition) {
        this.fileSize = fileSize;
        this.startPosition = startPosition;
    }

    public boolean isFinished() {
        return this.dccState == DccState.DONE || this.dccState == DccState.ERROR;
    }

    public boolean isSuccessful() {
        return this.dccState == DccState.DONE && this.bytesAcknowledged == this.fileSize;
    }

    public double getPercentageComplete() {
        return 100.0 * ((double)this.bytesAcknowledged / (double)this.fileSize);
    }

    @Override
    public void run() {
        int counter = 0;
        long myBytesAcknowleged = this.startPosition;
        long myBytesAveraged = 0L;
        long myBytesPerSecond = 0L;
        while (this.dccState == DccState.RUNNING) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                log.error("Speed calculation has interrupted?", (Throwable)e);
            }
            this.bytesPerSecond = this.bytesAcknowledged - myBytesAcknowleged;
            if (this.bytesPerSecond < 0L) continue;
            myBytesPerSecond = this.bytesPerSecond;
            myBytesAveraged = (myBytesPerSecond + myBytesAveraged) / 2L;
            if (++counter >= 3) {
                this.averageBytesPerSecond = (myBytesAveraged + this.averageBytesPerSecond) / 2L;
                counter = 0;
            }
            myBytesAcknowleged = this.bytesAcknowledged;
        }
    }

    public DccState getDccState() {
        return this.dccState;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getBytesTransfered() {
        return this.bytesTransfered;
    }

    public long getBytesAcknowledged() {
        return this.bytesAcknowledged;
    }

    public long getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public long getAverageBytesPerSecond() {
        return this.averageBytesPerSecond;
    }

    public DccException getException() {
        return this.exception;
    }
}

