/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.PeekingIterator;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.pircbotx.Channel;
import org.pircbotx.ChannelListEntry;
import org.pircbotx.ChannelModeHandler;
import org.pircbotx.Configuration;
import org.pircbotx.PircBotX;
import org.pircbotx.ServerInfo;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.UserLevel;
import org.pircbotx.Utils;
import org.pircbotx.cap.CapHandler;
import org.pircbotx.cap.TLSCapHandler;
import org.pircbotx.exception.IrcException;
import org.pircbotx.hooks.events.ActionEvent;
import org.pircbotx.hooks.events.BanListEvent;
import org.pircbotx.hooks.events.ChannelInfoEvent;
import org.pircbotx.hooks.events.ConnectEvent;
import org.pircbotx.hooks.events.FingerEvent;
import org.pircbotx.hooks.events.HalfOpEvent;
import org.pircbotx.hooks.events.InviteEvent;
import org.pircbotx.hooks.events.JoinEvent;
import org.pircbotx.hooks.events.KickEvent;
import org.pircbotx.hooks.events.MessageEvent;
import org.pircbotx.hooks.events.ModeEvent;
import org.pircbotx.hooks.events.MotdEvent;
import org.pircbotx.hooks.events.NickAlreadyInUseEvent;
import org.pircbotx.hooks.events.NickChangeEvent;
import org.pircbotx.hooks.events.NoticeEvent;
import org.pircbotx.hooks.events.OpEvent;
import org.pircbotx.hooks.events.OperFailedEvent;
import org.pircbotx.hooks.events.OperSuccessEvent;
import org.pircbotx.hooks.events.OwnerEvent;
import org.pircbotx.hooks.events.PartEvent;
import org.pircbotx.hooks.events.PingEvent;
import org.pircbotx.hooks.events.PrivateMessageEvent;
import org.pircbotx.hooks.events.QuietListEvent;
import org.pircbotx.hooks.events.QuitEvent;
import org.pircbotx.hooks.events.RemoveChannelBanEvent;
import org.pircbotx.hooks.events.RemoveChannelKeyEvent;
import org.pircbotx.hooks.events.RemoveChannelLimitEvent;
import org.pircbotx.hooks.events.RemoveInviteOnlyEvent;
import org.pircbotx.hooks.events.RemoveModeratedEvent;
import org.pircbotx.hooks.events.RemoveNoExternalMessagesEvent;
import org.pircbotx.hooks.events.RemovePrivateEvent;
import org.pircbotx.hooks.events.RemoveSecretEvent;
import org.pircbotx.hooks.events.RemoveTopicProtectionEvent;
import org.pircbotx.hooks.events.ServerPingEvent;
import org.pircbotx.hooks.events.ServerResponseEvent;
import org.pircbotx.hooks.events.SetChannelBanEvent;
import org.pircbotx.hooks.events.SetChannelKeyEvent;
import org.pircbotx.hooks.events.SetChannelLimitEvent;
import org.pircbotx.hooks.events.SetInviteOnlyEvent;
import org.pircbotx.hooks.events.SetModeratedEvent;
import org.pircbotx.hooks.events.SetNoExternalMessagesEvent;
import org.pircbotx.hooks.events.SetPrivateEvent;
import org.pircbotx.hooks.events.SetSecretEvent;
import org.pircbotx.hooks.events.SetTopicProtectionEvent;
import org.pircbotx.hooks.events.SuperOpEvent;
import org.pircbotx.hooks.events.TimeEvent;
import org.pircbotx.hooks.events.TopicEvent;
import org.pircbotx.hooks.events.UnknownEvent;
import org.pircbotx.hooks.events.UserListEvent;
import org.pircbotx.hooks.events.UserModeEvent;
import org.pircbotx.hooks.events.VersionEvent;
import org.pircbotx.hooks.events.VoiceEvent;
import org.pircbotx.hooks.events.WhoEvent;
import org.pircbotx.hooks.events.WhoisEvent;
import org.pircbotx.snapshot.ChannelSnapshot;
import org.pircbotx.snapshot.UserChannelDaoSnapshot;
import org.pircbotx.snapshot.UserSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class InputParser
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(InputParser.class);
    public static final Marker INPUT_MARKER = MarkerFactory.getMarker((String)"pircbotx.input");
    protected static final ImmutableList<String> CONNECT_CODES = ImmutableList.of((Object)"001", (Object)"002", (Object)"003", (Object)"004", (Object)"005", (Object)"251", (Object)"252", (Object)"253", (Object)"254", (Object)"255", (Object)"375", (Object)"376", (Object[])new String[0]);
    protected static final ImmutableList<ChannelModeHandler> DEFAULT_CHANNEL_MODE_HANDLERS = ImmutableList.builder().add((Object)new OpChannelModeHandler('o', UserLevel.OP){

        @Override
        public void dispatchEvent(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, UserHostmask recipientHostmask, User recipientUser, boolean adding) {
            Utils.dispatchEvent(bot, new OpEvent(bot, channel, sourceHostmask, sourceUser, recipientHostmask, recipientUser, adding));
        }
    }).add((Object)new OpChannelModeHandler('v', UserLevel.VOICE){

        @Override
        public void dispatchEvent(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, UserHostmask recipientHostmask, User recipientUser, boolean adding) {
            Utils.dispatchEvent(bot, new VoiceEvent(bot, channel, sourceHostmask, sourceUser, recipientHostmask, recipientUser, adding));
        }
    }).add((Object)new OpChannelModeHandler('h', UserLevel.HALFOP){

        @Override
        public void dispatchEvent(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, UserHostmask recipientHostmask, User recipientUser, boolean adding) {
            Utils.dispatchEvent(bot, new HalfOpEvent(bot, channel, sourceHostmask, sourceUser, recipientHostmask, recipientUser, adding));
        }
    }).add((Object)new OpChannelModeHandler('a', UserLevel.SUPEROP){

        @Override
        public void dispatchEvent(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, UserHostmask recipientHostmask, User recipientUser, boolean adding) {
            Utils.dispatchEvent(bot, new SuperOpEvent(bot, channel, sourceHostmask, sourceUser, recipientHostmask, recipientUser, adding));
        }
    }).add((Object)new OpChannelModeHandler('q', UserLevel.OWNER){

        @Override
        public void dispatchEvent(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, UserHostmask recipientHostmask, User recipientUser, boolean adding) {
            Utils.dispatchEvent(bot, new OwnerEvent(bot, channel, sourceHostmask, sourceUser, recipientHostmask, recipientUser, adding));
        }
    }).add((Object)new ChannelModeHandler('k'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            if (adding) {
                String key = (String)params.next();
                channel.setChannelKey(key);
                if (dispatchEvent) {
                    Utils.dispatchEvent(bot, new SetChannelKeyEvent(bot, channel, sourceHostmask, sourceUser, key));
                }
            } else {
                String key = params.hasNext() ? (String)params.next() : null;
                channel.setChannelKey(null);
                if (dispatchEvent) {
                    Utils.dispatchEvent(bot, new RemoveChannelKeyEvent(bot, channel, sourceHostmask, sourceUser, key));
                }
            }
        }
    }).add((Object)new ChannelModeHandler('f'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            if (adding) {
                params.next();
            }
        }
    }).add((Object)new ChannelModeHandler('J'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            if (adding) {
                params.next();
            }
        }
    }).add((Object)new ChannelModeHandler('L'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            if (adding) {
                params.next();
            }
        }
    }).add((Object)new ChannelModeHandler('l'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            if (adding) {
                int limit = Integer.parseInt(StringUtils.removeStart((String)((String)params.next()), (String)":"));
                channel.setChannelLimit(limit);
                if (dispatchEvent) {
                    Utils.dispatchEvent(bot, new SetChannelLimitEvent(bot, channel, sourceHostmask, sourceUser, limit));
                }
            } else {
                channel.setChannelLimit(-1);
                if (dispatchEvent) {
                    Utils.dispatchEvent(bot, new RemoveChannelLimitEvent(bot, channel, sourceHostmask, sourceUser));
                }
            }
        }
    }).add((Object)new ChannelModeHandler('b'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            if (dispatchEvent) {
                UserHostmask banHostmask = bot.getConfiguration().getBotFactory().createUserHostmask(bot, (String)params.next());
                if (adding) {
                    Utils.dispatchEvent(bot, new SetChannelBanEvent(bot, channel, sourceHostmask, sourceUser, banHostmask));
                } else {
                    Utils.dispatchEvent(bot, new RemoveChannelBanEvent(bot, channel, sourceHostmask, sourceUser, banHostmask));
                }
            }
        }
    }).add((Object)new ChannelModeHandler('t'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            channel.setTopicProtection(adding);
            if (dispatchEvent) {
                if (adding) {
                    Utils.dispatchEvent(bot, new SetTopicProtectionEvent(bot, channel, sourceHostmask, sourceUser));
                } else {
                    Utils.dispatchEvent(bot, new RemoveTopicProtectionEvent(bot, channel, sourceHostmask, sourceUser));
                }
            }
        }
    }).add((Object)new ChannelModeHandler('n'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            channel.setNoExternalMessages(adding);
            if (dispatchEvent) {
                if (adding) {
                    Utils.dispatchEvent(bot, new SetNoExternalMessagesEvent(bot, channel, sourceHostmask, sourceUser));
                } else {
                    Utils.dispatchEvent(bot, new RemoveNoExternalMessagesEvent(bot, channel, sourceHostmask, sourceUser));
                }
            }
        }
    }).add((Object)new ChannelModeHandler('i'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            channel.setInviteOnly(adding);
            if (dispatchEvent) {
                if (adding) {
                    Utils.dispatchEvent(bot, new SetInviteOnlyEvent(bot, channel, sourceHostmask, sourceUser));
                } else {
                    Utils.dispatchEvent(bot, new RemoveInviteOnlyEvent(bot, channel, sourceHostmask, sourceUser));
                }
            }
        }
    }).add((Object)new ChannelModeHandler('m'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            channel.setModerated(adding);
            if (dispatchEvent) {
                if (adding) {
                    Utils.dispatchEvent(bot, new SetModeratedEvent(bot, channel, sourceHostmask, sourceUser));
                } else {
                    Utils.dispatchEvent(bot, new RemoveModeratedEvent(bot, channel, sourceHostmask, sourceUser));
                }
            }
        }
    }).add((Object)new ChannelModeHandler('p'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            channel.setChannelPrivate(adding);
            if (dispatchEvent) {
                if (adding) {
                    Utils.dispatchEvent(bot, new SetPrivateEvent(bot, channel, sourceHostmask, sourceUser));
                } else {
                    Utils.dispatchEvent(bot, new RemovePrivateEvent(bot, channel, sourceHostmask, sourceUser));
                }
            }
        }
    }).add((Object)new ChannelModeHandler('s'){

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            channel.setSecret(adding);
            if (dispatchEvent) {
                if (adding) {
                    Utils.dispatchEvent(bot, new SetSecretEvent(bot, channel, sourceHostmask, sourceUser));
                } else {
                    Utils.dispatchEvent(bot, new RemoveSecretEvent(bot, channel, sourceHostmask, sourceUser));
                }
            }
        }
    }).build();
    protected final Configuration configuration;
    protected final PircBotX bot;
    protected final List<CapHandler> capHandlersFinished = new ArrayList<CapHandler>();
    protected boolean capEndSent = false;
    protected BufferedReader inputReader;
    protected final Map<String, WhoisEvent.Builder> whoisBuilder = new TreeMap<String, WhoisEvent.Builder>(String.CASE_INSENSITIVE_ORDER);
    protected StringBuilder motdBuilder;
    protected boolean channelListRunning = false;
    protected ImmutableList.Builder<ChannelListEntry> channelListBuilder;
    protected int nickSuffix = 0;
    protected final Multimap<Channel, BanListEvent.Entry> banListBuilder = LinkedListMultimap.create();
    protected final Multimap<Channel, QuietListEvent.Entry> quietListBuilder = LinkedListMultimap.create();
    protected ImmutableList.Builder<User> whoListBuilder;

    public InputParser(PircBotX bot) {
        this.bot = bot;
        this.configuration = bot.getConfiguration();
    }

    public void handleLine(@NonNull String rawLine) throws IOException, IrcException {
        int code;
        String target;
        String command;
        if (rawLine == null) {
            throw new NullPointerException("rawLine is marked non-null but is null");
        }
        String line = CharMatcher.whitespace().trimFrom((CharSequence)rawLine);
        log.info(INPUT_MARKER, line);
        ImmutableMap.Builder tags = ImmutableMap.builder();
        if (line.startsWith("@")) {
            String v3Tags = line.substring(1, line.indexOf(" "));
            line = line.substring(line.indexOf(" ") + 1);
            StringTokenizer tokenizer = new StringTokenizer(v3Tags);
            while (tokenizer.hasMoreTokens()) {
                String tag = tokenizer.nextToken(";");
                if (tag.contains("=")) {
                    String[] parts = tag.split("=", 2);
                    String value = parts.length == 2 ? parts[1] : "";
                    tags.put((Object)parts[0], (Object)Utils.unescapeV3TagValue(value));
                    continue;
                }
                tags.put((Object)tag, (Object)"");
            }
        }
        List<String> parsedLine = Utils.tokenizeLine(line);
        String sourceRaw = "";
        if (parsedLine.get(0).charAt(0) == ':') {
            sourceRaw = parsedLine.remove(0);
        }
        if ((command = parsedLine.remove(0).toUpperCase(this.configuration.getLocale())).equals("PING")) {
            this.configuration.getListenerManager().onEvent(new ServerPingEvent(this.bot, parsedLine.get(0)));
            return;
        }
        if (command.startsWith("ERROR")) {
            this.bot.close();
            return;
        }
        String string = target = parsedLine.isEmpty() ? "" : parsedLine.get(0);
        if (target.startsWith(":")) {
            target = target.substring(1);
        }
        if (!sourceRaw.startsWith(":")) {
            this.configuration.getListenerManager().onEvent(new UnknownEvent(this.bot, target, "", command, line, parsedLine, (ImmutableMap<String, String>)tags.build()));
            if (!this.bot.loggedIn) {
                for (CapHandler curCapHandler : this.configuration.getCapHandlers()) {
                    if (!curCapHandler.handleUnknown(this.bot, line)) continue;
                    this.addCapHandlerFinished(curCapHandler);
                }
            }
            return;
        }
        if (!this.bot.loggedIn) {
            this.processConnect(line, command, target, parsedLine);
        }
        if ((code = Utils.tryParseInt(command, -1)) != -1) {
            this.processServerResponse(code, line, parsedLine);
            return;
        }
        UserHostmask source = this.bot.getConfiguration().getBotFactory().createUserHostmask(this.bot, sourceRaw.substring(1));
        this.processCommand(target, source, command, line, parsedLine, (ImmutableMap<String, String>)tags.build());
    }

    public void processConnect(String rawLine, String code, String target, List<String> parsedLine) throws IrcException, IOException {
        if (CONNECT_CODES.contains((Object)code)) {
            ImmutableMap<String, String> autoConnectChannels;
            this.bot.onLoggedIn(parsedLine.get(0));
            log.debug("Logged onto server.");
            this.configuration.getListenerManager().onEvent(new ConnectEvent(this.bot));
            if (this.configuration.getNickservPassword() != null) {
                this.bot.sendIRC().identify(this.configuration.getNickservPassword());
            }
            if (this.configuration.getNickservCustomMessage() != null) {
                this.bot.sendRaw().rawLine(this.configuration.getNickservCustomMessage());
            }
            if (this.configuration.isUserModeHideRealHost()) {
                this.bot.sendIRC().mode(this.bot.getNick(), "+x");
            }
            if ((autoConnectChannels = this.bot.reconnectChannels()) == null) {
                autoConnectChannels = this.configuration.isNickservDelayJoin() ? ImmutableMap.of() : this.configuration.getAutoJoinChannels();
            }
            for (Map.Entry channelEntry : autoConnectChannels.entrySet()) {
                this.bot.sendIRC().joinChannel((String)channelEntry.getKey(), (String)channelEntry.getValue());
            }
        } else if (code.equals("439")) {
            log.warn("Ignoring too fast error");
        } else if (this.configuration.isCapEnabled() && code.equals("421") && parsedLine.get(1).equals("CAP")) {
            log.warn("Ignoring unknown command error, server does not support CAP negotiation");
        } else if (this.configuration.isCapEnabled() && code.equals("451") && target.equals("CAP")) {
            log.warn("Ignoring not registered error, server does not support CAP negotiation");
        } else if (this.configuration.isCapEnabled() && code.equals("410") && rawLine.contains("CAP")) {
            log.warn("Ignoring invalid command error, server does not support CAP negotiation");
        } else {
            if ((code.startsWith("5") || code.startsWith("4")) && !code.equals("433")) {
                throw new IrcException(IrcException.Reason.CANNOT_LOGIN, "Received error: " + rawLine);
            }
            if (code.equals("670")) {
                log.debug("Upgrading to TLS connection");
                SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                for (CapHandler curCapHandler : this.configuration.getCapHandlers()) {
                    if (!(curCapHandler instanceof TLSCapHandler)) continue;
                    sslSocketFactory = ((TLSCapHandler)curCapHandler).getSslSocketFactory();
                }
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.bot.getSocket(), this.bot.getLocalAddress().getHostAddress(), this.bot.getSocket().getPort(), true);
                sslSocket.startHandshake();
                this.bot.changeSocket(sslSocket);
                for (CapHandler curCapHandler : this.configuration.getCapHandlers()) {
                    if (!curCapHandler.handleUnknown(this.bot, rawLine)) continue;
                    this.addCapHandlerFinished(curCapHandler);
                }
            } else if (code.equals("CAP") && this.configuration.isCapEnabled()) {
                String capCommand = parsedLine.get(1);
                ImmutableList capParams = ImmutableList.copyOf((Object[])StringUtils.split((String)parsedLine.get(2)));
                if (capCommand.equals("LS")) {
                    log.debug("Starting Cap Handlers {}", this.getCapHandlersRemaining());
                    for (CapHandler curCapHandler : this.getCapHandlersRemaining()) {
                        if (!curCapHandler.handleLS(this.bot, (ImmutableList<String>)capParams)) continue;
                        this.addCapHandlerFinished(curCapHandler);
                    }
                } else if (capCommand.equals("ACK")) {
                    this.bot.getEnabledCapabilities().addAll((Collection<String>)capParams);
                    for (CapHandler curCapHandler : this.getCapHandlersRemaining()) {
                        if (!curCapHandler.handleACK(this.bot, (ImmutableList<String>)capParams)) continue;
                        this.addCapHandlerFinished(curCapHandler);
                    }
                } else if (capCommand.equals("NAK")) {
                    for (CapHandler curCapHandler : this.getCapHandlersRemaining()) {
                        if (!curCapHandler.handleNAK(this.bot, (ImmutableList<String>)capParams)) continue;
                        this.addCapHandlerFinished(curCapHandler);
                    }
                } else {
                    for (CapHandler curCapHandler : this.getCapHandlersRemaining()) {
                        if (!curCapHandler.handleUnknown(this.bot, rawLine)) continue;
                        this.addCapHandlerFinished(curCapHandler);
                    }
                }
            } else {
                for (CapHandler curCapHandler : this.getCapHandlersRemaining()) {
                    if (!curCapHandler.handleUnknown(this.bot, rawLine)) continue;
                    this.addCapHandlerFinished(curCapHandler);
                }
            }
        }
    }

    protected List<CapHandler> getCapHandlersRemaining() {
        ArrayList remaining = Lists.newArrayList(this.configuration.getCapHandlers());
        remaining.removeAll(this.capHandlersFinished);
        return remaining;
    }

    protected void addCapHandlerFinished(CapHandler capHandler) {
        log.debug("Cap Handler finished " + capHandler);
        this.capHandlersFinished.add(capHandler);
        if (!this.capEndSent && this.capHandlersFinished.size() == this.configuration.getCapHandlers().size()) {
            this.capEndSent = true;
            this.bot.sendCAP().end();
            this.bot.enabledCapabilities = Collections.unmodifiableList(this.bot.enabledCapabilities);
        }
    }

    public void processCommand(String target, UserHostmask source, String command, String line, List<String> parsedLine, ImmutableMap<String, String> tags) throws IOException {
        User sourceUser;
        Channel channel = target.length() != 0 && this.bot.getUserChannelDao().containsChannel(target) ? this.bot.getUserChannelDao().getChannel(target) : null;
        String message = parsedLine.size() >= 2 ? parsedLine.get(1) : "";
        User user = sourceUser = this.bot.getUserChannelDao().containsUser(source) ? this.bot.getUserChannelDao().getUser(source) : null;
        if (command.equals("PRIVMSG") && message.startsWith("\u0001") && message.endsWith("\u0001")) {
            sourceUser = this.createUserIfNull(sourceUser, source);
            String request = message.substring(1, message.length() - 1);
            if (request.equals("VERSION")) {
                this.configuration.getListenerManager().onEvent(new VersionEvent(this.bot, source, sourceUser, channel));
            } else if (request.startsWith("ACTION ")) {
                this.configuration.getListenerManager().onEvent(new ActionEvent(this.bot, source, sourceUser, channel, target, request.substring(7), tags));
            } else if (request.startsWith("PING ")) {
                this.configuration.getListenerManager().onEvent(new PingEvent(this.bot, source, sourceUser, channel, request.substring(5)));
            } else if (request.equals("TIME")) {
                this.configuration.getListenerManager().onEvent(new TimeEvent(this.bot, channel, source, sourceUser));
            } else if (request.equals("FINGER")) {
                this.configuration.getListenerManager().onEvent(new FingerEvent(this.bot, source, sourceUser, channel));
            } else if (request.startsWith("DCC ")) {
                boolean success = this.bot.getDccHandler().processDcc(source, sourceUser, request);
                if (!success) {
                    this.configuration.getListenerManager().onEvent(new UnknownEvent(this.bot, target, source.getNick(), command, line, parsedLine, tags));
                }
            } else {
                this.configuration.getListenerManager().onEvent(new UnknownEvent(this.bot, target, source.getNick(), command, line, parsedLine, tags));
            }
        } else if (command.equals("PRIVMSG") && channel != null) {
            sourceUser = this.createUserIfNull(sourceUser, source);
            this.configuration.getListenerManager().onEvent(new MessageEvent(this.bot, channel, target, source, sourceUser, message, tags));
        } else if (command.equals("PRIVMSG")) {
            sourceUser = this.createUserIfNull(sourceUser, source);
            this.configuration.getListenerManager().onEvent(new PrivateMessageEvent(this.bot, source, sourceUser, message, tags));
        } else if (command.equals("JOIN")) {
            if (source.getNick().equalsIgnoreCase(this.bot.getNick())) {
                channel = this.bot.getUserChannelDao().createChannel(target);
                if (this.configuration.isOnJoinWhoEnabled()) {
                    this.bot.sendRaw().rawLine("WHO " + target);
                }
                this.bot.sendRaw().rawLine("MODE " + target);
            }
            sourceUser = this.createUserIfNull(sourceUser, source);
            this.bot.getUserChannelDao().addUserToChannel(sourceUser, channel);
            this.configuration.getListenerManager().onEvent(new JoinEvent(this.bot, channel, source, sourceUser, tags));
        } else if (command.equals("PART")) {
            UserSnapshot sourceSnapshot;
            ChannelSnapshot channelSnapshot;
            UserChannelDaoSnapshot daoSnapshot;
            if (this.configuration.isSnapshotsEnabled()) {
                daoSnapshot = this.bot.getUserChannelDao().createSnapshot();
                channelSnapshot = (ChannelSnapshot)daoSnapshot.getChannel(channel.getName());
                sourceSnapshot = (UserSnapshot)daoSnapshot.getUser(source);
            } else {
                daoSnapshot = null;
                channelSnapshot = null;
                sourceSnapshot = null;
            }
            if (source.getNick().equalsIgnoreCase(this.bot.getNick())) {
                this.bot.getUserChannelDao().removeChannel(channel);
            } else {
                this.bot.getUserChannelDao().removeUserFromChannel(sourceUser, channel);
            }
            this.configuration.getListenerManager().onEvent(new PartEvent(this.bot, daoSnapshot, channelSnapshot, channel.getName(), source, sourceSnapshot, message, tags));
        } else if (command.equals("NICK")) {
            sourceUser = this.createUserIfNull(sourceUser, source);
            String newNick = target;
            this.bot.getUserChannelDao().renameUser(sourceUser, newNick);
            if (source.getNick().equals(this.bot.getNick())) {
                this.bot.setNick(newNick);
            }
            this.configuration.getListenerManager().onEvent(new NickChangeEvent(this.bot, source.getNick(), newNick, source, sourceUser, tags));
        } else if (command.equals("NOTICE")) {
            this.configuration.getListenerManager().onEvent(new NoticeEvent(this.bot, source, sourceUser, channel, target, message, tags));
        } else if (command.equals("QUIT")) {
            UserSnapshot sourceSnapshot;
            UserChannelDaoSnapshot daoSnapshot;
            if (this.configuration.isSnapshotsEnabled()) {
                daoSnapshot = this.bot.getUserChannelDao().createSnapshot();
                sourceSnapshot = (UserSnapshot)daoSnapshot.getUser(sourceUser.getNick());
            } else {
                daoSnapshot = null;
                sourceSnapshot = null;
            }
            String reason = target;
            if (!source.getNick().equals(this.bot.getNick())) {
                this.bot.getUserChannelDao().removeUser(sourceUser);
            }
            this.configuration.getListenerManager().onEvent(new QuitEvent(this.bot, daoSnapshot, source, sourceSnapshot, reason, tags));
        } else if (command.equals("KICK")) {
            UserHostmask recipientHostmask = this.bot.getConfiguration().getBotFactory().createUserHostmask(this.bot, message);
            User recipient = this.bot.getUserChannelDao().getUser(message);
            if (recipient.getNick().equals(this.bot.getNick())) {
                this.bot.getUserChannelDao().removeChannel(channel);
            } else {
                this.bot.getUserChannelDao().removeUserFromChannel(recipient, channel);
            }
            this.configuration.getListenerManager().onEvent(new KickEvent(this.bot, channel, source, sourceUser, recipientHostmask, recipient, parsedLine.get(2), tags));
        } else if (command.equals("MODE")) {
            String mode = line.substring(line.indexOf(target, 2) + target.length() + 1);
            if (mode.startsWith(":")) {
                mode = mode.substring(1);
            }
            this.processMode(source, sourceUser, target, mode, tags);
        } else if (command.equals("TOPIC")) {
            long currentTime = System.currentTimeMillis();
            String oldTopic = channel.getTopic();
            channel.setTopic(message);
            channel.setTopicSetter(source);
            channel.setTopicTimestamp(currentTime);
            this.configuration.getListenerManager().onEvent(new TopicEvent(this.bot, channel, oldTopic, message, source, currentTime, true, tags));
        } else if (command.equals("INVITE")) {
            this.configuration.getListenerManager().onEvent(new InviteEvent(this.bot, source, sourceUser, message));
        } else if (command.equals("AWAY")) {
            if (parsedLine.isEmpty()) {
                sourceUser.setAwayMessage("");
            } else {
                sourceUser.setAwayMessage(parsedLine.get(0));
            }
        } else {
            this.configuration.getListenerManager().onEvent(new UnknownEvent(this.bot, target, source.getNick(), command, line, parsedLine, tags));
        }
    }

    public void processServerResponse(int code, String rawResponse, List<String> parsedResponseOrig) {
        ImmutableList parsedResponse = ImmutableList.copyOf(parsedResponseOrig);
        if (code == 433) {
            String usedNick;
            boolean autoNickChange = this.configuration.isAutoNickChange();
            String autoNewNick = null;
            boolean doAutoNickChange = false;
            if (parsedResponse.size() == 3) {
                usedNick = (String)parsedResponse.get(1);
                if (((String)parsedResponse.get(0)).equals("*")) {
                    doAutoNickChange = true;
                }
            } else {
                usedNick = (String)parsedResponse.get(0);
                if (!this.bot.loggedIn) {
                    doAutoNickChange = true;
                }
            }
            if (autoNickChange && doAutoNickChange) {
                ++this.nickSuffix;
                autoNewNick = this.configuration.getName() + this.nickSuffix;
                this.bot.sendIRC().changeNick(autoNewNick);
                this.bot.setNick(autoNewNick);
                this.bot.getUserChannelDao().renameUser(this.bot.getUserChannelDao().getUser(usedNick), autoNewNick);
            }
            this.configuration.getListenerManager().onEvent(new NickAlreadyInUseEvent(this.bot, usedNick, autoNewNick, autoNickChange));
        } else if (code == 321) {
            this.channelListBuilder = ImmutableList.builder();
            this.channelListRunning = true;
        } else if (code == 322) {
            String channel = (String)parsedResponse.get(1);
            int userCount = Utils.tryParseInt((String)parsedResponse.get(2), -1);
            String topic = (String)parsedResponse.get(3);
            this.channelListBuilder.add((Object)new ChannelListEntry(channel, userCount, topic));
        } else if (code == 323) {
            this.configuration.getListenerManager().onEvent(new ChannelInfoEvent(this.bot, (ImmutableList<ChannelListEntry>)this.channelListBuilder.build()));
            this.channelListBuilder = null;
            this.channelListRunning = false;
        } else if (code == 332) {
            Channel channel = this.bot.getUserChannelDao().getChannel((String)parsedResponse.get(1));
            String topic = (String)parsedResponse.get(2);
            channel.setTopic(topic);
        } else if (code == 333) {
            Channel channel = this.bot.getUserChannelDao().getChannel((String)parsedResponse.get(1));
            UserHostmask setBy = this.configuration.getBotFactory().createUserHostmask(this.bot, (String)parsedResponse.get(2));
            long date = Utils.tryParseLong((String)parsedResponse.get(3), -1);
            channel.setTopicTimestamp(date * 1000L);
            channel.setTopicSetter(setBy);
            this.configuration.getListenerManager().onEvent(new TopicEvent(this.bot, channel, null, channel.getTopic(), setBy, date, false, (ImmutableMap<String, String>)ImmutableMap.of()));
        } else if (code == 352) {
            String realName;
            int hops;
            String channelName = (String)parsedResponse.get(1);
            Channel channel = this.bot.getUserChannelDao().containsChannel(channelName) ? this.bot.getUserChannelDao().getChannel(channelName) : new Channel(this.bot, channelName);
            String login = (String)parsedResponse.get(2);
            String userHost = (String)parsedResponse.get(3);
            String serverName = (String)parsedResponse.get(4);
            String nick = (String)parsedResponse.get(5);
            String rawFlags = (String)parsedResponse.get(6);
            UserHostmask curUserHostmask = this.bot.getConfiguration().getBotFactory().createUserHostmask(this.bot, null, nick, login, userHost);
            User curUser = this.bot.getUserChannelDao().containsUser(nick) ? this.bot.getUserChannelDao().getUser(nick) : this.bot.getConfiguration().getBotFactory().createUser(curUserHostmask);
            curUser.setServer(serverName);
            this.processUserStatus(channel, curUser, rawFlags);
            String rawEnding = (String)parsedResponse.get(7);
            int rawEndingSpaceIndex = rawEnding.indexOf(32);
            if (rawEndingSpaceIndex == -1) {
                hops = Integer.parseInt(rawEnding);
                realName = "";
            } else {
                hops = Integer.parseInt(rawEnding.substring(0, rawEndingSpaceIndex));
                realName = rawEnding.substring(rawEndingSpaceIndex + 1);
            }
            curUser.setHops(hops);
            curUser.setRealName(realName);
            if (this.whoListBuilder == null) {
                this.whoListBuilder = new ImmutableList.Builder();
            }
            this.whoListBuilder.add((Object)curUser);
            if (this.bot.getUserChannelDao().containsChannel(channelName)) {
                this.bot.getUserChannelDao().addUserToChannel(curUser, channel);
            }
        } else if (code == 315) {
            String query = (String)parsedResponse.get(1);
            Channel channel = this.bot.getUserChannelDao().containsChannel(query) ? this.bot.getUserChannelDao().getChannel(query) : new Channel(this.bot, query);
            this.configuration.getListenerManager().onEvent(new UserListEvent(this.bot, channel, this.bot.getUserChannelDao().getUsers(channel), true));
            this.configuration.getListenerManager().onEvent(new WhoEvent(this.bot, query, (ImmutableList<User>)(this.whoListBuilder != null ? this.whoListBuilder.build() : ImmutableList.of())));
            this.whoListBuilder = null;
        } else if (code == 324) {
            String channelName = (String)parsedResponse.get(1);
            Channel channel = this.bot.getUserChannelDao().containsChannel(channelName) ? this.bot.getUserChannelDao().getChannel(channelName) : new Channel(this.bot, channelName);
            ImmutableList modeParsed = parsedResponse.subList(2, parsedResponse.size());
            String mode = StringUtils.join((Iterable)modeParsed, (char)' ');
            channel.setMode(mode, (ImmutableList<String>)modeParsed);
            this.configuration.getListenerManager().onEvent(new ModeEvent(this.bot, channel, null, null, mode, (ImmutableList<String>)modeParsed, (ImmutableMap<String, String>)ImmutableMap.of()));
        } else if (code == 329) {
            String channelName = (String)parsedResponse.get(1);
            Channel channel = this.bot.getUserChannelDao().containsChannel(channelName) ? this.bot.getUserChannelDao().getChannel(channelName) : new Channel(this.bot, channelName);
            int createDate = Utils.tryParseInt((String)parsedResponse.get(2), -1);
            channel.setCreateTimestamp(createDate);
        } else if (code == 375) {
            this.motdBuilder = new StringBuilder();
        } else if (code == 372) {
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)parsedResponse.get(1)))) {
                this.motdBuilder.append(CharMatcher.whitespace().trimFrom((CharSequence)((String)parsedResponse.get(1)).substring(1))).append('\n');
            } else {
                this.motdBuilder.append('\n');
            }
        } else if (code == 376) {
            ServerInfo serverInfo = this.bot.getServerInfo();
            serverInfo.setMotd(this.motdBuilder.toString().trim());
            this.motdBuilder = null;
            this.configuration.getListenerManager().onEvent(new MotdEvent(this.bot, serverInfo.getMotd()));
        } else if (code == 4 || code == 5) {
            int lastIndex;
            String endComment;
            int endCommentIndex = rawResponse.lastIndexOf(" :");
            if (endCommentIndex > 1 && (endComment = rawResponse.substring(endCommentIndex + 2)).equals(parsedResponseOrig.get(lastIndex = parsedResponseOrig.size() - 1))) {
                parsedResponseOrig.remove(lastIndex);
            }
            this.bot.getServerInfo().parse(code, parsedResponseOrig);
        } else if (code == 311) {
            String whoisNick = (String)parsedResponse.get(1);
            WhoisEvent.Builder builder = WhoisEvent.builder();
            builder.nick(whoisNick);
            builder.login((String)parsedResponse.get(2));
            builder.hostname((String)parsedResponse.get(3));
            builder.realname((String)parsedResponse.get(5));
            this.whoisBuilder.put(whoisNick, builder);
        } else if (code == 301) {
            String nick = (String)parsedResponse.get(1);
            String awayMessage = (String)parsedResponse.get(2);
            if (this.bot.getUserChannelDao().containsUser(nick)) {
                this.bot.getUserChannelDao().getUser(nick).setAwayMessage(awayMessage);
            }
            if (this.whoisBuilder.containsKey(nick)) {
                this.whoisBuilder.get(nick).awayMessage(awayMessage);
            }
        } else if (code == 319) {
            String whoisNick = (String)parsedResponse.get(1);
            ImmutableList parsedChannels = ImmutableList.copyOf(Utils.tokenizeLine((String)parsedResponse.get(2)));
            this.whoisBuilder.get(whoisNick).channels((ImmutableList<String>)parsedChannels);
        } else if (code == 312) {
            String whoisNick = (String)parsedResponse.get(1);
            this.whoisBuilder.get(whoisNick).server((String)parsedResponse.get(2));
            this.whoisBuilder.get(whoisNick).serverInfo((String)parsedResponse.get(3));
        } else if (code == 317) {
            String whoisNick = (String)parsedResponse.get(1);
            this.whoisBuilder.get(whoisNick).idleSeconds(Long.parseLong((String)parsedResponse.get(2)));
            this.whoisBuilder.get(whoisNick).signOnTime(Long.parseLong((String)parsedResponse.get(3)));
        } else if (code == 330) {
            String registeredNick = "";
            if (!rawResponse.endsWith(":" + (String)parsedResponse.get(2))) {
                registeredNick = (String)parsedResponse.get(2);
            }
            this.whoisBuilder.get(parsedResponse.get(1)).registeredAs(registeredNick);
        } else if (code == 307) {
            this.whoisBuilder.get(parsedResponse.get(1)).registeredAs("");
        } else if (code == 402) {
            String whoisNick = (String)parsedResponse.get(1);
            WhoisEvent event = WhoisEvent.builder().nick(whoisNick).exists(false).generateEvent(this.bot);
            this.configuration.getListenerManager().onEvent(event);
        } else if (code == 671) {
            this.whoisBuilder.get(parsedResponse.get(1)).secureConnection(true);
        } else if (code == 313) {
            String nick = (String)parsedResponse.get(1);
            if (this.bot.getUserChannelDao().containsUser(nick)) {
                this.bot.getUserChannelDao().getUser(nick).setIrcop(true);
            }
            this.whoisBuilder.get(nick).ircOp(true);
        } else if (code == 318) {
            WhoisEvent.Builder builder;
            String whoisNick = (String)parsedResponse.get(1);
            if (this.whoisBuilder.containsKey(whoisNick)) {
                builder = this.whoisBuilder.get(whoisNick);
                builder.exists(true);
            } else {
                builder = WhoisEvent.builder();
                builder.nick(whoisNick);
                builder.exists(false);
            }
            this.configuration.getListenerManager().onEvent(builder.generateEvent(this.bot));
            this.whoisBuilder.remove(whoisNick);
        } else if (code == 367) {
            Channel channel = this.bot.getUserChannelDao().getChannel((String)parsedResponse.get(1));
            UserHostmask recipient = this.bot.getConfiguration().getBotFactory().createUserHostmask(this.bot, (String)parsedResponse.get(2));
            UserHostmask source = this.bot.getConfiguration().getBotFactory().createUserHostmask(this.bot, (String)parsedResponse.get(3));
            long time = Long.parseLong((String)parsedResponse.get(4));
            this.banListBuilder.put((Object)channel, (Object)new BanListEvent.Entry(recipient, source, time));
            log.debug("Adding entry");
        } else if (code == 368) {
            Channel channel = this.bot.getUserChannelDao().getChannel((String)parsedResponse.get(1));
            ImmutableList entries = ImmutableList.copyOf((Collection)this.banListBuilder.removeAll((Object)channel));
            log.debug("Dispatching event");
            this.configuration.getListenerManager().onEvent(new BanListEvent(this.bot, channel, (ImmutableList<BanListEvent.Entry>)entries));
        } else if (code == 353) {
            String[] channel = StringUtils.split((String)((String)parsedResponse.get(3)));
            int entries = channel.length;
            for (int source = 0; source < entries; ++source) {
                UserLevel parsedLevel;
                String curUser;
                String nick = curUser = channel[source];
                ArrayList<UserLevel> levels = new ArrayList<UserLevel>();
                while ((parsedLevel = UserLevel.fromSymbol(nick.charAt(0))) != null) {
                    nick = nick.substring(1);
                    levels.add(parsedLevel);
                }
                User user = !this.bot.getUserChannelDao().containsUser(nick) ? this.bot.getUserChannelDao().createUser(new UserHostmask(this.bot, nick)) : this.bot.getUserChannelDao().getUser(nick);
                Channel chan = this.bot.getUserChannelDao().getChannel((String)parsedResponse.get(2));
                this.bot.getUserChannelDao().addUserToChannel(user, chan);
                for (UserLevel curLevel : levels) {
                    this.bot.getUserChannelDao().addUserToLevel(curLevel, user, chan);
                }
            }
        } else if (code == 366) {
            Channel channel = this.bot.getUserChannelDao().getChannel((String)parsedResponse.get(1));
            this.configuration.getListenerManager().onEvent(new UserListEvent(this.bot, channel, this.bot.getUserChannelDao().getUsers(channel), false));
        } else if (code == 381) {
            this.configuration.getListenerManager().onEvent(new OperSuccessEvent(this.bot));
        } else if (code == 491) {
            this.configuration.getListenerManager().onEvent(new OperFailedEvent(this.bot));
        } else if (code == 728) {
            Channel channel = this.bot.getUserChannelDao().getChannel((String)parsedResponse.get(1));
            UserHostmask recipient = this.bot.getConfiguration().getBotFactory().createUserHostmask(this.bot, (String)parsedResponse.get(3));
            UserHostmask source = this.bot.getConfiguration().getBotFactory().createUserHostmask(this.bot, (String)parsedResponse.get(4));
            long time = Long.parseLong((String)parsedResponse.get(5));
            this.quietListBuilder.put((Object)channel, (Object)new QuietListEvent.Entry(recipient, source, time));
        } else if (code == 729) {
            Channel channel = this.bot.getUserChannelDao().getChannel((String)parsedResponse.get(1));
            ImmutableList entries = ImmutableList.copyOf((Collection)this.quietListBuilder.removeAll((Object)channel));
            this.configuration.getListenerManager().onEvent(new QuietListEvent(this.bot, channel, (ImmutableList<QuietListEvent.Entry>)entries));
        }
        this.configuration.getListenerManager().onEvent(new ServerResponseEvent(this.bot, code, rawResponse, (ImmutableList<String>)parsedResponse));
    }

    public void processMode(UserHostmask userHostmask, User user, String target, String mode, ImmutableMap<String, String> tags) {
        if (this.configuration.getChannelPrefixes().indexOf(target.charAt(0)) >= 0) {
            Channel channel = this.bot.getUserChannelDao().getChannel(target);
            channel.parseMode(mode);
            ImmutableList modeParsed = ImmutableList.copyOf((Object[])StringUtils.split((String)mode, (char)' '));
            PeekingIterator params = Iterators.peekingIterator((Iterator)modeParsed.iterator());
            boolean adding = true;
            String modeLetters = (String)params.next();
            for (int i = 0; i < modeLetters.length(); ++i) {
                char curModeChar = modeLetters.charAt(i);
                if (curModeChar == '+') {
                    adding = true;
                    continue;
                }
                if (curModeChar == '-') {
                    adding = false;
                    continue;
                }
                ChannelModeHandler modeHandler = (ChannelModeHandler)this.configuration.getChannelModeHandlers().get((Object)Character.valueOf(curModeChar));
                if (modeHandler == null) continue;
                modeHandler.handleMode(this.bot, channel, userHostmask, user, (PeekingIterator<String>)params, adding, true);
            }
            this.configuration.getListenerManager().onEvent(new ModeEvent(this.bot, channel, userHostmask, user, mode, (ImmutableList<String>)modeParsed, tags));
        } else {
            UserHostmask targetHostmask = this.bot.getConfiguration().getBotFactory().createUserHostmask(this.bot, target);
            User targetUser = this.bot.getUserChannelDao().getUser(target);
            this.configuration.getListenerManager().onEvent(new UserModeEvent(this.bot, userHostmask, user, targetHostmask, targetUser, mode, tags));
        }
    }

    public void processUserStatus(Channel chan, User user, String prefix) {
        for (char prefixChar : prefix.toCharArray()) {
            UserLevel level = UserLevel.fromSymbol(prefixChar);
            if (level == null) continue;
            this.bot.getUserChannelDao().addUserToLevel(level, user, chan);
        }
        user.setAwayMessage(prefix.contains("G") ? "" : null);
        user.setIrcop(prefix.contains("*"));
    }

    public User createUserIfNull(User otherUser, @NonNull UserHostmask hostmask) {
        if (hostmask == null) {
            throw new NullPointerException("hostmask is marked non-null but is null");
        }
        if (otherUser != null) {
            otherUser.updateHostmask(hostmask);
            return otherUser;
        }
        if (this.bot.getUserChannelDao().containsUser(hostmask)) {
            throw new RuntimeException("User wasn't fetched but user exists in DAO. Please report this bug");
        }
        return this.bot.getUserChannelDao().createUser(hostmask);
    }

    @Override
    public void close() {
        this.capEndSent = false;
        this.capHandlersFinished.clear();
        this.whoisBuilder.clear();
        this.motdBuilder = null;
        this.channelListRunning = false;
        this.channelListBuilder = null;
    }

    public InputParser(Configuration configuration, PircBotX bot) {
        this.configuration = configuration;
        this.bot = bot;
    }

    public boolean isChannelListRunning() {
        return this.channelListRunning;
    }

    protected static abstract class OpChannelModeHandler
    extends ChannelModeHandler {
        protected final UserLevel level;

        public OpChannelModeHandler(char mode, UserLevel level) {
            super(mode);
            this.level = level;
        }

        @Override
        public void handleMode(PircBotX bot, Channel channel, UserHostmask sourceHostmask, User sourceUser, PeekingIterator<String> params, boolean adding, boolean dispatchEvent) {
            String recipient = (String)params.next();
            if (recipient.startsWith(":")) {
                recipient = recipient.substring(1);
            }
            UserHostmask recipientHostmask = bot.getConfiguration().getBotFactory().createUserHostmask(bot, recipient);
            User recipientUser = null;
            if (bot.getUserChannelDao().containsUser(recipient)) {
                recipientUser = bot.getUserChannelDao().getUser(recipient);
                if (adding) {
                    bot.getUserChannelDao().addUserToLevel(this.level, recipientUser, channel);
                } else {
                    bot.getUserChannelDao().removeUserFromLevel(this.level, recipientUser, channel);
                }
            }
            if (dispatchEvent) {
                this.dispatchEvent(bot, channel, sourceHostmask, sourceUser, recipientHostmask, recipientUser, adding);
            }
        }

        public abstract void dispatchEvent(PircBotX var1, Channel var2, UserHostmask var3, User var4, UserHostmask var5, User var6, boolean var7);
    }
}

