/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.AtomicSafeInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.pircbotx.ChannelModeHandler;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserChannelDao;
import org.pircbotx.UserHostmask;
import org.pircbotx.UserLevel;
import org.pircbotx.exception.NotReadyException;
import org.pircbotx.output.OutputChannel;
import org.pircbotx.snapshot.ChannelSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel
implements Comparable<Channel> {
    private static final Logger log = LoggerFactory.getLogger(Channel.class);
    protected final String name;
    protected final UUID channelId;
    protected final PircBotX bot;
    protected final AtomicSafeInitializer<OutputChannel> output = new AtomicSafeInitializer<OutputChannel>(){

        protected OutputChannel initialize() {
            return Channel.this.bot.getConfiguration().getBotFactory().createOutputChannel(Channel.this.bot, Channel.this);
        }
    };
    protected String mode = "";
    protected String topic = "";
    protected long topicTimestamp;
    protected long createTimestamp;
    protected UserHostmask topicSetter;
    protected boolean moderated = false;
    protected boolean noExternalMessages = false;
    protected boolean inviteOnly = false;
    protected boolean secret = false;
    protected boolean channelPrivate = false;
    protected boolean topicProtection = false;
    protected int channelLimit = -1;
    protected String channelKey = null;
    protected CountDownLatch modeChangeLatch = null;
    protected final Object modeChangeLock = new Object();

    protected Channel(PircBotX bot, String name) {
        this.bot = bot;
        this.name = name;
        this.channelId = UUID.randomUUID();
    }

    protected Channel(Channel channel) {
        this.bot = channel.bot;
        this.name = channel.name;
        this.channelId = channel.channelId;
    }

    protected UserChannelDao<User, Channel> getDao() {
        return this.bot.getUserChannelDao();
    }

    public OutputChannel send() {
        try {
            return (OutputChannel)this.output.get();
        }
        catch (ConcurrentException ex) {
            throw new RuntimeException("Could not generate OutputChannel for " + this.getName(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseMode(String rawMode) {
        Object object = this.modeChangeLock;
        synchronized (object) {
            if (rawMode.contains(" ") || this.mode != null && this.mode.contains(" ")) {
                if (this.mode == null) {
                    log.trace("Unknown args in channel {} mode '{}', waiting on server to respond with mode", (Object)this.name, (Object)rawMode);
                } else {
                    log.trace("Unknown args in channel {} mode '{}', getting fresh mode", (Object)this.name, (Object)rawMode);
                    this.mode = null;
                    this.modeChangeLatch = new CountDownLatch(1);
                    this.send().getMode();
                }
            } else {
                if (this.mode == null) {
                    log.error("Channel mode for {} was null - initializing to empty", (Object)this.name);
                    this.mode = "";
                }
                boolean adding = true;
                for (char curChar : rawMode.toCharArray()) {
                    if (curChar == '-') {
                        adding = false;
                        continue;
                    }
                    if (curChar == '+') {
                        adding = true;
                        continue;
                    }
                    this.mode = adding ? this.mode + curChar : this.mode.replace(Character.toString(curChar), "");
                }
            }
        }
    }

    public String getMode() throws NotReadyException {
        Object object = this.modeChangeLock;
        synchronized (object) {
            if (this.mode != null) {
                return this.mode;
            }
            throw new NotReadyException("Mode not ready yet");
        }
    }

    public String getMode(String defaultValue) {
        try {
            return this.getMode();
        }
        catch (NotReadyException e) {
            return defaultValue;
        }
    }

    public boolean containsMode(char modeLetter) throws NotReadyException {
        String mode = this.getMode();
        if (mode.isEmpty()) {
            return false;
        }
        String modeLetters = StringUtils.split((String)mode, (char)' ')[0];
        return StringUtils.contains((CharSequence)modeLetters, (int)modeLetter);
    }

    public boolean containsMode(char modeLetter, boolean defaultValue) {
        try {
            String mode = this.getMode();
            if (mode.isEmpty()) {
                return false;
            }
            String modeLetters = StringUtils.split((String)mode, (char)' ')[0];
            return StringUtils.contains((CharSequence)modeLetters, (int)modeLetter);
        }
        catch (NotReadyException e) {
            return defaultValue;
        }
    }

    public boolean hasTopicProtection() {
        return this.topicProtection;
    }

    public ImmutableSortedSet<UserLevel> getUserLevels(User user) {
        return this.getDao().getLevels(this, user);
    }

    public ImmutableSortedSet<User> getNormalUsers() {
        return this.getDao().getNormalUsers(this);
    }

    public ImmutableSortedSet<User> getOps() {
        return this.getDao().getUsers(this, UserLevel.OP);
    }

    public ImmutableSortedSet<User> getVoices() {
        return this.getDao().getUsers(this, UserLevel.VOICE);
    }

    public ImmutableSortedSet<User> getOwners() {
        return this.getDao().getUsers(this, UserLevel.OWNER);
    }

    public ImmutableSortedSet<User> getHalfOps() {
        return this.getDao().getUsers(this, UserLevel.HALFOP);
    }

    public ImmutableSortedSet<User> getSuperOps() {
        return this.getDao().getUsers(this, UserLevel.SUPEROP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMode(String mode, ImmutableList<String> modeParsed) {
        Object object = this.modeChangeLock;
        synchronized (object) {
            this.mode = mode;
            PeekingIterator params = Iterators.peekingIterator((Iterator)modeParsed.iterator());
            boolean adding = true;
            String modeLetters = (String)params.next();
            for (int i = 0; i < modeLetters.length(); ++i) {
                char curModeChar = modeLetters.charAt(i);
                if (curModeChar == '+') {
                    adding = true;
                    continue;
                }
                if (curModeChar == '-') {
                    adding = false;
                    continue;
                }
                ChannelModeHandler modeHandler = (ChannelModeHandler)this.bot.getConfiguration().getChannelModeHandlers().get((Object)Character.valueOf(curModeChar));
                if (modeHandler == null) continue;
                modeHandler.handleMode(this.bot, this, null, null, (PeekingIterator<String>)params, adding, false);
            }
            if (this.modeChangeLatch != null) {
                this.modeChangeLatch.countDown();
            }
        }
    }

    public ImmutableSortedSet<User> getUsers() {
        return this.getDao().getUsers(this);
    }

    public ImmutableSortedSet<String> getUsersNicks() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (User curUser : this.getDao().getUsers(this)) {
            builder.add((Object)curUser.getNick());
        }
        return builder.build();
    }

    public UserHostmask getTopicSetter() {
        return this.topicSetter;
    }

    public boolean isOp(User user) {
        return this.getDao().levelContainsUser(UserLevel.OP, this, user);
    }

    public boolean hasVoice(User user) {
        return this.getDao().levelContainsUser(UserLevel.VOICE, this, user);
    }

    public boolean isSuperOp(User user) {
        return this.getDao().levelContainsUser(UserLevel.SUPEROP, this, user);
    }

    public boolean isOwner(User user) {
        return this.getDao().levelContainsUser(UserLevel.OWNER, this, user);
    }

    public boolean isHalfOp(User user) {
        return this.getDao().levelContainsUser(UserLevel.HALFOP, this, user);
    }

    public ChannelSnapshot createSnapshot() {
        return new ChannelSnapshot(this, this.mode);
    }

    @Override
    public int compareTo(Channel other) {
        return this.getName().compareToIgnoreCase(other.getName());
    }

    public <T extends PircBotX> T getBot() {
        return (T)this.bot;
    }

    public String toString() {
        return "Channel(name=" + this.name + ", channelId=" + this.channelId + ", bot=" + this.bot + ", output=" + this.output + ", mode=" + this.mode + ", topic=" + this.topic + ", topicTimestamp=" + this.topicTimestamp + ", createTimestamp=" + this.createTimestamp + ", topicSetter=" + this.topicSetter + ", moderated=" + this.moderated + ", noExternalMessages=" + this.noExternalMessages + ", inviteOnly=" + this.inviteOnly + ", secret=" + this.secret + ", channelPrivate=" + this.channelPrivate + ", topicProtection=" + this.topicProtection + ", channelLimit=" + this.channelLimit + ", channelKey=" + this.channelKey + ", modeChangeLatch=" + this.modeChangeLatch + ", modeChangeLock=" + this.modeChangeLock + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Object this$bot = this.getBot();
        Object other$bot = other.getBot();
        return !(this$bot == null ? other$bot != null : !this$bot.equals(other$bot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Channel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Object $bot = this.getBot();
        result = result * 59 + ($bot == null ? 43 : $bot.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public UUID getChannelId() {
        return this.channelId;
    }

    public String getTopic() {
        return this.topic;
    }

    public long getTopicTimestamp() {
        return this.topicTimestamp;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public boolean isModerated() {
        return this.moderated;
    }

    public boolean isNoExternalMessages() {
        return this.noExternalMessages;
    }

    public boolean isInviteOnly() {
        return this.inviteOnly;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public boolean isChannelPrivate() {
        return this.channelPrivate;
    }

    public int getChannelLimit() {
        return this.channelLimit;
    }

    public String getChannelKey() {
        return this.channelKey;
    }

    protected void setTopic(String topic) {
        this.topic = topic;
    }

    protected void setTopicTimestamp(long topicTimestamp) {
        this.topicTimestamp = topicTimestamp;
    }

    protected void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    protected void setTopicSetter(UserHostmask topicSetter) {
        this.topicSetter = topicSetter;
    }

    protected void setModerated(boolean moderated) {
        this.moderated = moderated;
    }

    protected void setNoExternalMessages(boolean noExternalMessages) {
        this.noExternalMessages = noExternalMessages;
    }

    protected void setInviteOnly(boolean inviteOnly) {
        this.inviteOnly = inviteOnly;
    }

    protected void setSecret(boolean secret) {
        this.secret = secret;
    }

    protected void setChannelPrivate(boolean channelPrivate) {
        this.channelPrivate = channelPrivate;
    }

    protected void setTopicProtection(boolean topicProtection) {
        this.topicProtection = topicProtection;
    }

    protected void setChannelLimit(int channelLimit) {
        this.channelLimit = channelLimit;
    }

    protected void setChannelKey(String channelKey) {
        this.channelKey = channelKey;
    }
}

