/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client.internal;

import com.influxdb.v3.client.PointValues;
import com.influxdb.v3.client.internal.NanosecondConverter;
import com.influxdb.v3.client.internal.TypeCasting;
import com.influxdb.v3.client.write.WritePrecision;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.util.Text;

@ThreadSafe
public final class VectorSchemaRootConverter {
    private static final Logger LOG = Logger.getLogger(VectorSchemaRootConverter.class.getName());
    public static final VectorSchemaRootConverter INSTANCE = new VectorSchemaRootConverter();

    @Nonnull
    PointValues toPointValues(int rowNumber, @Nonnull List<FieldVector> fieldVectors) {
        PointValues p = new PointValues();
        for (FieldVector fieldVector : fieldVectors) {
            Field field = fieldVector.getField();
            Object value = fieldVector.getObject(rowNumber);
            String fieldName = field.getName();
            String metaType = (String)field.getMetadata().get("iox::column::type");
            if (value instanceof Text) {
                value = value.toString();
            }
            if ((Objects.equals(fieldName, "measurement") || Objects.equals(fieldName, "iox::measurement")) && value instanceof String) {
                p.setMeasurement((String)value);
                continue;
            }
            if (metaType == null) {
                if (Objects.equals(fieldName, "time") && (value instanceof Long || value instanceof LocalDateTime)) {
                    BigInteger timeNano = NanosecondConverter.getTimestampNano(value, field);
                    p.setTimestamp(timeNano, WritePrecision.NS);
                    continue;
                }
                p.setField(fieldName, value);
                continue;
            }
            String valueType = metaType.split("::")[2];
            Object mappedValue = this.getMappedValue(field, value);
            if ("field".equals(valueType)) {
                p.setField(fieldName, mappedValue);
                continue;
            }
            if ("tag".equals(valueType) && value instanceof String) {
                p.setTag(fieldName, (String)mappedValue);
                continue;
            }
            if (!"timestamp".equals(valueType)) continue;
            p.setTimestamp((BigInteger)mappedValue, WritePrecision.NS);
        }
        return p;
    }

    public Object getMappedValue(@Nonnull Field field, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        String fieldName = field.getName();
        if ("measurement".equals(fieldName) || "iox::measurement".equals(fieldName)) {
            return value.toString();
        }
        String metaType = (String)field.getMetadata().get("iox::column::type");
        if (metaType == null) {
            if ("time".equals(fieldName) && (value instanceof Long || value instanceof LocalDateTime)) {
                return NanosecondConverter.getTimestampNano(value, field);
            }
            return value;
        }
        String[] parts = metaType.split("::");
        String valueType = parts[2];
        if ("field".equals(valueType)) {
            switch (metaType) {
                case "iox::column_type::field::integer": 
                case "iox::column_type::field::uinteger": {
                    if (value instanceof Number) {
                        return TypeCasting.toLongValue(value);
                    }
                    LOG.warning(String.format("Value %s is not an Long", value));
                    return value;
                }
                case "iox::column_type::field::float": {
                    if (value instanceof Number) {
                        return TypeCasting.toDoubleValue(value);
                    }
                    LOG.warning(String.format("Value %s is not a Double", value));
                    return value;
                }
                case "iox::column_type::field::string": {
                    if (value instanceof Text || value instanceof String) {
                        return TypeCasting.toStringValue(value);
                    }
                    LOG.warning(String.format("Value %s is not a String", value));
                    return value;
                }
                case "iox::column_type::field::boolean": {
                    if (value instanceof Boolean) {
                        return value;
                    }
                    LOG.warning(String.format("Value %s is not a Boolean", value));
                    return value;
                }
            }
            return value;
        }
        if ("timestamp".equals(valueType) || Objects.equals(fieldName, "time")) {
            return NanosecondConverter.getTimestampNano(value, field);
        }
        return TypeCasting.toStringValue(value);
    }

    public Object[] getArrayObjectFromVectorSchemaRoot(@Nonnull VectorSchemaRoot vector, int rowNumber) {
        List fieldVectors = vector.getFieldVectors();
        int columnSize = fieldVectors.size();
        Object[] row = new Object[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            FieldVector fieldVector = (FieldVector)fieldVectors.get(i);
            row[i] = this.getMappedValue(fieldVector.getField(), fieldVector.getObject(rowNumber));
        }
        return row;
    }

    public Map<String, Object> getMapFromVectorSchemaRoot(@Nonnull VectorSchemaRoot vector, int rowNumber) {
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        for (FieldVector fieldVector : vector.getFieldVectors()) {
            Object mappedValue = this.getMappedValue(fieldVector.getField(), fieldVector.getObject(rowNumber));
            row.put(fieldVector.getName(), mappedValue);
        }
        return row;
    }
}

