/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.grpc.StatusUtils;
import org.apache.arrow.memory.ArrowBuf;

public final class SyncPutListener
implements FlightClient.PutListener,
AutoCloseable {
    private final LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue();
    private final CompletableFuture<Void> completed = new CompletableFuture();
    private static final Object DONE = new Object();
    private static final Object DONE_WITH_EXCEPTION = new Object();

    private PutResult unwrap(Object queueItem) throws InterruptedException, ExecutionException {
        if (queueItem == DONE) {
            this.queue.put(queueItem);
            return null;
        }
        if (queueItem == DONE_WITH_EXCEPTION) {
            this.queue.put(queueItem);
            this.completed.get();
        }
        return (PutResult)queueItem;
    }

    public PutResult read() throws InterruptedException, ExecutionException {
        return this.unwrap(this.queue.take());
    }

    public PutResult poll(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        return this.unwrap(this.queue.poll(timeout, unit));
    }

    @Override
    public void getResult() {
        try {
            this.completed.get();
        }
        catch (ExecutionException e) {
            throw StatusUtils.fromThrowable(e.getCause());
        }
        catch (InterruptedException e) {
            throw StatusUtils.fromThrowable(e);
        }
    }

    @Override
    public void onNext(PutResult val) {
        ArrowBuf metadata = val.getApplicationMetadata();
        metadata.getReferenceManager().retain();
        this.queue.add(PutResult.metadata(metadata));
    }

    @Override
    public void onError(Throwable t) {
        this.completed.completeExceptionally(StatusUtils.fromThrowable(t));
        this.queue.add(DONE_WITH_EXCEPTION);
    }

    @Override
    public void onCompleted() {
        this.completed.complete(null);
        this.queue.add(DONE);
    }

    @Override
    public void close() {
        this.queue.forEach(o -> {
            if (o instanceof PutResult) {
                ((PutResult)o).close();
            }
        });
    }

    @Override
    public boolean isCancelled() {
        return this.completed.isDone();
    }
}

