/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.util.Objects;
import org.apache.arrow.flight.ErrorFlightMetadata;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightStatusCode;

public class CallStatus {
    private final FlightStatusCode code;
    private final Throwable cause;
    private final String description;
    private final ErrorFlightMetadata metadata;
    public static final CallStatus UNKNOWN = FlightStatusCode.UNKNOWN.toStatus();
    public static final CallStatus INTERNAL = FlightStatusCode.INTERNAL.toStatus();
    public static final CallStatus INVALID_ARGUMENT = FlightStatusCode.INVALID_ARGUMENT.toStatus();
    public static final CallStatus TIMED_OUT = FlightStatusCode.TIMED_OUT.toStatus();
    public static final CallStatus NOT_FOUND = FlightStatusCode.NOT_FOUND.toStatus();
    public static final CallStatus ALREADY_EXISTS = FlightStatusCode.ALREADY_EXISTS.toStatus();
    public static final CallStatus CANCELLED = FlightStatusCode.CANCELLED.toStatus();
    public static final CallStatus UNAUTHENTICATED = FlightStatusCode.UNAUTHENTICATED.toStatus();
    public static final CallStatus UNAUTHORIZED = FlightStatusCode.UNAUTHORIZED.toStatus();
    public static final CallStatus UNIMPLEMENTED = FlightStatusCode.UNIMPLEMENTED.toStatus();
    public static final CallStatus UNAVAILABLE = FlightStatusCode.UNAVAILABLE.toStatus();
    public static final CallStatus RESOURCE_EXHAUSTED = FlightStatusCode.RESOURCE_EXHAUSTED.toStatus();

    public CallStatus(FlightStatusCode code, Throwable cause, String description, ErrorFlightMetadata metadata) {
        this.code = Objects.requireNonNull(code);
        this.cause = cause;
        this.description = description == null ? "" : description;
        this.metadata = metadata == null ? new ErrorFlightMetadata() : metadata;
    }

    public CallStatus(FlightStatusCode code) {
        this(code, null, null, null);
    }

    public FlightStatusCode code() {
        return this.code;
    }

    public Throwable cause() {
        return this.cause;
    }

    public String description() {
        return this.description;
    }

    public ErrorFlightMetadata metadata() {
        return this.metadata;
    }

    public CallStatus withDescription(String message) {
        return new CallStatus(this.code, this.cause, message, this.metadata);
    }

    public CallStatus withCause(Throwable t) {
        return new CallStatus(this.code, t, this.description, this.metadata);
    }

    public CallStatus withMetadata(ErrorFlightMetadata metadata) {
        return new CallStatus(this.code, this.cause, this.description, metadata);
    }

    public FlightRuntimeException toRuntimeException() {
        return new FlightRuntimeException(this);
    }

    public String toString() {
        return "CallStatus{code=" + String.valueOf((Object)this.code) + ", cause=" + String.valueOf(this.cause) + ", description='" + this.description + "', metadata='" + String.valueOf(this.metadata) + "'}";
    }
}

