/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import io.grpc.Drainable;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.grpc.AddWritableBuffer;
import org.apache.arrow.flight.grpc.GetReadableBuffer;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageMetadataResult;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.vector.types.pojo.Schema;

class ArrowMessage
implements AutoCloseable {
    public static final boolean ENABLE_ZERO_COPY_READ;
    public static final boolean ENABLE_ZERO_COPY_WRITE;
    private static final int DESCRIPTOR_TAG = 10;
    private static final int BODY_TAG = 8002;
    private static final int HEADER_TAG = 18;
    private static final int APP_METADATA_TAG = 26;
    private static final MethodDescriptor.Marshaller<Flight.FlightData> NO_BODY_MARSHALLER;
    private static final List<ByteBuf> PADDING_BUFFERS;
    private final IpcOption writeOption;
    private final Flight.FlightDescriptor descriptor;
    private final MessageMetadataResult message;
    private final ArrowBuf appMetadata;
    private final List<ArrowBuf> bufs;
    private final boolean tryZeroCopyWrite;

    public ArrowBuf getApplicationMetadata() {
        return this.appMetadata;
    }

    public ArrowMessage(Flight.FlightDescriptor descriptor, Schema schema, IpcOption option) {
        this.writeOption = option;
        ByteBuffer serializedMessage = MessageSerializer.serializeMetadata((Schema)schema, (IpcOption)this.writeOption);
        this.message = MessageMetadataResult.create((ByteBuffer)serializedMessage.slice(), (int)serializedMessage.remaining());
        this.bufs = ImmutableList.of();
        this.descriptor = descriptor;
        this.appMetadata = null;
        this.tryZeroCopyWrite = false;
    }

    public ArrowMessage(ArrowRecordBatch batch, ArrowBuf appMetadata, boolean tryZeroCopy, IpcOption option) {
        this.writeOption = option;
        ByteBuffer serializedMessage = MessageSerializer.serializeMetadata((org.apache.arrow.vector.ipc.message.ArrowMessage)batch, (IpcOption)this.writeOption);
        this.message = MessageMetadataResult.create((ByteBuffer)serializedMessage.slice(), (int)serializedMessage.remaining());
        this.bufs = ImmutableList.copyOf((Collection)batch.getBuffers());
        this.descriptor = null;
        this.appMetadata = appMetadata;
        this.tryZeroCopyWrite = tryZeroCopy;
    }

    public ArrowMessage(ArrowDictionaryBatch batch, IpcOption option) {
        this.writeOption = option;
        ByteBuffer serializedMessage = MessageSerializer.serializeMetadata((org.apache.arrow.vector.ipc.message.ArrowMessage)batch, (IpcOption)this.writeOption);
        serializedMessage = serializedMessage.slice();
        this.message = MessageMetadataResult.create((ByteBuffer)serializedMessage, (int)serializedMessage.remaining());
        batch.getDictionary().getBuffers().forEach(buf -> buf.getReferenceManager().retain());
        this.bufs = ImmutableList.copyOf((Collection)batch.getDictionary().getBuffers());
        this.descriptor = null;
        this.appMetadata = null;
        this.tryZeroCopyWrite = false;
    }

    public ArrowMessage(ArrowBuf appMetadata) {
        this.writeOption = IpcOption.DEFAULT;
        this.message = null;
        this.bufs = ImmutableList.of();
        this.descriptor = null;
        this.appMetadata = appMetadata;
        this.tryZeroCopyWrite = false;
    }

    public ArrowMessage(Flight.FlightDescriptor descriptor) {
        this.writeOption = IpcOption.DEFAULT;
        this.message = null;
        this.bufs = ImmutableList.of();
        this.descriptor = descriptor;
        this.appMetadata = null;
        this.tryZeroCopyWrite = false;
    }

    private ArrowMessage(Flight.FlightDescriptor descriptor, MessageMetadataResult message, ArrowBuf appMetadata, ArrowBuf buf) {
        this.writeOption = message != null ? new IpcOption(false, MetadataVersion.fromFlatbufID((short)message.getMessage().version())) : IpcOption.DEFAULT;
        this.message = message;
        this.descriptor = descriptor;
        this.appMetadata = appMetadata;
        this.bufs = buf == null ? ImmutableList.of() : ImmutableList.of((Object)buf);
        this.tryZeroCopyWrite = false;
    }

    public MessageMetadataResult asSchemaMessage() {
        return this.message;
    }

    public Flight.FlightDescriptor getDescriptor() {
        return this.descriptor;
    }

    public HeaderType getMessageType() {
        if (this.message == null) {
            return HeaderType.NONE;
        }
        return HeaderType.getHeader(this.message.headerType());
    }

    public Schema asSchema() {
        Preconditions.checkArgument((this.bufs.size() == 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.getMessageType() == HeaderType.SCHEMA ? 1 : 0) != 0);
        return MessageSerializer.deserializeSchema((MessageMetadataResult)this.message);
    }

    public ArrowRecordBatch asRecordBatch() throws IOException {
        Preconditions.checkArgument((this.bufs.size() == 1 ? 1 : 0) != 0, (Object)"A batch can only be consumed if it contains a single ArrowBuf.");
        Preconditions.checkArgument((this.getMessageType() == HeaderType.RECORD_BATCH ? 1 : 0) != 0);
        ArrowBuf underlying = this.bufs.get(0);
        underlying.getReferenceManager().retain();
        return MessageSerializer.deserializeRecordBatch((MessageMetadataResult)this.message, (ArrowBuf)underlying);
    }

    public ArrowDictionaryBatch asDictionaryBatch() throws IOException {
        Preconditions.checkArgument((this.bufs.size() == 1 ? 1 : 0) != 0, (Object)"A batch can only be consumed if it contains a single ArrowBuf.");
        Preconditions.checkArgument((this.getMessageType() == HeaderType.DICTIONARY_BATCH ? 1 : 0) != 0);
        ArrowBuf underlying = this.bufs.get(0);
        underlying.getReferenceManager().retain();
        return MessageSerializer.deserializeDictionaryBatch((MessageMetadataResult)this.message, (ArrowBuf)underlying);
    }

    public Iterable<ArrowBuf> getBufs() {
        return Iterables.unmodifiableIterable(this.bufs);
    }

    private static ArrowMessage frame(BufferAllocator allocator, InputStream stream) {
        try {
            Flight.FlightDescriptor descriptor = null;
            MessageMetadataResult header = null;
            ArrowBuf body = null;
            ArrowBuf appMetadata = null;
            while (stream.available() > 0) {
                int tag = ArrowMessage.readRawVarint32(stream);
                switch (tag) {
                    case 10: {
                        int size = ArrowMessage.readRawVarint32(stream);
                        byte[] bytes = new byte[size];
                        ByteStreams.readFully((InputStream)stream, (byte[])bytes);
                        descriptor = Flight.FlightDescriptor.parseFrom(bytes);
                        break;
                    }
                    case 18: {
                        int size = ArrowMessage.readRawVarint32(stream);
                        byte[] bytes = new byte[size];
                        ByteStreams.readFully((InputStream)stream, (byte[])bytes);
                        header = MessageMetadataResult.create((ByteBuffer)ByteBuffer.wrap(bytes), (int)size);
                        break;
                    }
                    case 26: {
                        int size = ArrowMessage.readRawVarint32(stream);
                        appMetadata = allocator.buffer((long)size);
                        GetReadableBuffer.readIntoBuffer(stream, appMetadata, size, ENABLE_ZERO_COPY_READ);
                        break;
                    }
                    case 8002: {
                        if (body != null) {
                            body.getReferenceManager().release();
                            body = null;
                        }
                        int size = ArrowMessage.readRawVarint32(stream);
                        body = allocator.buffer((long)size);
                        GetReadableBuffer.readIntoBuffer(stream, body, size, ENABLE_ZERO_COPY_READ);
                        break;
                    }
                }
            }
            if (header != null) {
                switch (HeaderType.getHeader(header.headerType())) {
                    case SCHEMA: {
                        if (body == null || body.capacity() != 0L) break;
                        body.close();
                        body = null;
                        break;
                    }
                    case DICTIONARY_BATCH: 
                    case RECORD_BATCH: {
                        if (body != null) break;
                        body = allocator.getEmpty();
                        break;
                    }
                }
            }
            return new ArrowMessage(descriptor, header, appMetadata, body);
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static int readRawVarint32(InputStream is) throws IOException {
        int firstByte = is.read();
        return CodedInputStream.readRawVarint32((int)firstByte, (InputStream)is);
    }

    private InputStream asInputStream() {
        if (this.message == null) {
            Flight.FlightData.Builder builder = Flight.FlightData.newBuilder();
            if (this.descriptor != null) {
                builder.setFlightDescriptor(this.descriptor);
            }
            if (this.appMetadata != null) {
                builder.setAppMetadata(ByteString.copyFrom((ByteBuffer)this.appMetadata.nioBuffer()));
            }
            return NO_BODY_MARSHALLER.stream((Object)builder.build());
        }
        try {
            ByteString bytes = ByteString.copyFrom((ByteBuffer)this.message.getMessageBuffer(), (int)this.message.bytesAfterMessage());
            if (this.getMessageType() == HeaderType.SCHEMA) {
                Flight.FlightData.Builder builder = Flight.FlightData.newBuilder().setDataHeader(bytes);
                if (this.descriptor != null) {
                    builder.setFlightDescriptor(this.descriptor);
                }
                Preconditions.checkArgument((boolean)this.bufs.isEmpty());
                return NO_BODY_MARSHALLER.stream((Object)builder.build());
            }
            Preconditions.checkArgument((this.getMessageType() == HeaderType.RECORD_BATCH || this.getMessageType() == HeaderType.DICTIONARY_BATCH ? 1 : 0) != 0);
            Preconditions.checkArgument((this.descriptor == null ? 1 : 0) != 0, (Object)"Descriptor should only be included in the schema message.");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)baos);
            cos.writeBytes(2, bytes);
            if (this.appMetadata != null && this.appMetadata.capacity() > 0L) {
                cos.writeByteBuffer(3, this.appMetadata.nioBuffer().slice());
            }
            cos.writeTag(1000, 2);
            int size = 0;
            ArrayList<ByteBuf> allBufs = new ArrayList<ByteBuf>();
            for (ArrowBuf b : this.bufs) {
                allBufs.add(Unpooled.wrappedBuffer((ByteBuffer)b.nioBuffer()).retain());
                size += (int)b.readableBytes();
                if (b.readableBytes() % 8L == 0L) continue;
                int paddingBytes = (int)(8L - b.readableBytes() % 8L);
                assert (paddingBytes > 0 && paddingBytes < 8);
                size += paddingBytes;
                allBufs.add(PADDING_BUFFERS.get(paddingBytes).retain());
            }
            cos.writeUInt32NoTag(size);
            cos.flush();
            ByteBuf initialBuf = Unpooled.buffer((int)baos.size());
            initialBuf.writeBytes(baos.toByteArray());
            ImmutableList byteBufs = ImmutableList.builder().add((Object)initialBuf).addAll(allBufs).build();
            int maxNumComponents = Integer.MAX_VALUE;
            ArrowBufRetainingCompositeByteBuf bb = this.tryZeroCopyWrite ? new ArrowBufRetainingCompositeByteBuf(Integer.MAX_VALUE, (Iterable<ByteBuf>)byteBufs, this.bufs) : new CompositeByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, true, Integer.MAX_VALUE, (Iterable)byteBufs);
            return new DrainableByteBufInputStream(bb, this.tryZeroCopyWrite);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected IO Exception", ex);
        }
    }

    public static MethodDescriptor.Marshaller<ArrowMessage> createMarshaller(BufferAllocator allocator) {
        return new ArrowMessageHolderMarshaller(allocator);
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close((Iterable)Iterables.concat(this.bufs, Collections.singletonList(this.appMetadata)));
    }

    static {
        String zeroCopyWriteFlag;
        String zeroCopyReadFlag = System.getProperty("arrow.flight.enable_zero_copy_read");
        if (zeroCopyReadFlag == null) {
            zeroCopyReadFlag = System.getenv("ARROW_FLIGHT_ENABLE_ZERO_COPY_READ");
        }
        if ((zeroCopyWriteFlag = System.getProperty("arrow.flight.enable_zero_copy_write")) == null) {
            zeroCopyWriteFlag = System.getenv("ARROW_FLIGHT_ENABLE_ZERO_COPY_WRITE");
        }
        ENABLE_ZERO_COPY_READ = !"false".equalsIgnoreCase(zeroCopyReadFlag);
        ENABLE_ZERO_COPY_WRITE = "true".equalsIgnoreCase(zeroCopyWriteFlag);
        NO_BODY_MARSHALLER = ProtoUtils.marshaller((Message)Flight.FlightData.getDefaultInstance());
        PADDING_BUFFERS = Arrays.asList(null, Unpooled.copiedBuffer((byte[])new byte[]{0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 0, 0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 0, 0, 0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 0, 0, 0, 0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0}));
    }

    public static enum HeaderType {
        NONE,
        SCHEMA,
        DICTIONARY_BATCH,
        RECORD_BATCH,
        TENSOR;


        public static HeaderType getHeader(byte b) {
            switch (b) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return SCHEMA;
                }
                case 2: {
                    return DICTIONARY_BATCH;
                }
                case 3: {
                    return RECORD_BATCH;
                }
                case 4: {
                    return TENSOR;
                }
            }
            throw new UnsupportedOperationException("unknown type: " + b);
        }
    }

    private static final class ArrowBufRetainingCompositeByteBuf
    extends CompositeByteBuf {
        final List<ArrowBuf> backingBuffers;
        boolean freed;

        ArrowBufRetainingCompositeByteBuf(int maxNumComponents, Iterable<ByteBuf> buffers, List<ArrowBuf> backingBuffers) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, true, maxNumComponents, buffers);
            this.backingBuffers = backingBuffers;
            this.freed = false;
            for (int i = 0; i < backingBuffers.size(); ++i) {
                backingBuffers.get(i).getReferenceManager().retain();
            }
        }

        protected void deallocate() {
            super.deallocate();
            if (this.freed) {
                return;
            }
            this.freed = true;
            for (int i = 0; i < this.backingBuffers.size(); ++i) {
                this.backingBuffers.get(i).getReferenceManager().release();
            }
        }
    }

    private static class DrainableByteBufInputStream
    extends ByteBufInputStream
    implements Drainable {
        private final CompositeByteBuf buf;
        private final boolean isZeroCopy;

        public DrainableByteBufInputStream(CompositeByteBuf buffer, boolean isZeroCopy) {
            super((ByteBuf)buffer, buffer.readableBytes(), true);
            this.buf = buffer;
            this.isZeroCopy = isZeroCopy;
        }

        public int drainTo(OutputStream target) throws IOException {
            int size = this.buf.readableBytes();
            AddWritableBuffer.add((ByteBuf)this.buf, target, this.isZeroCopy);
            return size;
        }

        public void close() {
            this.buf.release();
        }
    }

    private static class ArrowMessageHolderMarshaller
    implements MethodDescriptor.Marshaller<ArrowMessage> {
        private final BufferAllocator allocator;

        public ArrowMessageHolderMarshaller(BufferAllocator allocator) {
            this.allocator = allocator;
        }

        public InputStream stream(ArrowMessage value) {
            return value.asInputStream();
        }

        public ArrowMessage parse(InputStream stream) {
            return ArrowMessage.frame(this.allocator, stream);
        }
    }
}

