/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.arrow.flight.ArrowMessage;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.types.MetadataVersion;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.DictionaryUtility;
import org.apache.arrow.vector.validate.MetadataV4UnionChecker;

final class DictionaryUtils {
    private DictionaryUtils() {
        throw new UnsupportedOperationException("Do not instantiate this class.");
    }

    static Schema generateSchemaMessages(Schema originalSchema, FlightDescriptor descriptor, DictionaryProvider provider, IpcOption option, Consumer<ArrowMessage> messageCallback) throws Exception {
        HashSet<Long> dictionaryIds = new HashSet<Long>();
        Schema schema = DictionaryUtils.generateSchema(originalSchema, provider, dictionaryIds);
        MetadataV4UnionChecker.checkForUnion(schema.getFields().iterator(), (MetadataVersion)option.metadataVersion);
        Flight.FlightDescriptor protoDescriptor = descriptor == null ? null : descriptor.toProtocol();
        try (ArrowMessage message = new ArrowMessage(protoDescriptor, schema, option);){
            messageCallback.accept(message);
        }
        for (Long id : dictionaryIds) {
            Dictionary dictionary = provider.lookup(id.longValue());
            FieldVector vector = dictionary.getVector();
            int count = vector.getValueCount();
            VectorSchemaRoot dictRoot = new VectorSchemaRoot(Collections.singletonList(vector.getField()), Collections.singletonList(vector), count);
            VectorUnloader unloader = new VectorUnloader(dictRoot);
            try (ArrowDictionaryBatch dictionaryBatch = new ArrowDictionaryBatch(id.longValue(), unloader.getRecordBatch());
                 ArrowMessage message = new ArrowMessage(dictionaryBatch, option);){
                messageCallback.accept(message);
            }
        }
        return schema;
    }

    static void closeDictionaries(Schema schema, DictionaryProvider provider) throws Exception {
        HashSet dictionaryIds = new HashSet();
        schema.getFields().forEach(field -> DictionaryUtility.toMessageFormat((Field)field, (DictionaryProvider)provider, (Set)dictionaryIds));
        List dictionaryVectors = dictionaryIds.stream().map(id -> provider.lookup(id.longValue()).getVector()).collect(Collectors.toList());
        AutoCloseables.close(dictionaryVectors);
    }

    static Schema generateSchema(Schema originalSchema, DictionaryProvider provider, Set<Long> dictionaryIds) {
        boolean createSchema = false;
        for (Field field : originalSchema.getFields()) {
            if (!DictionaryUtility.needConvertToMessageFormat((Field)field)) continue;
            createSchema = true;
            break;
        }
        if (!createSchema) {
            return originalSchema;
        }
        ArrayList<Field> fields = new ArrayList<Field>(originalSchema.getFields().size());
        for (Field field : originalSchema.getFields()) {
            fields.add(DictionaryUtility.toMessageFormat((Field)field, (DictionaryProvider)provider, dictionaryIds));
        }
        return new Schema(fields, originalSchema.getCustomMetadata());
    }
}

