/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client.config;

import com.influxdb.v3.client.write.WriteOptions;
import com.influxdb.v3.client.write.WritePrecision;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ClientConfig {
    private final String host;
    private final char[] token;
    private final String authScheme;
    private final String organization;
    private final String database;
    private final WritePrecision writePrecision;
    private final Integer gzipThreshold;
    private final Boolean writeNoSync;
    private final Map<String, String> defaultTags;
    private final Duration timeout;
    private final Boolean allowHttpRedirects;
    private final Boolean disableServerCertificateValidation;
    private final String proxyUrl;
    private final Authenticator authenticator;
    private final Map<String, String> headers;
    private final String sslRootsFilePath;
    @Deprecated
    private final ProxySelector proxy;

    @Nonnull
    public String getHost() {
        return this.host;
    }

    @Nullable
    public char[] getToken() {
        return this.token;
    }

    @Nullable
    public String getAuthScheme() {
        return this.authScheme;
    }

    @Nullable
    public String getOrganization() {
        return this.organization;
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    @Nullable
    public WritePrecision getWritePrecision() {
        return this.writePrecision;
    }

    @Nonnull
    public Integer getGzipThreshold() {
        return this.gzipThreshold;
    }

    @Nonnull
    public Boolean getWriteNoSync() {
        return this.writeNoSync;
    }

    public Map<String, String> getDefaultTags() {
        return this.defaultTags;
    }

    @Nonnull
    public Duration getTimeout() {
        return this.timeout;
    }

    @Nonnull
    public Boolean getAllowHttpRedirects() {
        return this.allowHttpRedirects;
    }

    @Nonnull
    public Boolean getDisableServerCertificateValidation() {
        return this.disableServerCertificateValidation;
    }

    @Nullable
    @Deprecated
    public ProxySelector getProxy() {
        return this.proxy;
    }

    @Nullable
    public String getProxyUrl() {
        return this.proxyUrl;
    }

    @Nullable
    public String sslRootsFilePath() {
        return this.sslRootsFilePath;
    }

    @Nullable
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Nullable
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void validate() {
        if (this.host == null || this.host.isBlank()) {
            throw new IllegalArgumentException("The URL of the InfluxDB server has to be defined.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientConfig that = (ClientConfig)o;
        return Objects.equals(this.host, that.host) && Arrays.equals(this.token, that.token) && Objects.equals(this.authScheme, that.authScheme) && Objects.equals(this.organization, that.organization) && Objects.equals(this.database, that.database) && this.writePrecision == that.writePrecision && Objects.equals(this.gzipThreshold, that.gzipThreshold) && Objects.equals(this.writeNoSync, that.writeNoSync) && Objects.equals(this.defaultTags, that.defaultTags) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.allowHttpRedirects, that.allowHttpRedirects) && Objects.equals(this.disableServerCertificateValidation, that.disableServerCertificateValidation) && Objects.equals(this.proxy, that.proxy) && Objects.equals(this.proxyUrl, that.proxyUrl) && Objects.equals(this.authenticator, that.authenticator) && Objects.equals(this.headers, that.headers) && Objects.equals(this.sslRootsFilePath, that.sslRootsFilePath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, Arrays.hashCode(this.token), this.authScheme, this.organization, this.database, this.writePrecision, this.gzipThreshold, this.writeNoSync, this.timeout, this.allowHttpRedirects, this.disableServerCertificateValidation, this.proxy, this.proxyUrl, this.authenticator, this.headers, this.defaultTags, this.sslRootsFilePath});
    }

    public String toString() {
        return new StringJoiner(", ", ClientConfig.class.getSimpleName() + "ClientConfig[", "]").add("host='" + this.host + "'").add("organization='" + this.organization + "'").add("database='" + this.database + "'").add("writePrecision=" + this.writePrecision).add("gzipThreshold=" + this.gzipThreshold).add("writeNoSync=" + this.writeNoSync).add("timeout=" + this.timeout).add("allowHttpRedirects=" + this.allowHttpRedirects).add("disableServerCertificateValidation=" + this.disableServerCertificateValidation).add("proxy=" + this.proxy).add("proxyUrl=" + this.proxyUrl).add("authenticator=" + this.authenticator).add("headers=" + this.headers).add("defaultTags=" + this.defaultTags).add("sslRootsFilePath=" + this.sslRootsFilePath).toString();
    }

    private ClientConfig(@Nonnull Builder builder) {
        this.host = builder.host;
        this.token = builder.token;
        this.authScheme = builder.authScheme;
        this.organization = builder.organization;
        this.database = builder.database;
        this.writePrecision = builder.writePrecision != null ? builder.writePrecision : WriteOptions.DEFAULT_WRITE_PRECISION;
        this.gzipThreshold = builder.gzipThreshold != null ? builder.gzipThreshold : WriteOptions.DEFAULT_GZIP_THRESHOLD;
        this.writeNoSync = builder.writeNoSync != null ? builder.writeNoSync : false;
        this.defaultTags = builder.defaultTags;
        this.timeout = builder.timeout != null ? builder.timeout : Duration.ofSeconds(10L);
        this.allowHttpRedirects = builder.allowHttpRedirects != null ? builder.allowHttpRedirects : false;
        this.disableServerCertificateValidation = builder.disableServerCertificateValidation != null ? builder.disableServerCertificateValidation : false;
        this.proxy = builder.proxy;
        this.proxyUrl = builder.proxyUrl;
        this.authenticator = builder.authenticator;
        this.headers = builder.headers;
        this.sslRootsFilePath = builder.sslRootsFilePath;
    }

    public static final class Builder {
        private String host;
        private char[] token;
        private String authScheme;
        private String organization;
        private String database;
        private WritePrecision writePrecision;
        private Integer gzipThreshold;
        private Boolean writeNoSync;
        private Map<String, String> defaultTags;
        private Duration timeout;
        private Boolean allowHttpRedirects;
        private Boolean disableServerCertificateValidation;
        private ProxySelector proxy;
        private String proxyUrl;
        private Authenticator authenticator;
        private Map<String, String> headers;
        private String sslRootsFilePath;

        @Nonnull
        public Builder host(@Nonnull String host) {
            this.host = host;
            return this;
        }

        @Nonnull
        public Builder token(@Nullable char[] token) {
            this.token = token;
            return this;
        }

        @Nonnull
        public Builder authScheme(@Nullable String authScheme) {
            this.authScheme = authScheme;
            return this;
        }

        @Nonnull
        public Builder organization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        @Nonnull
        public Builder database(@Nullable String database) {
            this.database = database;
            return this;
        }

        @Nonnull
        public Builder writePrecision(@Nullable WritePrecision writePrecision) {
            this.writePrecision = writePrecision;
            return this;
        }

        @Nonnull
        public Builder gzipThreshold(@Nullable Integer gzipThreshold) {
            this.gzipThreshold = gzipThreshold;
            return this;
        }

        @Nonnull
        public Builder writeNoSync(@Nullable Boolean writeNoSync) {
            this.writeNoSync = writeNoSync;
            return this;
        }

        @Nonnull
        public Builder defaultTags(@Nullable Map<String, String> defaultTags) {
            this.defaultTags = defaultTags;
            return this;
        }

        @Nonnull
        public Builder timeout(@Nullable Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Nonnull
        public Builder allowHttpRedirects(@Nullable Boolean allowHttpRedirects) {
            this.allowHttpRedirects = allowHttpRedirects;
            return this;
        }

        @Nonnull
        public Builder disableServerCertificateValidation(@Nullable Boolean disableServerCertificateValidation) {
            this.disableServerCertificateValidation = disableServerCertificateValidation;
            return this;
        }

        @Nonnull
        public Builder proxy(@Nullable ProxySelector proxy) {
            this.proxy = proxy;
            return this;
        }

        @Nonnull
        public Builder proxyUrl(@Nullable String proxyUrl) {
            this.proxyUrl = proxyUrl;
            return this;
        }

        @Nonnull
        public Builder authenticator(@Nullable Authenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        @Nonnull
        public Builder headers(@Nullable Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @Nonnull
        public Builder sslRootsFilePath(@Nullable String sslRootsFilePath) {
            this.sslRootsFilePath = sslRootsFilePath;
            return this;
        }

        @Nonnull
        public ClientConfig build() {
            return new ClientConfig(this);
        }

        @Nonnull
        public ClientConfig build(@Nonnull String connectionString) throws MalformedURLException {
            String[] pairs;
            URL url = new URL(connectionString);
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (String pair : pairs = url.getQuery().split("&")) {
                int idx = pair.indexOf("=");
                parameters.put(pair.substring(0, idx), pair.substring(idx + 1));
            }
            this.host(new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath()).toString());
            if (parameters.containsKey("token")) {
                this.token(((String)parameters.get("token")).toCharArray());
            }
            if (parameters.containsKey("authScheme")) {
                this.authScheme((String)parameters.get("authScheme"));
            }
            if (parameters.containsKey("org")) {
                this.organization((String)parameters.get("org"));
            }
            if (parameters.containsKey("database")) {
                this.database((String)parameters.get("database"));
            }
            if (parameters.containsKey("precision")) {
                this.writePrecision(this.parsePrecision((String)parameters.get("precision")));
            }
            if (parameters.containsKey("gzipThreshold")) {
                this.gzipThreshold(Integer.parseInt((String)parameters.get("gzipThreshold")));
            }
            if (parameters.containsKey("writeNoSync")) {
                this.writeNoSync(Boolean.parseBoolean((String)parameters.get("writeNoSync")));
            }
            return new ClientConfig(this);
        }

        @Nonnull
        public ClientConfig build(@Nonnull Map<String, String> env, Properties properties) {
            String writeNoSync;
            String gzipThreshold;
            String precision;
            String database;
            String org;
            String authScheme;
            BiFunction<String, String, String> get = (name, key) -> {
                String envVar = (String)env.get(name);
                if (envVar != null) {
                    return envVar;
                }
                if (properties != null) {
                    return properties.getProperty((String)key);
                }
                return null;
            };
            this.host(get.apply("INFLUX_HOST", "influx.host"));
            String token = get.apply("INFLUX_TOKEN", "influx.token");
            if (token != null) {
                this.token(token.toCharArray());
            }
            if ((authScheme = get.apply("INFLUX_AUTH_SCHEME", "influx.authScheme")) != null) {
                this.authScheme(authScheme);
            }
            if ((org = get.apply("INFLUX_ORG", "influx.org")) != null) {
                this.organization(org);
            }
            if ((database = get.apply("INFLUX_DATABASE", "influx.database")) != null) {
                this.database(database);
            }
            if ((precision = get.apply("INFLUX_PRECISION", "influx.precision")) != null) {
                this.writePrecision(this.parsePrecision(precision));
            }
            if ((gzipThreshold = get.apply("INFLUX_GZIP_THRESHOLD", "influx.gzipThreshold")) != null) {
                this.gzipThreshold(Integer.parseInt(gzipThreshold));
            }
            if ((writeNoSync = get.apply("INFLUX_WRITE_NO_SYNC", "influx.writeNoSync")) != null) {
                this.writeNoSync(Boolean.parseBoolean(writeNoSync));
            }
            return new ClientConfig(this);
        }

        private WritePrecision parsePrecision(@Nonnull String precision) {
            WritePrecision writePrecision;
            switch (precision) {
                case "ns": 
                case "nanosecond": {
                    writePrecision = WritePrecision.NS;
                    break;
                }
                case "us": 
                case "microsecond": {
                    writePrecision = WritePrecision.US;
                    break;
                }
                case "ms": 
                case "millisecond": {
                    writePrecision = WritePrecision.MS;
                    break;
                }
                case "s": 
                case "second": {
                    writePrecision = WritePrecision.S;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("unsupported precision '%s'", precision));
                }
            }
            return writePrecision;
        }
    }
}

