/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client;

import com.influxdb.v3.client.PointValues;
import com.influxdb.v3.client.internal.Arguments;
import com.influxdb.v3.client.write.WriteOptions;
import com.influxdb.v3.client.write.WritePrecision;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;

@NotThreadSafe
public final class Point {
    private static final int MAX_FRACTION_DIGITS = 340;
    private static final ThreadLocal<NumberFormat> NUMBER_FORMATTER = ThreadLocal.withInitial(() -> {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(340);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(1);
        return numberFormat;
    });
    private final PointValues values;

    private Point(PointValues values) {
        this.values = values;
    }

    public Point(@Nonnull String measurementName) {
        Arguments.checkNotNull(measurementName, "measurement");
        this.values = new PointValues();
        this.values.setMeasurement(measurementName);
    }

    @Nonnull
    public static Point measurement(@Nonnull String measurementName) {
        Arguments.checkNotNull(measurementName, "measurement");
        return new Point(new PointValues()).setMeasurement(measurementName);
    }

    public static Point fromValues(PointValues values) throws Exception {
        if (values.getMeasurement() == null) {
            throw new Exception("Missing measurement!");
        }
        return new Point(values);
    }

    @Nonnull
    public String getMeasurement() {
        assert (this.values.getMeasurement() != null);
        return this.values.getMeasurement();
    }

    @Nonnull
    public Point setMeasurement(@Nonnull String measurement) {
        Arguments.checkNotNull(measurement, "precision");
        this.values.setMeasurement(measurement);
        return this;
    }

    @Nullable
    public Number getTimestamp() {
        return this.values.getTimestamp();
    }

    @Nonnull
    public Point setTimestamp(@Nullable Instant time) {
        this.values.setTimestamp(time);
        return this;
    }

    @Nonnull
    public Point setTimestamp(@Nullable Number time, @Nonnull WritePrecision precision) {
        Arguments.checkNotNull((Object)precision, "precision");
        this.values.setTimestamp(time, precision);
        return this;
    }

    @Nonnull
    public Point setTimestamp(@Nullable Long time, @Nonnull WritePrecision precision) {
        return this.setTimestamp((Number)time, precision);
    }

    @Nullable
    public String getTag(@Nonnull String name) {
        Arguments.checkNotNull(name, "tagName");
        return this.values.getTag(name);
    }

    @Nonnull
    public Point setTag(@Nonnull String key, @Nullable String value) {
        Arguments.checkNotNull(key, "tagName");
        this.values.setTag(key, value);
        return this;
    }

    @Nonnull
    public Point setTags(@Nonnull Map<String, String> tagsToAdd) {
        Arguments.checkNotNull(tagsToAdd, "tagsToAdd");
        this.values.setTags(tagsToAdd);
        return this;
    }

    @Nonnull
    public Point removeTag(@Nonnull String name) {
        Arguments.checkNotNull(name, "tagName");
        this.values.removeTag(name);
        return this;
    }

    @Nonnull
    public String[] getTagNames() {
        return this.values.getTagNames();
    }

    @Nullable
    public Double getFloatField(@Nonnull String name) throws ClassCastException {
        return this.getField(name, Double.class);
    }

    @Nonnull
    public Point setFloatField(@Nonnull String name, double value) {
        return this.putField(name, value);
    }

    @Nullable
    public Long getIntegerField(@Nonnull String name) throws ClassCastException {
        return this.getField(name, Long.class);
    }

    public Point setIntegerField(@Nonnull String name, long value) {
        return this.putField(name, value);
    }

    @Nullable
    public String getStringField(@Nonnull String name) throws ClassCastException {
        return this.getField(name, String.class);
    }

    public Point setStringField(@Nonnull String name, String value) {
        return this.putField(name, value);
    }

    @Nullable
    public Boolean getBooleanField(@Nonnull String name) throws ClassCastException {
        return this.getField(name, Boolean.class);
    }

    public Point setBooleanField(@Nonnull String name, boolean value) {
        return this.putField(name, value);
    }

    @Nullable
    public Object getField(@Nonnull String name) {
        return this.values.getField(name);
    }

    @Nullable
    public <T> T getField(String name, Class<T> type) throws ClassCastException {
        Object field = this.getField(name);
        if (field == null) {
            return null;
        }
        return type.cast(field);
    }

    @Nullable
    public Class<?> getFieldType(@Nonnull String name) {
        Object field = this.getField(name);
        if (field == null) {
            return null;
        }
        return field.getClass();
    }

    @Nonnull
    public Point setField(@Nonnull String field, double value) {
        return this.putField(field, value);
    }

    public Point setField(@Nonnull String field, long value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point setField(@Nonnull String field, @Nullable Number value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point setField(@Nonnull String field, @Nullable String value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point setField(@Nonnull String field, boolean value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point setField(@Nonnull String field, @Nullable Object value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point setFields(@Nonnull Map<String, Object> fieldsToAdd) {
        Arguments.checkNotNull(fieldsToAdd, "fieldsToAdd");
        fieldsToAdd.forEach(this::putField);
        return this;
    }

    @Nonnull
    public Point removeField(@NonNull String name) {
        this.values.removeField(name);
        return this;
    }

    @Nonnull
    public String[] getFieldNames() {
        return this.values.getFieldNames();
    }

    public boolean hasFields() {
        return this.values.hasFields();
    }

    @Nonnull
    public Point copy() {
        return new Point(this.values.copy());
    }

    @Nonnull
    public String toLineProtocol() {
        return this.toLineProtocol(null);
    }

    @Nonnull
    public String toLineProtocol(@Nullable WritePrecision precision) {
        StringBuilder sb = new StringBuilder();
        this.escapeKey(sb, this.getMeasurement(), false);
        this.appendTags(sb);
        boolean appendedFields = this.appendFields(sb);
        if (!appendedFields) {
            return "";
        }
        this.appendTime(sb, precision);
        return sb.toString();
    }

    @Nonnull
    private Point putField(@Nonnull String field, @Nullable Object value) {
        Arguments.checkNonEmpty(field, "fieldName");
        this.values.setField(field, value);
        return this;
    }

    private void appendTags(@Nonnull StringBuilder sb) {
        for (String name : this.values.getTagNames()) {
            String value = this.values.getTag(name);
            if (name.isEmpty() || value == null || value.isEmpty()) continue;
            sb.append(',');
            this.escapeKey(sb, name);
            sb.append('=');
            this.escapeKey(sb, value);
        }
        sb.append(' ');
    }

    private boolean appendFields(@Nonnull StringBuilder sb) {
        boolean appended = false;
        for (String field : this.values.getFieldNames()) {
            Object value = this.values.getField(field);
            if (this.isNotDefined(value)) continue;
            this.escapeKey(sb, field);
            sb.append('=');
            if (value instanceof Number) {
                if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                    sb.append(NUMBER_FORMATTER.get().format(value));
                } else {
                    sb.append(value).append('i');
                }
            } else if (value instanceof String) {
                String stringValue = (String)value;
                sb.append('\"');
                this.escapeValue(sb, stringValue);
                sb.append('\"');
            } else {
                sb.append(value);
            }
            sb.append(',');
            appended = true;
        }
        int lengthMinusOne = sb.length() - 1;
        if (sb.charAt(lengthMinusOne) == ',') {
            sb.setLength(lengthMinusOne);
        }
        return appended;
    }

    private void appendTime(@Nonnull StringBuilder sb, @Nullable WritePrecision precision) {
        WritePrecision precisionNotNull;
        Number time = this.getTimestamp();
        if (time == null) {
            return;
        }
        sb.append(" ");
        WritePrecision writePrecision = precisionNotNull = precision != null ? precision : WriteOptions.DEFAULT_WRITE_PRECISION;
        if (WritePrecision.NS.equals((Object)precisionNotNull)) {
            if (time instanceof BigDecimal) {
                sb.append(((BigDecimal)time).toBigInteger());
            } else if (time instanceof BigInteger) {
                sb.append(time);
            } else {
                sb.append(time.longValue());
            }
        } else {
            long timeLong = time instanceof BigDecimal ? ((BigDecimal)time).longValueExact() : (time instanceof BigInteger ? ((BigInteger)time).longValueExact() : time.longValue());
            sb.append(this.toTimeUnit(precisionNotNull).convert(timeLong, this.toTimeUnit(WritePrecision.NS)));
        }
    }

    private void escapeKey(@Nonnull StringBuilder sb, @Nonnull String key) {
        this.escapeKey(sb, key, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void escapeKey(@Nonnull StringBuilder sb, @Nonnull String key, boolean escapeEqual) {
        int i = 0;
        while (true) {
            block9: {
                if (i >= key.length()) {
                    return;
                }
                switch (key.charAt(i)) {
                    case '\n': {
                        sb.append("\\n");
                        break block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break block9;
                    }
                    case ' ': 
                    case ',': {
                        sb.append('\\');
                        break;
                    }
                    case '=': {
                        if (!escapeEqual) break;
                        sb.append('\\');
                    }
                }
                sb.append(key.charAt(i));
            }
            ++i;
        }
    }

    private void escapeValue(@Nonnull StringBuilder sb, @Nonnull String value) {
        for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                }
            }
            sb.append(value.charAt(i));
        }
    }

    private boolean isNotDefined(Object value) {
        return value == null || value instanceof Double && !Double.isFinite((Double)value) || value instanceof Float && !Float.isFinite(((Float)value).floatValue());
    }

    @Nonnull
    private TimeUnit toTimeUnit(@Nonnull WritePrecision precision) {
        switch (precision) {
            case MS: {
                return TimeUnit.MILLISECONDS;
            }
            case S: {
                return TimeUnit.SECONDS;
            }
            case US: {
                return TimeUnit.MICROSECONDS;
            }
            case NS: {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new IllegalStateException("Unexpected value: " + precision);
    }
}

