/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.luxair;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.util.VariableResolver;
import java.util.Locale;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class ImageTagParameterValue
extends ParameterValue {
    @Exported(visibility=4)
    @Restricted(value={NoExternalUse.class})
    public String imageName;
    @Exported(visibility=4)
    @Restricted(value={NoExternalUse.class})
    public String imageTag;
    @Exported(visibility=4)
    @Restricted(value={NoExternalUse.class})
    public String value;

    @DataBoundConstructor
    public ImageTagParameterValue(String name, String imageName, String imageTag) {
        this(name, imageName, imageTag, null);
    }

    public ImageTagParameterValue(String name, String imageName, String imageTag, String description) {
        super(name, description);
        this.imageName = imageName;
        this.imageTag = imageTag;
        this.value = String.format("%s:%s", imageName, imageTag);
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageTag() {
        return this.imageTag;
    }

    public String getValue() {
        return this.value;
    }

    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(String.format("%s_IMAGE", this.name), this.imageName);
        env.put(String.format("%s_IMAGE", this.name).toUpperCase(Locale.ENGLISH), this.imageName);
        env.put(String.format("%s_TAG", this.name), this.imageTag);
        env.put(String.format("%s_TAG", this.name).toUpperCase(Locale.ENGLISH), this.imageTag);
        env.put(this.name, this.value);
        env.put(this.name.toUpperCase(Locale.ENGLISH), this.value);
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return name -> this.name.equals(name) ? this.value : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageTagParameterValue that = (ImageTagParameterValue)((Object)o);
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String toString() {
        return "(ImageTagParameterValue) " + this.getName() + "='" + this.value + "'";
    }

    public String getShortDescription() {
        return this.name + "=" + this.value;
    }
}

