/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.luxair;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Queue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.luxair.ImageTag;
import io.jenkins.plugins.luxair.ImageTagParameterConfiguration;
import io.jenkins.plugins.luxair.ImageTagParameterValue;
import io.jenkins.plugins.luxair.model.Ordering;
import io.jenkins.plugins.luxair.model.ResultContainer;
import io.jenkins.plugins.luxair.util.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

public class ImageTagParameterDefinition
extends SimpleParameterDefinition {
    private static final long serialVersionUID = 3938123092372L;
    private static final Logger logger = Logger.getLogger(ImageTagParameterDefinition.class.getName());
    private static final ImageTagParameterConfiguration config = ImageTagParameterConfiguration.get();
    private final String image;
    private final String registry;
    private final String filter;
    private final String credentialId;
    private String defaultTag;
    private Ordering tagOrder;
    private String errorMsg = "";
    private Boolean verifySsl = true;

    @DataBoundConstructor
    public ImageTagParameterDefinition(String name, String description, String image, String filter, String registry, String credentialId) {
        this(name, description, image, filter, "", registry, credentialId, config.getDefaultTagOrdering());
    }

    public ImageTagParameterDefinition(String name, String description, String image, String filter, String defaultTag, String registry, String credentialId, Ordering tagOrder) {
        super(name);
        super.setDescription(description);
        this.image = image;
        this.registry = StringUtil.isNotNullOrEmpty(registry) ? registry : config.getDefaultRegistry();
        this.filter = StringUtil.isNotNullOrEmpty(filter) ? filter : ".*";
        this.defaultTag = StringUtil.isNotNullOrEmpty(defaultTag) ? defaultTag : "";
        this.credentialId = this.getDefaultOrEmptyCredentialId(this.registry, credentialId);
        this.tagOrder = tagOrder != null ? tagOrder : config.getDefaultTagOrdering();
    }

    private Object readResolve() {
        if (Objects.isNull(this.verifySsl)) {
            this.setVerifySsl(true);
        }
        return this;
    }

    public String getImage() {
        return this.image;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getDefaultTag() {
        return this.defaultTag;
    }

    @DataBoundSetter
    public void setDefaultTag(String defaultTag) {
        this.defaultTag = defaultTag;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public Ordering getTagOrder() {
        return this.tagOrder != null ? this.tagOrder : Ordering.NATURAL;
    }

    @DataBoundSetter
    public void setTagOrder(Ordering tagOrder) {
        this.tagOrder = tagOrder;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean isVerifySsl() {
        return this.verifySsl;
    }

    @DataBoundSetter
    public void setVerifySsl(boolean verifySsl) {
        this.verifySsl = verifySsl;
    }

    private String getDefaultOrEmptyCredentialId(String registry, String credentialId) {
        if (registry.equals(config.getDefaultRegistry()) && !StringUtil.isNotNullOrEmpty(credentialId)) {
            return config.getDefaultCredentialId();
        }
        if (StringUtil.isNotNullOrEmpty(credentialId)) {
            return credentialId;
        }
        return "";
    }

    public List<String> getTags() {
        ResultContainer<List<String>> resultContainer;
        Optional<String> optionalErrorMsg;
        String user = "";
        String password = "";
        StandardUsernamePasswordCredentials credential = this.findCredential(this.credentialId);
        if (credential != null) {
            user = credential.getUsername();
            password = credential.getPassword().getPlainText();
        }
        if ((optionalErrorMsg = (resultContainer = ImageTag.getTags(this.image, this.registry, this.filter, user, password, this.getTagOrder(), this.verifySsl)).getErrorMsg()).isPresent()) {
            this.setErrorMsg(optionalErrorMsg.get());
        } else {
            this.setErrorMsg("");
        }
        return resultContainer.getValue();
    }

    private StandardUsernamePasswordCredentials findCredential(String credentialId) {
        if (StringUtil.isNotNullOrEmpty(credentialId)) {
            Item context;
            List lookupCredentials = CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)context, (Authentication)((context = (Item)Optional.ofNullable(Stapler.getCurrentRequest2()).map(request -> (Item)request.findAncestorObject(Item.class)).orElse(null)) instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM2), Collections.emptyList());
            CredentialsMatcher allOf = CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialId)});
            return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)lookupCredentials, (CredentialsMatcher)allOf);
        }
        logger.info("CredentialId is empty");
        return null;
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof ImageTagParameterValue) {
            ImageTagParameterValue value = (ImageTagParameterValue)defaultValue;
            return new ImageTagParameterDefinition(this.getName(), this.getDescription(), this.getImage(), this.getFilter(), value.getImageTag(), this.getRegistry(), this.getCredentialId(), this.getTagOrder());
        }
        return this;
    }

    public ParameterValue createValue(String value) {
        return new ImageTagParameterValue(this.getName(), this.image, value, this.getDescription());
    }

    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        return (ParameterValue)req.bindJSON(ImageTagParameterValue.class, jo);
    }

    @Symbol(value={"imageTag"})
    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Nonnull
        public String getDisplayName() {
            return "Image Tag Parameter";
        }

        public String getDefaultRegistry() {
            return config.getDefaultRegistry();
        }

        public String getDefaultCredentialID() {
            return config.getDefaultCredentialId();
        }

        public Ordering getDefaultTagOrdering() {
            return config.getDefaultTagOrdering();
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item context, @QueryParameter String credentialId) {
            if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                logger.info("No permission to list credential");
                return new StandardListBoxModel().includeCurrentValue(credentialId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM2, context, StandardUsernameCredentials.class).includeCurrentValue(credentialId);
        }
    }
}

