/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.luxair;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.luxair.model.Ordering;
import io.jenkins.plugins.luxair.util.StringUtil;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class ImageTagParameterConfiguration
extends GlobalConfiguration {
    private static final Logger logger = Logger.getLogger(ImageTagParameterConfiguration.class.getName());
    private static final String DEFAULT_REGISTRY = "https://registry-1.docker.io";
    private String defaultRegistry = "https://registry-1.docker.io";
    private String defaultCredentialId = "";
    private Ordering defaultTagOrdering = Ordering.NATURAL;
    private boolean defaultVerifySsl = true;

    public static ImageTagParameterConfiguration get() {
        return (ImageTagParameterConfiguration)((Object)GlobalConfiguration.all().get(ImageTagParameterConfiguration.class));
    }

    public ImageTagParameterConfiguration() {
        this.load();
    }

    public String getDefaultRegistry() {
        return StringUtil.isNotNullOrEmpty(this.defaultRegistry) ? this.defaultRegistry : DEFAULT_REGISTRY;
    }

    public String getDefaultCredentialId() {
        return StringUtil.isNotNullOrEmpty(this.defaultCredentialId) ? this.defaultCredentialId : "";
    }

    public Ordering getDefaultTagOrdering() {
        return this.defaultTagOrdering != null ? this.defaultTagOrdering : Ordering.NATURAL;
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) {
        if (json.has("defaultRegistry")) {
            this.defaultRegistry = json.getString("defaultRegistry");
            logger.fine("Changed default registry to: " + this.defaultRegistry);
        }
        if (json.has("defaultCredentialId")) {
            this.defaultRegistry = json.getString("defaultCredentialId");
            logger.fine("Changed default registry credentialsId to: " + this.defaultCredentialId);
        }
        if (json.has("defaultTagOrdering")) {
            this.defaultTagOrdering = Ordering.valueOf(json.getString("defaultTagOrdering"));
            logger.fine("Changed default tag ordering to: " + String.valueOf((Object)this.defaultTagOrdering));
        }
        this.save();
        return true;
    }

    @DataBoundSetter
    public void setDefaultRegistry(String defaultRegistry) {
        logger.info("Changing default registry to: " + defaultRegistry);
        this.defaultRegistry = defaultRegistry;
        this.save();
    }

    @DataBoundSetter
    public void setDefaultCredentialId(String defaultCredentialId) {
        logger.info("Changing default registry credentialsId to: " + defaultCredentialId);
        this.defaultCredentialId = defaultCredentialId;
        this.save();
    }

    @DataBoundSetter
    public void setDefaultTagOrdering(Ordering defaultTagOrdering) {
        logger.info("Changing default tag ordering to: " + String.valueOf((Object)defaultTagOrdering));
        this.defaultTagOrdering = defaultTagOrdering;
        this.save();
    }

    public ListBoxModel doFillDefaultCredentialIdItems(@QueryParameter String credentialsId) {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            logger.info("No permission to list credential");
            return new StandardListBoxModel().includeCurrentValue(this.defaultCredentialId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardUsernameCredentials.class).includeCurrentValue(this.defaultCredentialId);
    }
}

