/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.luxair;

import hudson.util.VersionNumber;
import io.jenkins.plugins.luxair.ErrorInterceptor;
import io.jenkins.plugins.luxair.model.Ordering;
import io.jenkins.plugins.luxair.model.ResultContainer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Interceptor;
import kong.unirest.JsonNode;
import kong.unirest.Unirest;
import kong.unirest.json.JSONObject;

public class ImageTag {
    private static final Logger logger = Logger.getLogger(ImageTag.class.getName());
    private static final Interceptor errorInterceptor = new ErrorInterceptor();

    private ImageTag() {
        throw new IllegalStateException("Utility class");
    }

    public static ResultContainer<List<String>> getTags(String image, String registry, String filter, String user, String password, Ordering ordering, boolean verifySsl) {
        String token;
        ResultContainer<List<String>> container = new ResultContainer<List<String>>(Collections.emptyList());
        String[] authService = ImageTag.getAuthService(registry);
        ResultContainer<List<VersionNumber>> tags = ImageTag.getImageTagsFromRegistry(image, registry, authService[0], token = ImageTag.getAuthToken(authService, image, user, password), verifySsl);
        if (tags.getErrorMsg().isPresent()) {
            container.setErrorMsg(tags.getErrorMsg().get());
            return container;
        }
        ResultContainer<List<String>> filterTags = ImageTag.filterTags(tags.getValue(), filter, ordering);
        filterTags.getErrorMsg().ifPresent(container::setErrorMsg);
        container.setValue(filterTags.getValue());
        return container;
    }

    private static ResultContainer<List<String>> filterTags(List<VersionNumber> tags, String filter, Ordering ordering) {
        ResultContainer<List<String>> container = new ResultContainer<List<String>>(Collections.emptyList());
        logger.info("Ordering Tags according to: " + String.valueOf((Object)ordering));
        if (ordering == Ordering.DSC_VERSION || ordering == Ordering.ASC_VERSION) {
            try {
                container.setValue(tags.stream().filter(tag -> tag.toString().matches(filter)).sorted(ordering == Ordering.ASC_VERSION ? VersionNumber::compareTo : VersionNumber.DESCENDING).map(VersionNumber::toString).collect(Collectors.toList()));
            }
            catch (Exception ignore) {
                logger.warning("Unable to cast ImageTags to versions! Versioned Ordering is not supported for this images tags.");
                container.setErrorMsg("Unable to cast ImageTags to versions! Versioned Ordering is not supported for this images tags.");
            }
        } else {
            container.setValue(tags.stream().map(VersionNumber::toString).filter(tag -> tag.matches(filter)).sorted(ordering == Ordering.NATURAL ? Collections.reverseOrder() : String::compareTo).collect(Collectors.toList()));
        }
        return container;
    }

    private static String[] getAuthService(String registry) {
        String[] rtn = new String[]{"", "", ""};
        String url = registry + "/v2/";
        Unirest.config().reset();
        Unirest.config().enableCookieManagement(false).interceptor(errorInterceptor);
        String headerValue = Unirest.get((String)url).asEmpty().getHeaders().getFirst("Www-Authenticate");
        Unirest.shutDown();
        String type = "";
        String typePattern = "^(\\S+)";
        Matcher typeMatcher = Pattern.compile(typePattern).matcher(headerValue);
        if (typeMatcher.find()) {
            type = typeMatcher.group(1);
        }
        if (type.equalsIgnoreCase("Basic")) {
            rtn[0] = "Basic";
            logger.info("AuthService: type=Basic");
            return rtn;
        }
        if (type.equalsIgnoreCase("Bearer")) {
            String pattern = "Bearer realm=\"(\\S+)\",service=\"([\\S ]+)\"";
            Matcher m = Pattern.compile(pattern).matcher(headerValue);
            if (m.find()) {
                rtn[0] = "Bearer";
                rtn[1] = m.group(1);
                rtn[2] = m.group(2);
                logger.info("AuthService: type=Bearer, realm=" + rtn[0] + ", service=" + rtn[1]);
            } else {
                logger.warning("No AuthService available from " + url);
            }
            return rtn;
        }
        logger.warning("Unknown authorization type " + type);
        return rtn;
    }

    private static String getAuthToken(String[] authService, String image, String user, String password) {
        String type = authService[0];
        String token = "";
        if (type.equals("Basic")) {
            if (user.equals("AWS")) {
                return password;
            }
            token = Base64.getEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.UTF_8));
            return token;
        }
        String realm = authService[1];
        String service = authService[2];
        Unirest.config().reset();
        Unirest.config().enableCookieManagement(false).interceptor(errorInterceptor);
        GetRequest request = Unirest.get((String)realm);
        if (!user.isEmpty() && !password.isEmpty()) {
            logger.info("Basic authentication");
            request = (GetRequest)request.basicAuth(user, password);
        } else {
            logger.info("No basic authentication");
        }
        HttpResponse response = ((GetRequest)((GetRequest)request.queryString("service", (Object)service)).queryString("scope", (Object)("repository:" + image + ":pull"))).asJson();
        if (response.isSuccess()) {
            JSONObject jsonObject = ((JsonNode)response.getBody()).getObject();
            if (jsonObject.has("token")) {
                token = jsonObject.getString("token");
            } else if (jsonObject.has("access_token")) {
                token = jsonObject.getString("access_token");
            } else {
                logger.warning("Token not received");
            }
            logger.info("Token received");
        } else {
            logger.warning("Token not received");
        }
        Unirest.shutDown();
        return token;
    }

    private static ResultContainer<List<VersionNumber>> getImageTagsFromRegistry(String image, String registry, String authType, String token, boolean verifySsl) {
        ResultContainer<List<VersionNumber>> resultContainer = new ResultContainer<List<VersionNumber>>(new ArrayList());
        String url = registry + "/v2/" + image + "/tags/list";
        Unirest.config().reset();
        Unirest.config().enableCookieManagement(false).interceptor(errorInterceptor);
        Unirest.config().verifySsl(verifySsl);
        HttpResponse response = ((GetRequest)Unirest.get((String)url).header("Authorization", authType + " " + token)).asJson();
        if (response.isSuccess()) {
            logger.info("HTTP status: " + response.getStatusText());
            ((JsonNode)response.getBody()).getObject().getJSONArray("tags").forEach(item -> ((List)resultContainer.getValue()).add(new VersionNumber(item.toString())));
        } else {
            logger.warning("HTTP status: " + response.getStatusText());
            resultContainer.setErrorMsg("HTTP status: " + response.getStatusText());
        }
        Unirest.shutDown();
        return resultContainer;
    }
}

