/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kong.unirest.AsyncClient;
import kong.unirest.Cache;
import kong.unirest.Client;
import kong.unirest.HttpRequest;
import kong.unirest.HttpResponse;
import kong.unirest.RawResponse;
import kong.unirest.Util;

class CacheManager {
    private final CacheWrapper wrapper = new CacheWrapper();
    private final AsyncWrapper asyncWrapper = new AsyncWrapper();
    private final Cache backingCache;
    private final Cache.KeyGenerator keyGen;
    private Client originalClient;
    private AsyncClient originalAsync;

    public CacheManager() {
        this(100, 0L, HashKey::new);
    }

    public CacheManager(int depth, long ttl, Cache.KeyGenerator keyGenerator) {
        this(new CacheMap(depth, ttl), keyGenerator);
    }

    public CacheManager(Cache backing, Cache.KeyGenerator keyGenerator) {
        this.backingCache = backing;
        this.keyGen = keyGenerator != null ? keyGenerator : HashKey::new;
    }

    Client wrap(Client client) {
        this.originalClient = client;
        return this.wrapper;
    }

    AsyncClient wrapAsync(AsyncClient client) {
        this.originalAsync = client;
        return this.asyncWrapper;
    }

    private <T> Cache.Key getHash(HttpRequest request, Boolean isAsync, Class<?> responseType) {
        return this.keyGen.apply(request, isAsync, responseType);
    }

    private static class CacheMap
    implements Cache {
        private Map<Cache.Key, Object> map;
        private final int maxSize;
        private long ttl;

        CacheMap(final int maxSize, long ttl) {
            this.maxSize = maxSize;
            this.ttl = ttl;
            this.map = Collections.synchronizedMap(new LinkedHashMap<Cache.Key, Object>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Cache.Key, Object> eldest) {
                    return this.size() > maxSize;
                }
            });
        }

        @Override
        public <T> HttpResponse<T> get(Cache.Key key, Supplier<HttpResponse<T>> fetcher) {
            this.clearOld();
            return (HttpResponse)this.map.computeIfAbsent(key, k -> (HttpResponse)fetcher.get());
        }

        @Override
        public <T> CompletableFuture getAsync(Cache.Key key, Supplier<CompletableFuture<HttpResponse<T>>> fetcher) {
            this.clearOld();
            return (CompletableFuture)this.map.computeIfAbsent(key, k -> (CompletableFuture)fetcher.get());
        }

        private void clearOld() {
            if (this.ttl > 0L) {
                Instant now = Util.now();
                this.map.keySet().removeIf(k -> ChronoUnit.MILLIS.between(k.getTime(), now) > this.ttl);
            }
        }
    }

    private class AsyncWrapper
    implements AsyncClient {
        private AsyncWrapper() {
        }

        @Override
        public <T> T getClient() {
            return CacheManager.this.originalAsync.getClient();
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer, CompletableFuture<HttpResponse<T>> callback) {
            return this.request(request, transformer, callback, Object.class);
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer, CompletableFuture<HttpResponse<T>> callback, Class<?> responseType) {
            Cache.Key key = CacheManager.this.getHash(request, true, responseType);
            return CacheManager.this.backingCache.getAsync(key, () -> CacheManager.this.originalAsync.request(request, transformer, callback, responseType));
        }

        @Override
        public void registerShutdownHook() {
            CacheManager.this.originalAsync.registerShutdownHook();
        }

        @Override
        public Stream<Exception> close() {
            return CacheManager.this.originalAsync.close();
        }

        @Override
        public boolean isRunning() {
            return CacheManager.this.originalAsync.isRunning();
        }
    }

    private class CacheWrapper
    implements Client {
        private CacheWrapper() {
        }

        @Override
        public Object getClient() {
            return CacheManager.this.originalClient.getClient();
        }

        @Override
        public <T> HttpResponse<T> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer) {
            return this.request(request, transformer, Object.class);
        }

        @Override
        public <T> HttpResponse<T> request(HttpRequest request, Function<RawResponse, HttpResponse<T>> transformer, Class<?> responseType) {
            Cache.Key hash = CacheManager.this.getHash(request, false, responseType);
            return CacheManager.this.backingCache.get(hash, () -> CacheManager.this.originalClient.request(request, transformer, responseType));
        }

        @Override
        public Stream<Exception> close() {
            return CacheManager.this.originalClient.close();
        }

        @Override
        public void registerShutdownHook() {
            CacheManager.this.originalClient.registerShutdownHook();
        }
    }

    private static class HashKey
    implements Cache.Key {
        private final int hash;
        private final Instant time;

        HashKey(HttpRequest request, Boolean isAsync, Class<?> responseType) {
            this(Objects.hash(request.hashCode(), isAsync, responseType), request.getCreationTime());
        }

        HashKey(int hash, Instant time) {
            this.hash = hash;
            this.time = time;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashKey key = (HashKey)o;
            return this.hash == key.hash;
        }

        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        public Instant getTime() {
            return this.time;
        }
    }
}

