/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

class Time {
    long mask = -4194304L;
    long mask2 = 9223372036850581504L;
    long timestamp;
    Calendar cal;

    public Time(long timestamp) {
        this.timestamp = timestamp;
        if (timestamp != 0L) {
            this.createCal();
        }
    }

    private void createCal() {
        this.timestamp &= this.mask2;
        this.timestamp >>>= 16;
        this.timestamp = this.timestamp / 64L * 1024L;
        this.timestamp += 946702800000000L;
        this.timestamp /= 1000L;
        this.cal = new GregorianCalendar();
        Date d = new Date(this.timestamp);
        this.cal.clear();
        this.cal.setTime(d);
    }

    public String toString() {
        if (this.cal == null) {
            return "";
        }
        return this.cal.getTime().toString();
    }

    public String getTime() {
        if (this.cal == null) {
            return "";
        }
        StringBuilder time = new StringBuilder();
        time.append(this.cal.get(11));
        time.append(":");
        String min = Integer.toString(this.cal.get(12));
        if (min.length() == 1) {
            time.append("0");
            time.append(min);
        } else {
            time.append(min);
        }
        time.append(":");
        String sec = Integer.toString(this.cal.get(13));
        int length = sec.length();
        if (length == 1) {
            time.append("0");
            time.append(sec);
        } else {
            time.append(sec);
        }
        time.append(".");
        String millisec = Integer.toString(this.cal.get(14));
        length = millisec.length();
        if (length == 1) {
            time.append("00");
            time.append(millisec);
        } else if (length == 2) {
            time.append("0");
            time.append(millisec);
        } else {
            time.append(millisec);
        }
        return time.toString();
    }

    public long getTimeStamp() {
        return this.timestamp;
    }
}

