/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.access.Trace;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Data;
import com.ibm.as400.util.commtrace.Dec;
import com.ibm.as400.util.commtrace.Field;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Header;
import com.ibm.as400.util.commtrace.Hex;
import com.ibm.as400.util.commtrace.IP4Address;

public class ARPHeader
extends Header {
    private Field hardwaretype;
    private Field protocol;
    private Field hdwlength;
    private Field prtlength;
    private Field operation;
    private Field srchdwraddr;
    private Field srcipaddr;
    private Field dsthdwraddr;
    private Field dstipaddr;
    private int frmtype;
    private static final String CLASS = "ARPHeader";
    private static final String FRAME = "Frame Type";
    private static final String REQUEST = "REQUEST";
    private static final String RESPONSE = "RESPONSE";
    private static final String ARP = "ARP ";
    private static final String RARP = "RARP ";
    private static final String SRC = "Src Addr";
    private static final String DST = "Dst Addr";
    private static final String OPER = "Operation";

    ARPHeader(BitBuf data, int frmtype) {
        super(data);
        this.hardwaretype = new Dec(this.rawheader.slice(0, 16));
        this.protocol = new Dec(this.rawheader.slice(16, 16));
        this.hdwlength = new Dec(this.rawheader.slice(32, 8));
        this.prtlength = new Dec(this.rawheader.slice(40, 8));
        this.operation = new Dec(this.rawheader.slice(48, 16));
        this.srchdwraddr = new Hex(this.rawheader.slice(64, 48));
        this.srcipaddr = new IP4Address(this.rawheader.slice(112, 32));
        this.dsthdwraddr = new Hex(this.rawheader.slice(144, 48));
        this.dstipaddr = new IP4Address(this.rawheader.slice(192, 32));
        this.frmtype = frmtype;
    }

    @Override
    public int getHeaderLen() {
        return 224;
    }

    @Override
    public String toString(FormatProperties filter) {
        String operations = "";
        String arp = "";
        int oper = Integer.parseInt(this.operation.toString());
        if (this.rawheader.getBitSize() < this.getHeaderLen()) {
            return new Data(this.rawheader).toString();
        }
        if (filter != null) {
            boolean print = false;
            String IPaddr = filter.getIPAddress();
            String IPaddr2 = filter.getSecondIPAddress();
            String port = filter.getPort();
            if (IPaddr == null && IPaddr2 == null) {
                print = true;
            } else if (IPaddr2 == null) {
                if (this.srcipaddr.toString().equals(IPaddr) || this.dstipaddr.toString().equals(IPaddr)) {
                    print = true;
                }
            } else if ((this.srcipaddr.toString().equals(IPaddr) || this.srcipaddr.toString().equals(IPaddr2)) && (this.dstipaddr.toString().equals(IPaddr) || this.dstipaddr.toString().equals(IPaddr2))) {
                print = true;
            }
            if (port != null) {
                print = false;
            }
            if (!print) {
                if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
                    Trace.log(3, "ARPHeader.toString() Frame doesn't pass ARP IP Filter");
                }
                return "";
            }
        }
        if (oper == 1 || oper == 3 || oper == 8) {
            operations = REQUEST;
        } else if (oper == 2 || oper == 4 || oper == 9) {
            operations = RESPONSE;
        }
        if (this.frmtype == 2054) {
            arp = ARP;
        } else if (this.frmtype == 32821) {
            arp = RARP;
        }
        Object[] args = new Object[]{this.srcipaddr, this.dstipaddr, operations};
        return Formatter.jsprintf("\t    Frame Type   :  " + arp + "Src Addr:  {0,16,L} Dst Addr:  {1,16,L} Operation: {2,8,L}\n", args) + this.printHexHeader() + this.printnext(filter) + new Data(this.rawpayload).toString();
    }

    public String getHardwareType() {
        return this.hardwaretype.toString();
    }

    public String getProtocol() {
        return this.protocol.toString();
    }

    public String getHardwareLength() {
        return this.hdwlength.toString();
    }

    public String getProtocolLength() {
        return this.prtlength.toString();
    }

    public String getOpcode() {
        return this.operation.toString();
    }

    public String getSourceHardwareAddress() {
        return this.srchdwraddr.toString();
    }

    public String getSourceIPAddress() {
        return this.srcipaddr.toString();
    }

    public String getDestinationHardwareAddress() {
        return this.dsthdwraddr.toString();
    }

    public String getDestinationIPAddress() {
        return this.dstipaddr.toString();
    }
}

