/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.RJob;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.ResourcePool;
import com.ibm.as400.resource.SystemResourceList;
import java.beans.PropertyVetoException;

public class RJobList
extends SystemResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PRESENTATION_KEY_ = "JOB_LIST";
    private static final String ICON_BASE_NAME_ = "RJobList";
    private static final String SORTS_PRESENTATION_KEY_ = "JOB";
    private static PresentationLoader presentationLoader_;
    public static final String ALL = "*ALL";
    public static final String BLANK = "*BLANK";
    public static final String CURRENT = "*CURRENT";
    private static ResourceMetaDataTable selections_;
    public static final String JOB_NAME = "JOB_NAME";
    public static final String JOB_NUMBER = "JOB_NUMBER";
    public static final String JOB_TYPE = "JOB_TYPE";
    public static final String PRIMARY_JOB_STATUSES = "PRIMARY_JOB_STATUSES";
    public static final String USER_NAME = "USER_NAME";
    private static ResourceMetaDataTable sorts_;
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RJobList";
    private static final String formatName_ = "oljb0100";
    private static ProgramCallDocument staticDocument_;
    private static final String openListProgramName_ = "qgyoljob";

    public RJobList() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), RJob.attributes_, selections_, sorts_, openListProgramName_, formatName_, null);
    }

    public RJobList(AS400 system) {
        this();
        try {
            this.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    protected void establishConnection() throws ResourceException {
        super.establishConnection();
        this.setDocument((ProgramCallDocument)staticDocument_.clone());
    }

    @Override
    void setOpenParameters(ProgramCallDocument document) throws PcmlException, ResourceException {
        super.setOpenParameters(document);
        document.setValue("qgyoljob.jobSelectionInformation.jobName", ((String)this.getSelectionValue(JOB_NAME)).toUpperCase());
        document.setValue("qgyoljob.jobSelectionInformation.userName", ((String)this.getSelectionValue(USER_NAME)).toUpperCase());
        document.setValue("qgyoljob.jobSelectionInformation.jobNumber", (String)this.getSelectionValue(JOB_NUMBER));
        String jobType = (String)this.getSelectionValue(JOB_TYPE);
        document.setValue("qgyoljob.jobSelectionInformation.jobType", jobType.equals(ALL) ? "*" : jobType);
        int offset = 108;
        String[] primaryJobStatuses = (String[])this.getSelectionValue(PRIMARY_JOB_STATUSES);
        if (primaryJobStatuses == null) {
            primaryJobStatuses = new String[]{};
        }
        document.setIntValue("qgyoljob.jobSelectionInformation.offsetToPrimaryJobStatusArray", offset);
        document.setIntValue("qgyoljob.jobSelectionInformation.numberOfPrimaryJobStatusEntries", primaryJobStatuses.length);
        for (int i = 0; i < primaryJobStatuses.length; ++i) {
            document.setValue("qgyoljob.jobSelectionInformation.primaryJobStatus", new int[]{i}, primaryJobStatuses[i]);
            offset += 10;
        }
        Object[] sort = this.getSortValue();
        document.setIntValue("qgyoljob.sortInformation.numberOfKeysToSortOn", sort.length);
        for (int i = 0; i < sort.length; ++i) {
            int length;
            int startingPosition;
            int dataType = 4;
            boolean sortOrder = this.getSortOrder(sort[i]);
            if (sort[i].equals(JOB_NAME)) {
                startingPosition = 1;
                length = 10;
            } else if (sort[i].equals(USER_NAME)) {
                startingPosition = 11;
                length = 10;
            } else if (sort[i].equals(JOB_NUMBER)) {
                startingPosition = 21;
                length = 6;
            } else if (sort[i].equals(JOB_TYPE)) {
                startingPosition = 53;
                length = 1;
            } else if (sort[i].equals("JOB_SUBTYPE")) {
                startingPosition = 54;
                length = 1;
            } else {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Bad sort value specified: " + String.valueOf(sort[i]) + "(" + String.valueOf(sort[i].getClass()) + ")");
                }
                throw new ExtendedIllegalStateException("sortValue[" + i + "]", 6);
            }
            int[] index = new int[]{i};
            document.setIntValue("qgyoljob.sortInformation.sortKey.sortKeyFieldStartingPosition", index, startingPosition);
            document.setIntValue("qgyoljob.sortInformation.sortKey.sortKeyFieldLength", index, length);
            document.setIntValue("qgyoljob.sortInformation.sortKey.sortKeyFieldDataType", index, dataType);
            document.setValue("qgyoljob.sortInformation.sortKey.sortOrder", index, sortOrder ? "1" : "2");
        }
    }

    @Override
    Resource newResource(String programName, int[] indices) throws PcmlException, ResourceException {
        ProgramCallDocument document = this.getDocument();
        String jobNameUsed = (String)document.getValue(programName + ".receiverVariable.jobNameUsed", indices);
        String userNameUsed = (String)document.getValue(programName + ".receiverVariable.userNameUsed", indices);
        String jobNumberUsed = (String)document.getValue(programName + ".receiverVariable.jobNumberUsed", indices);
        byte[] internalJobIdentifier = (byte[])document.getValue(programName + ".receiverVariable.internalJobIdentifier", indices);
        String status = (String)document.getValue(programName + ".receiverVariable.status", indices);
        String jobType = (String)document.getValue(programName + ".receiverVariable.jobType", indices);
        String jobSubtype = (String)document.getValue(programName + ".receiverVariable.jobSubtype", indices);
        AS400 system = this.getSystem();
        Object resourceKey = RJob.computeResourceKey(system, jobNameUsed, userNameUsed, jobNumberUsed, internalJobIdentifier);
        RJob resource = (RJob)ResourcePool.GLOBAL_RESOURCE_POOL.getResource(resourceKey);
        if (resource == null) {
            try {
                resource = new RJob(system, internalJobIdentifier);
                resource.setResourceKey(resourceKey);
                resource.setName(jobNameUsed);
                resource.setUser(userNameUsed);
                resource.setNumber(jobNumberUsed);
                resource.freezeProperties();
            }
            catch (Exception e) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Exception while creating user from user list", (Throwable)e);
                }
                throw new ResourceException(e);
            }
        }
        resource.initializeAttributeValue("INTERNAL_JOB_ID", internalJobIdentifier);
        resource.initializeAttributeValue(JOB_NAME, jobNameUsed);
        resource.initializeAttributeValue(USER_NAME, userNameUsed);
        resource.initializeAttributeValue(JOB_NUMBER, jobNumberUsed);
        resource.initializeAttributeValue("JOB_STATUS", status);
        resource.initializeAttributeValue(JOB_TYPE, jobType);
        resource.initializeAttributeValue("JOB_SUBTYPE", jobSubtype);
        return resource;
    }

    static {
        block2: {
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            selections_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            selections_.add(JOB_NAME, String.class, false, new String[]{"*", CURRENT, ALL}, ALL, false);
            selections_.add(JOB_NUMBER, String.class, false, new String[]{ALL}, ALL, false);
            selections_.add(JOB_TYPE, String.class, false, new String[]{ALL, "A", "B", "I", "M", "R", "S", "W", "X"}, ALL, true);
            selections_.add(PRIMARY_JOB_STATUSES, String.class, false, new String[]{"*ACTIVE", "*JOBQ", "*OUTQ"}, null, true, true);
            selections_.add(USER_NAME, String.class, false, new String[]{CURRENT, ALL}, ALL, false);
            sorts_ = new ResourceMetaDataTable(presentationLoader_, SORTS_PRESENTATION_KEY_);
            sorts_.add((Object)JOB_NAME, String.class, true);
            sorts_.add((Object)USER_NAME, String.class, true);
            sorts_.add((Object)JOB_NUMBER, String.class, true);
            sorts_.add((Object)JOB_TYPE, String.class, true);
            sorts_.add((Object)"JOB_SUBTYPE", String.class, true);
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException e) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)e);
            }
        }
    }
}

