/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.ProgramMapEntry;
import com.ibm.as400.resource.ResourceException;
import java.io.Serializable;
import java.util.Vector;

public class ProgramAttributeGetter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private ProgramMap attributeMap_ = null;
    private ProgramCallDocument document_ = null;
    private Vector programsCalled_ = new Vector();
    private AS400 system_ = null;

    public ProgramAttributeGetter(AS400 system, ProgramCallDocument document, ProgramMap attributeMap) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (document == null) {
            throw new NullPointerException("document");
        }
        if (attributeMap == null) {
            throw new NullPointerException("attributeMap");
        }
        this.system_ = system;
        this.document_ = document;
        this.attributeMap_ = attributeMap;
    }

    public void clearBuffer() {
        this.programsCalled_.removeAllElements();
    }

    public Object getValue(Object attributeID) throws ResourceException {
        return this.getValue(attributeID, AS400BidiTransform.getStringType((char)this.system_.getCcsid()));
    }

    public Object getValue(Object attributeID, int bidiStringType) throws ResourceException {
        if (attributeID == null) {
            throw new NullPointerException("attributeID");
        }
        ProgramAttributeGetter programAttributeGetter = this;
        synchronized (programAttributeGetter) {
            ProgramMapEntry[] entries = this.attributeMap_.getEntries(attributeID);
            int indexUsed = -1;
            String programName = null;
            for (int j = 0; j < entries.length; ++j) {
                programName = entries[j].getProgramName();
                if (!this.programsCalled_.contains(programName)) continue;
                indexUsed = j;
                if (!Trace.isTraceOn()) break;
                Trace.log(3, "Getting attribute value " + String.valueOf(attributeID) + " using PCML document " + String.valueOf(this.document_) + ", program " + programName + " (which has already been called).");
                break;
            }
            if (indexUsed < 0) {
                indexUsed = 0;
                programName = entries[0].getProgramName();
                if (Trace.isTraceOn()) {
                    Trace.log(3, "Getting attribute value " + String.valueOf(attributeID) + " using PCML document " + String.valueOf(this.document_) + ", program " + programName + " (which is about to be called).");
                }
                boolean success = false;
                try {
                    success = this.document_.callProgram(programName);
                    if (!success) {
                        throw new ResourceException(this.document_.getMessageList(programName));
                    }
                    this.programsCalled_.addElement(programName);
                }
                catch (ResourceException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new ResourceException(1, (Throwable)e);
                }
            }
            try {
                return entries[indexUsed].getValue(this.system_, this.document_, null, null, bidiStringType);
            }
            catch (PcmlException e) {
                throw new ResourceException(1, (Throwable)e);
            }
        }
    }
}

