/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourcePool;

class PagedListBuffer {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private boolean clear_;
    private int numberOfPages_;
    private Resource[][] pages_;
    private long[] pageIndices_;
    private int pageSize_;
    private long[] pageTimestamps_;
    private ResourcePool pool_ = ResourcePool.GLOBAL_RESOURCE_POOL;

    public PagedListBuffer(int numberOfPages, int pageSize) {
        this.numberOfPages_ = numberOfPages;
        this.pageSize_ = pageSize;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        PagedListBuffer pagedListBuffer = this;
        synchronized (pagedListBuffer) {
            if (this.pool_ != null) {
                for (int i = 0; i < this.numberOfPages_; ++i) {
                    for (int j = 0; j < this.pageSize_; ++j) {
                        if (this.pages_ == null || this.pages_[i] == null || this.pages_[i][j] == null) continue;
                        this.pool_.deregister(this.pages_[i][j]);
                    }
                }
            }
            this.initialize();
            if (Trace.isTraceOn()) {
                Trace.log(3, "Paged list buffer " + String.valueOf(this) + " cleared.");
            }
        }
    }

    private int findPage(long index) {
        for (int i = 0; i < this.numberOfPages_; ++i) {
            if (this.pageIndices_[i] == -1L || this.pageIndices_[i] > index || index >= this.pageIndices_[i] + (long)this.pageSize_) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(long index) {
        PagedListBuffer pagedListBuffer = this;
        synchronized (pagedListBuffer) {
            int page = this.findPage(index);
            if (page != -1) {
                return this.pages_[page][(int)(index - this.pageIndices_[page])];
            }
            return null;
        }
    }

    private void initialize() {
        this.clear_ = true;
        this.pages_ = new Resource[this.numberOfPages_][];
        this.pageIndices_ = new long[this.numberOfPages_];
        this.pageTimestamps_ = new long[this.numberOfPages_];
        for (int i = 0; i < this.numberOfPages_; ++i) {
            this.pages_[i] = null;
            this.pageIndices_[i] = -1L;
            this.pageTimestamps_[i] = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResource(long index, Resource resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        PagedListBuffer pagedListBuffer = this;
        synchronized (pagedListBuffer) {
            this.clear_ = false;
            int page = this.findPage(index);
            if (page >= 0) {
                this.pages_[page][(int)(index - this.pageIndices_[page])] = resource;
                this.pageTimestamps_[page] = System.currentTimeMillis();
                if (this.pool_ != null) {
                    this.pool_.register(resource);
                }
                return;
            }
            for (int i = 0; i < this.numberOfPages_; ++i) {
                if (this.pages_[i] != null) continue;
                page = i;
                break;
            }
            if (page < 0) {
                int i;
                long lruTimestamp = System.currentTimeMillis();
                for (i = 0; i < this.numberOfPages_; ++i) {
                    if (this.pageTimestamps_[i] > lruTimestamp) continue;
                    page = i;
                    lruTimestamp = this.pageTimestamps_[i];
                }
                if (this.pool_ != null) {
                    for (i = 0; i < this.pageSize_; ++i) {
                        if (this.pages_[page][i] == null) continue;
                        this.pool_.deregister(this.pages_[page][i]);
                    }
                }
                for (i = 0; i < this.pageSize_; ++i) {
                    this.pages_[page][i] = null;
                }
                this.pages_[page] = null;
                if (Trace.isTraceOn()) {
                    Trace.log(3, "Paged list buffer " + String.valueOf(this) + " swapped out page " + page + ".");
                }
            }
            this.pages_[page] = new Resource[this.pageSize_];
            this.pages_[page][0] = resource;
            this.pageIndices_[page] = index;
            this.pageTimestamps_[page] = System.currentTimeMillis();
            if (this.pool_ != null) {
                this.pool_.register(resource);
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "Paged list buffer " + String.valueOf(this) + " created page " + page + ".");
            }
        }
    }
}

