/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.CommandMap;
import com.ibm.as400.resource.CommandMapEntry;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ValueMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

class CommandAttributeSetter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private CommandMap attributeMap_ = null;
    private CommandCall commandCall_ = null;
    private CharConverter converter_ = null;
    private int defaultStringType_ = -1;
    private Hashtable invariants_ = new Hashtable();
    private AS400 system_ = null;

    public CommandAttributeSetter(AS400 system, CommandMap attributeMap) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (attributeMap == null) {
            throw new NullPointerException("attributeMap");
        }
        this.system_ = system;
        this.commandCall_ = new CommandCall(system);
        this.attributeMap_ = attributeMap;
    }

    private void append(ByteArrayOutputStream commandString, String text) throws IOException {
        if (this.defaultStringType_ == -1) {
            this.defaultStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        if (this.converter_ == null) {
            this.converter_ = new CharConverter(this.system_.getCcsid(), this.system_);
        }
        commandString.write(this.converter_.stringToByteArray(text));
    }

    private void append(ByteArrayOutputStream commandString, String parameterName, Object parameterValue) throws IOException {
        if (this.defaultStringType_ == -1) {
            this.defaultStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        this.append(commandString, parameterName, parameterValue, this.defaultStringType_);
    }

    private void append(ByteArrayOutputStream commandString, String parameterName, Object parameterValue, int bidiStringType) throws IOException {
        if (this.converter_ == null) {
            this.converter_ = new CharConverter(this.system_.getCcsid(), this.system_);
        }
        commandString.write(this.converter_.stringToByteArray(parameterName + "("));
        commandString.write(this.converter_.stringToByteArray(parameterValue.toString(), bidiStringType));
        commandString.write(this.converter_.stringToByteArray(") "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterValue(String commandName, String parameterName, String parameterValue) {
        if (commandName == null) {
            throw new NullPointerException("commandName");
        }
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        if (parameterValue == null) {
            throw new NullPointerException("parameterValue");
        }
        CommandAttributeSetter commandAttributeSetter = this;
        synchronized (commandAttributeSetter) {
            Hashtable parameters;
            if (this.invariants_.containsKey(commandName)) {
                parameters = (Hashtable)this.invariants_.get(commandName);
            } else {
                parameters = new Hashtable();
                this.invariants_.put(commandName, parameters);
            }
            parameters.put(parameterName, parameterValue);
        }
    }

    public void setValues(Object[] attributeIDs, Object[] values) throws ResourceException {
        if (attributeIDs == null) {
            throw new NullPointerException("attributeIDs");
        }
        if (this.defaultStringType_ == -1) {
            this.defaultStringType_ = AS400BidiTransform.getStringType((char)this.system_.getCcsid());
        }
        int[] bidiStringTypes = new int[attributeIDs.length];
        for (int i = 0; i < bidiStringTypes.length; ++i) {
            bidiStringTypes[i] = this.defaultStringType_;
        }
        this.setValues(attributeIDs, values, bidiStringTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(Object[] attributeIDs, Object[] values, int[] bidiStringTypes) throws ResourceException {
        if (attributeIDs == null) {
            throw new NullPointerException("attributeIDs");
        }
        if (values == null) {
            throw new NullPointerException("values");
        }
        if (attributeIDs.length != values.length) {
            throw new ExtendedIllegalArgumentException("values", 2);
        }
        if (attributeIDs.length != bidiStringTypes.length) {
            throw new ExtendedIllegalArgumentException("bidiStringTypes", 2);
        }
        if (this.commandCall_.getSystem() == null) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        try {
            CommandAttributeSetter commandAttributeSetter = this;
            synchronized (commandAttributeSetter) {
                Hashtable<String, ByteArrayOutputStream> commandStrings = new Hashtable<String, ByteArrayOutputStream>();
                for (int i = 0; i < attributeIDs.length; ++i) {
                    ValueMap valueMap;
                    CommandMapEntry[] entries = this.attributeMap_.getEntries(attributeIDs[i]);
                    ByteArrayOutputStream commandString = null;
                    int indexUsed = -1;
                    for (int j = 0; j < entries.length; ++j) {
                        String commandName = entries[j].getCommandName();
                        if (!commandStrings.containsKey(commandName)) continue;
                        commandString = (ByteArrayOutputStream)commandStrings.get(commandName);
                        indexUsed = j;
                        break;
                    }
                    if (commandString == null) {
                        String commandName = entries[0].getCommandName();
                        commandString = new ByteArrayOutputStream();
                        this.append(commandString, commandName + " ");
                        if (this.invariants_.containsKey(commandName)) {
                            Hashtable parameters = (Hashtable)this.invariants_.get(commandName);
                            Enumeration keys = parameters.keys();
                            while (keys.hasMoreElements()) {
                                String parameterName = (String)keys.nextElement();
                                String parameterValue = (String)parameters.get(parameterName);
                                this.append(commandString, parameterName, parameterValue);
                            }
                        }
                        commandStrings.put(commandName, commandString);
                        indexUsed = 0;
                    }
                    Object value = (valueMap = entries[indexUsed].getValueMap()) != null ? valueMap.ltop(values[i], this.commandCall_.getSystem()) : values[i];
                    this.append(commandString, entries[indexUsed].getParameterName(), value, bidiStringTypes[i]);
                }
                Enumeration strings = commandStrings.elements();
                while (strings.hasMoreElements()) {
                    ByteArrayOutputStream commandString = (ByteArrayOutputStream)strings.nextElement();
                    byte[] asBytes = commandString.toByteArray();
                    if (Trace.isTraceOn()) {
                        String asString = this.converter_.byteArrayToString(asBytes);
                        Trace.log(3, "Setting attribute values using command: " + asString + ".");
                    }
                    try {
                        boolean success = this.commandCall_.run(asBytes);
                        if (success) continue;
                        throw new ResourceException(this.commandCall_.getMessageList());
                    }
                    catch (Exception e) {
                        throw new ResourceException(2, (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ResourceException(2, (Throwable)e);
        }
    }
}

