/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.micro.JdbcMeService;
import com.ibm.as400.micro.MicroDataInputStream;
import com.ibm.as400.micro.MicroDataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class ResultSetHandler {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    JdbcMeService service_;
    MicroDataInputStream in_;
    MicroDataOutputStream out_;

    public ResultSetHandler(JdbcMeService jdbcme, MicroDataInputStream in, MicroDataOutputStream out) {
        this.service_ = jdbcme;
        this.in_ = in;
        this.out_ = out;
    }

    public void process(ResultSet rs, int funcId) throws IOException {
        switch (funcId) {
            case 4737: {
                this.close(rs);
                break;
            }
            case 4738: {
                this.deleteRow(rs);
                break;
            }
            case 4739: {
                this.insertRow(rs);
                break;
            }
            case 4740: {
                this.next(rs);
                break;
            }
            case 4741: {
                this.previous(rs);
                break;
            }
            case 4742: {
                this.updateRow(rs);
                break;
            }
            case 4743: {
                this.absolute(rs);
                break;
            }
            case 4744: {
                this.afterLast(rs);
                break;
            }
            case 4745: {
                this.beforeFirst(rs);
                break;
            }
            case 4752: {
                this.first(rs);
                break;
            }
            case 4753: {
                this.isAfterLast(rs);
                break;
            }
            case 4754: {
                this.isBeforeFirst(rs);
                break;
            }
            case 4755: {
                this.isFirst(rs);
                break;
            }
            case 4756: {
                this.isLast(rs);
                break;
            }
            case 4757: {
                this.last(rs);
                break;
            }
            case 4758: {
                this.relative(rs);
                break;
            }
            default: {
                System.out.println("Error - ResultSet Function ID not recognized - function code: " + funcId);
            }
        }
    }

    public void close(ResultSet rs) throws IOException {
        try {
            rs.close();
        }
        catch (SQLException e) {
            System.out.println("Exception caught trying to close ResultSet object " + String.valueOf(rs));
            e.printStackTrace();
        }
        try {
            this.service_.removeResultSet(rs);
        }
        catch (SQLException e) {
            System.out.println("Exception caught trying to remove ResultSet object from tracking");
            e.printStackTrace();
        }
    }

    public void deleteRow(ResultSet rs) throws IOException {
        try {
            rs.deleteRow();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void insertRow(ResultSet rs) throws IOException {
        ResultSetMetaData rsmd = null;
        try {
            rs.moveToInsertRow();
            rsmd = rs.getMetaData();
            int count = rsmd.getColumnCount();
            for (int i = 0; i < count; ++i) {
                if (rsmd.getColumnType(i + 1) == 4) {
                    rs.updateInt(i + 1, this.in_.readInt());
                    continue;
                }
                rs.updateString(i + 1, this.in_.readUTF());
            }
            rs.insertRow();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void next(ResultSet rs) throws IOException {
        try {
            if (rs.next()) {
                this.out_.writeInt(1);
                this.writeRow(rs);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void previous(ResultSet rs) throws IOException {
        try {
            if (rs.previous()) {
                this.out_.writeInt(1);
                this.writeRow(rs);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void first(ResultSet rs) throws IOException {
        try {
            if (rs.first()) {
                this.out_.writeInt(1);
                this.writeRow(rs);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void last(ResultSet rs) throws IOException {
        try {
            if (rs.last()) {
                this.out_.writeInt(1);
                this.writeRow(rs);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void relative(ResultSet rs) throws IOException {
        try {
            int value = this.in_.readInt();
            if (rs.relative(value)) {
                this.out_.writeInt(1);
                this.writeRow(rs);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void absolute(ResultSet rs) throws IOException {
        try {
            int value = this.in_.readInt();
            if (rs.absolute(value)) {
                this.out_.writeInt(1);
                this.writeRow(rs);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void beforeFirst(ResultSet rs) throws IOException {
        try {
            rs.beforeFirst();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void afterLast(ResultSet rs) throws IOException {
        try {
            rs.afterLast();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void isAfterLast(ResultSet rs) throws IOException {
        try {
            if (rs.isAfterLast()) {
                this.out_.writeInt(1);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void isBeforeFirst(ResultSet rs) throws IOException {
        try {
            if (rs.isBeforeFirst()) {
                this.out_.writeInt(1);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void isFirst(ResultSet rs) throws IOException {
        try {
            if (rs.isFirst()) {
                this.out_.writeInt(1);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void isLast(ResultSet rs) throws IOException {
        try {
            if (rs.isLast()) {
                this.out_.writeInt(1);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    public void updateRow(ResultSet rs) throws IOException {
        ResultSetMetaData rsmd = null;
        try {
            rs.moveToCurrentRow();
            rsmd = rs.getMetaData();
            int count = rsmd.getColumnCount();
            for (int i = 0; i < count; ++i) {
                if (rsmd.getColumnType(i + 1) == 4) {
                    rs.updateInt(i + 1, this.in_.readInt());
                    continue;
                }
                rs.updateString(i + 1, this.in_.readUTF());
            }
            rs.updateRow();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException e) {
            this.service_.handleException(e);
        }
    }

    protected void writeRow(ResultSet rs) throws IOException {
        ResultSetMetaData rsmd = null;
        try {
            rsmd = rs.getMetaData();
            int count = rsmd.getColumnCount();
            switch (this.service_.getDataFlowType()) {
                case 2: {
                    for (int i = 0; i < count; ++i) {
                        if (rsmd.getColumnType(i + 1) == 4) {
                            this.out_.writeInt(rs.getInt(i + 1));
                            continue;
                        }
                        this.out_.writeUTF(rs.getString(i + 1));
                    }
                    break;
                }
                case 3: {
                    System.out.println("DATA_FLOW_STRINGS_ONLY: This isn't implemented yet.");
                    break;
                }
                case 1: {
                    System.out.println("DATA_FLOW_ALL: This isn't implemented yet.");
                    break;
                }
                default: {
                    System.out.println("getDataFlowType(): Unknown data flow type - " + this.service_.getDataFlowType());
                }
            }
            this.out_.flush();
        }
        catch (SQLException e) {
            System.out.println("Everything is lost... there was an SQLException after the primary function was executed.... stream probably corrupted.");
        }
    }
}

