/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SystemValueEvent;
import com.ibm.as400.access.SystemValueInfo;
import com.ibm.as400.access.SystemValueList;
import com.ibm.as400.access.SystemValueListener;
import com.ibm.as400.access.SystemValueUtility;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class SystemValue
implements Serializable {
    static final long serialVersionUID = 4L;
    private AS400 system_ = null;
    SystemValueInfo info_ = null;
    Object value_ = null;
    private String groupName_ = null;
    private String groupDescription_ = null;
    private String localeDescription_ = null;
    private transient boolean cached_ = false;
    private transient boolean connected_ = false;
    private transient Vector systemValueListeners_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public SystemValue() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValue object.");
        }
    }

    public SystemValue(AS400 system, String name) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValue object, system: " + String.valueOf(system) + ", name: " + name);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            Trace.log(2, "Length of parameter 'name' is not valid: '" + name + "'");
            throw new ExtendedIllegalArgumentException("name (" + name + ")", 1);
        }
        this.system_ = system;
        this.info_ = SystemValueList.lookup(name.toUpperCase());
        this.localeDescription_ = SystemValueList.lookupDescription(this.info_, system.getLocale());
    }

    SystemValue(AS400 system, SystemValueInfo info, Object value, String groupName, String groupDescription) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing SystemValue object, system: " + String.valueOf(system) + ", group name: " + groupName);
        }
        this.system_ = system;
        this.info_ = info;
        this.value_ = value;
        this.groupName_ = groupName;
        this.groupDescription_ = groupDescription;
        this.localeDescription_ = SystemValueList.lookupDescription(this.info_, system.getLocale());
        this.cached_ = true;
        this.connected_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemValueListener(SystemValueListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding system value listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValue systemValue = this;
        synchronized (systemValue) {
            if (this.systemValueListeners_ == null) {
                this.systemValueListeners_ = new Vector();
            }
            this.systemValueListeners_.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValue systemValue = this;
        synchronized (systemValue) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        SystemValue systemValue = this;
        synchronized (systemValue) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    public void clear() {
        if (Trace.traceOn_) {
            Trace.log(1, "Clearing system value from cache.");
        }
        this.cached_ = false;
    }

    private void connect() throws AS400SecurityException, IOException, RequestNotSupportedException {
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot connect before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.info_.release_ > this.system_.getVRM() && this.info_.release_ != 262656) {
            byte[] vrmBytes = BinaryConverter.intToByteArray(this.info_.release_);
            Trace.log(2, "System not at correct release for system value, name: " + this.info_.name_ + ", release:", vrmBytes);
            throw new RequestNotSupportedException(this.info_.name_, 1);
        }
        this.connected_ = true;
    }

    private void fireChangedEvent(Object oldValue, Object newValue) {
        Vector targets = (Vector)this.systemValueListeners_.clone();
        SystemValueEvent event = new SystemValueEvent(this, oldValue, newValue);
        for (int i = 0; i < targets.size(); ++i) {
            SystemValueListener target = (SystemValueListener)targets.elementAt(i);
            target.systemValueChanged(event);
        }
    }

    public String getDescription() {
        String description;
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value description.");
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot get description before system value name is set.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        String string = description = this.localeDescription_ == null ? this.info_.description_ : this.localeDescription_;
        if (Trace.traceOn_) {
            Trace.log(1, "Description: " + description);
        }
        return description;
    }

    public int getGroup() {
        int group;
        block6: {
            if (Trace.traceOn_) {
                Trace.log(1, "Getting system value group.");
            }
            if (this.info_ == null) {
                Trace.log(2, "Cannot get group before system value name is set.");
                throw new ExtendedIllegalStateException("name", 4);
            }
            group = this.info_.group_;
            try {
                if (this.system_ != null && this.info_.name_.equals("QFRCCVNRST") && this.system_.getVRM() <= 327936) {
                    group = 7;
                }
            }
            catch (Exception e) {
                if (!Trace.traceOn_) break block6;
                Trace.log(4, "Couldn't retrieve VRM for system value:", (Throwable)e);
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Group:", group);
        }
        return group;
    }

    public String getGroupDescription() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value group description: " + this.groupDescription_);
        }
        return this.groupDescription_;
    }

    public String getGroupName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value group name: " + this.groupName_);
        }
        return this.groupName_;
    }

    public String getName() {
        String name;
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value name.");
        }
        String string = name = this.info_ == null ? null : this.info_.name_;
        if (Trace.traceOn_) {
            Trace.log(1, "Name: " + name);
        }
        return name;
    }

    public int getRelease() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value release.");
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot get release before system value name is set.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (Trace.traceOn_) {
            byte[] vrmBytes = BinaryConverter.intToByteArray(this.info_.release_);
            Trace.log(1, "Release:", vrmBytes);
        }
        return this.info_.release_;
    }

    public int getSize() {
        int size;
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value size.");
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot get size before system value name is set.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        int n = size = this.info_.type_ == 4 ? this.info_.size_ * this.info_.arraySize_ : this.info_.size_;
        if (Trace.traceOn_) {
            Trace.log(1, "Size:", size);
        }
        return size;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + String.valueOf(this.system_));
        }
        return this.system_;
    }

    public int getType() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value type.");
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot get type before system value name is set.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Type:", this.info_.type_);
        }
        return this.info_.type_;
    }

    public Object getValue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, RequestNotSupportedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system value value.");
        }
        if (!this.connected_) {
            this.connect();
        }
        if (!this.cached_) {
            this.value_ = SystemValueUtility.retrieve(this.system_, this.info_);
            this.cached_ = true;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Value: " + String.valueOf(this.value_));
        }
        return this.value_;
    }

    public boolean isReadOnly() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if system value is read only.");
        }
        if (this.info_ == null) {
            Trace.log(2, "Cannot determine read only before system value name is set.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Read only:", this.info_.readOnly_);
        }
        return this.info_.readOnly_;
    }

    public void removeSystemValueListener(SystemValueListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing system value listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.systemValueListeners_ != null) {
            this.systemValueListeners_.removeElement(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public void setName(String name) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system value name: " + name);
        }
        if (name == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'name' after connect.");
            throw new ExtendedIllegalStateException("name", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.info_ = SystemValueList.lookup(name.toUpperCase());
            this.localeDescription_ = this.system_ != null ? SystemValueList.lookupDescription(this.info_, this.system_.getLocale()) : null;
        } else {
            String oldValue = this.info_ != null ? this.info_.name_ : null;
            SystemValueInfo info = SystemValueList.lookup(name.toUpperCase());
            String newValue = info.name_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("name", oldValue, newValue);
            }
            this.info_ = info;
            String string = this.localeDescription_ = this.system_ != null ? SystemValueList.lookupDescription(this.info_, this.system_.getLocale()) : null;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("name", oldValue, newValue);
            }
        }
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + String.valueOf(system));
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = system;
            this.localeDescription_ = this.info_ != null ? SystemValueList.lookupDescription(this.info_, this.system_.getLocale()) : null;
        } else {
            AS400 oldValue = this.system_;
            AS400 newValue = system;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", oldValue, newValue);
            }
            this.system_ = system;
            String string = this.localeDescription_ = this.info_ != null ? SystemValueList.lookupDescription(this.info_, this.system_.getLocale()) : null;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", oldValue, newValue);
            }
        }
    }

    public void setValue(Object value) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, RequestNotSupportedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system value value: " + String.valueOf(value));
        }
        if (value == null) {
            Trace.log(2, "Parameter 'value' is null.");
            throw new NullPointerException("value");
        }
        if (!this.connected_) {
            this.connect();
        }
        SystemValueUtility.set(this.system_, this.info_, value);
        this.value_ = value;
        this.cached_ = true;
        if (this.systemValueListeners_ != null) {
            this.fireChangedEvent(this.value_, value);
        }
    }
}

