/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCBlobLocator;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCNClobLocator;
import com.ibm.as400.access.AS400JDBCSQLXMLLocator;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLLocatorBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLXMLLocator
extends SQLLocatorBase {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private ConvTable converter_;
    private ConvTable unicodeConverter_;
    private ConvTable unicodeUtf8Converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private SQLConversionSettings settings_;
    private int truncated_;
    private boolean outOfBounds_;
    private int columnIndex_;
    private byte[] valueBlob_;
    private String valueClob_;
    private Object savedValue_;
    private Object savedObject_;
    private int scale_;
    private boolean savedObjectWrittenToServer_ = false;
    private int xmlType_;
    private boolean inputStreamRead_ = false;

    SQLXMLLocator(AS400JDBCConnection connection, int id, int maxLength, SQLConversionSettings settings, ConvTable converter, int columnIndex, int xmlType) {
        this.connection_ = connection;
        maxLength = 0x7FFFFFFE;
        this.id_ = id;
        this.locator_ = xmlType == 1 ? new JDLobLocator(connection, id, maxLength, false) : new JDLobLocator(connection, id, maxLength, false);
        this.maxLength_ = maxLength;
        this.settings_ = settings;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.converter_ = converter;
        this.columnIndex_ = columnIndex;
        this.xmlType_ = xmlType;
        try {
            this.unicodeConverter_ = connection.getConverter(1200);
            this.unicodeUtf8Converter_ = connection.getConverter(1208);
        }
        catch (SQLException e) {
            this.unicodeConverter_ = connection.getConverter();
        }
    }

    @Override
    public Object clone() {
        return new SQLXMLLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_, this.xmlType_);
    }

    @Override
    public void setHandle(int handle) {
        this.locator_.setHandle(handle);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    @Override
    public int getHandle() {
        return this.locator_.getHandle();
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable converter) throws SQLException {
        this.convertFromRawBytes(rawBytes, offset, converter, false);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        int locatorHandle = BinaryConverter.byteArrayToInt(rawBytes, offset);
        this.locator_.setHandle(locatorHandle);
        this.locator_.setColumnIndex(this.columnIndex_);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), rawBytes, offset);
        if (!this.savedObjectWrittenToServer_ && this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    @Override
    public void validateRawTruncatedData(byte[] rawBytes, int offset, ConvTable ccsidConverter) {
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        this.savedObject_ = object;
        if (object instanceof ConvTableReader) {
            ((ConvTableReader)this.savedObject_).isXML_ = true;
            this.scale_ = -2;
        } else if (scale != -1) {
            this.scale_ = scale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        this.valueClob_ = null;
        this.valueBlob_ = null;
        int length = this.scale_;
        if (length == -1) {
            try {
                length = (int)this.locator_.getLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.savedObject_ instanceof String) {
            this.valueClob_ = (String)this.savedObject_;
        } else if (this.savedObject_ instanceof Reader) {
            this.valueClob_ = SQLDataBase.getStringFromReader((Reader)this.savedObject_, length, this);
            this.savedObject_ = this.valueClob_;
        } else if (this.savedObject_ instanceof Clob) {
            Clob clob;
            if (this.savedObject_ instanceof AS400JDBCClobLocator) {
                Clob clob2 = clob = (AS400JDBCClobLocator)this.savedObject_;
                synchronized (clob2) {
                    if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                        this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                        ((AS400JDBCClobLocator)clob).savedObject_ = null;
                        if (this.savedObject_ != null && !(this.savedObject_ instanceof AS400JDBCClobLocator)) {
                            this.doConversion();
                            return;
                        }
                    }
                }
            }
            clob = (Clob)this.savedObject_;
            this.valueClob_ = clob.getSubString(1L, (int)clob.length());
        } else if (this.savedObject_ instanceof byte[]) {
            this.valueBlob_ = (byte[])this.savedObject_;
            int objectLength = this.valueBlob_.length;
            if (objectLength > this.maxLength_) {
                byte[] newValue = new byte[this.maxLength_];
                System.arraycopy(this.valueBlob_, 0, newValue, 0, this.maxLength_);
                this.valueBlob_ = newValue;
            }
        } else if (this.savedObject_ instanceof Blob) {
            int lengthToUse;
            Blob blob = (Blob)this.savedObject_;
            int blobLength = (int)blob.length();
            int n = lengthToUse = blobLength < 0 ? Integer.MAX_VALUE : blobLength;
            if (lengthToUse > this.maxLength_) {
                lengthToUse = this.maxLength_;
            }
            this.valueBlob_ = blob.getBytes(1L, lengthToUse);
        } else if (this.savedObject_ instanceof InputStream) {
            length = this.scale_;
            if (length >= 0) {
                int objectLength;
                InputStream stream = (InputStream)this.savedObject_;
                this.valueBlob_ = SQLXMLLocator.readInputStream(stream, length, null, false);
                this.inputStreamRead_ = true;
                if (this.valueBlob_.length < length) {
                    JDError.throwSQLException((Object)this, "07006");
                }
                if ((objectLength = this.valueBlob_.length) > this.maxLength_) {
                    byte[] newValue = new byte[this.maxLength_];
                    System.arraycopy(this.valueBlob_, 0, newValue, 0, this.maxLength_);
                    this.valueBlob_ = newValue;
                }
                this.savedObject_ = this.valueBlob_;
            } else if (length == -2) {
                InputStream stream = (InputStream)this.savedObject_;
                this.valueBlob_ = SQLXMLLocator.readInputStream(stream, length, null, false);
                this.inputStreamRead_ = true;
                int objectLength = this.valueBlob_.length;
                if (objectLength > this.maxLength_) {
                    byte[] newValue = new byte[this.maxLength_];
                    System.arraycopy(this.valueBlob_, 0, newValue, 0, this.maxLength_);
                    this.valueBlob_ = newValue;
                }
                this.savedObject_ = this.valueBlob_;
            } else {
                JDError.throwSQLException("07006");
            }
        } else if (this.savedObject_ instanceof SQLXML) {
            SQLXML xml = (SQLXML)this.savedObject_;
            this.valueClob_ = xml.getString();
        } else {
            JDError.throwSQLException("07006");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToServer() throws SQLException {
        if (this.inputStreamRead_) {
            this.locator_.writeData(0L, this.valueBlob_, true);
        } else if (this.savedObject_ instanceof byte[]) {
            byte[] bytes = (byte[])this.savedObject_;
            this.locator_.writeData(0L, bytes, true);
        } else if (this.savedObject_ instanceof InputStream) {
            int length = this.scale_;
            if (length == 0) {
                this.locator_.writeData(0L, new byte[0], 0, 0, true);
            } else if (length > 0) {
                InputStream stream = (InputStream)this.savedObject_;
                this.valueBlob_ = SQLXMLLocator.readInputStream(stream, length, this.locator_, false);
                this.inputStreamRead_ = true;
                if (this.valueBlob_.length < length) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            } else if (length == -2) {
                InputStream stream = (InputStream)this.savedObject_;
                boolean doubleByteOffset = false;
                if (this.xmlType_ == 1) {
                    doubleByteOffset = true;
                }
                this.valueBlob_ = SQLXMLLocator.readInputStream(stream, length, this.locator_, doubleByteOffset);
                this.inputStreamRead_ = true;
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (this.savedObject_ instanceof Blob) {
            Blob blob;
            boolean set = false;
            if (this.savedObject_ instanceof AS400JDBCBlobLocator) {
                blob = (AS400JDBCBlobLocator)this.savedObject_;
                AS400JDBCBlobLocator doubleByteOffset = blob;
                synchronized (doubleByteOffset) {
                    if (((AS400JDBCBlobLocator)blob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCBlobLocator)blob).savedObject_;
                        this.scale_ = ((AS400JDBCBlobLocator)blob).savedScale_;
                        ((AS400JDBCBlobLocator)blob).savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                }
            }
            if (!set) {
                blob = (Blob)this.savedObject_;
                int length = (int)blob.length();
                byte[] data = blob.getBytes(1L, length);
                this.locator_.writeData(0L, data, 0, length, true);
            }
        } else if (this.savedObject_ instanceof String) {
            byte[] bytes;
            String string = (String)this.savedObject_;
            if (JDUtilities.hasXMLDeclaration(string)) {
                string = JDUtilities.handleXMLDeclarationEncoding(string);
                bytes = this.unicodeConverter_.stringToByteArray(string);
            } else {
                bytes = this.unicodeUtf8Converter_.stringToByteArray(string);
            }
            this.locator_.writeData(0L, bytes, true);
        } else if (this.savedObject_ instanceof Reader) {
            int length = this.scale_;
            if (length == 0) {
                this.locator_.writeData(0L, new byte[0], 0, 0, true);
            } else if (length > 0) {
                byte[] bytes;
                String string = this.valueClob_ = SQLDataBase.getStringFromReader((Reader)this.savedObject_, length, this);
                this.savedObject_ = this.valueClob_;
                if (JDUtilities.hasXMLDeclaration(this.valueClob_)) {
                    string = JDUtilities.handleXMLDeclarationEncoding(string);
                    bytes = this.unicodeConverter_.stringToByteArray(string);
                } else {
                    bytes = this.unicodeUtf8Converter_.stringToByteArray(string);
                }
                this.locator_.writeData(0L, bytes, true);
                if (bytes.length < length) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            } else if (length == -2) {
                byte[] bytes;
                String string = this.valueClob_ = SQLDataBase.getStringFromReader((Reader)this.savedObject_, length, this);
                this.savedObject_ = this.valueClob_;
                if (JDUtilities.hasXMLDeclaration(this.valueClob_)) {
                    string = JDUtilities.handleXMLDeclarationEncoding(string);
                    bytes = this.unicodeConverter_.stringToByteArray(string);
                } else {
                    bytes = this.unicodeUtf8Converter_.stringToByteArray(string);
                }
                this.locator_.writeData(0L, bytes, true);
            }
        } else if (this.savedObject_ instanceof Clob) {
            Clob clob;
            boolean set = false;
            if (this.savedObject_ instanceof AS400JDBCClobLocator) {
                clob = (AS400JDBCClobLocator)this.savedObject_;
                AS400JDBCClobLocator bytes = clob;
                synchronized (bytes) {
                    if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                        this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                        ((AS400JDBCClobLocator)clob).savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                }
            }
            if (!set) {
                clob = (Clob)this.savedObject_;
                int length = (int)clob.length();
                String substring = clob.getSubString(1L, length);
                byte[] inputBytes = JDUtilities.hasXMLDeclaration(substring) ? this.unicodeConverter_.stringToByteArray(JDUtilities.handleXMLDeclarationEncoding(substring)) : this.unicodeUtf8Converter_.stringToByteArray(substring);
                this.locator_.writeData(0L, inputBytes, 0, inputBytes.length, true);
                set = true;
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (this.savedObject_ instanceof SQLXML) {
            SQLXML xml = (SQLXML)this.savedObject_;
            boolean set = false;
            if (this.savedObject_ instanceof AS400JDBCSQLXMLLocator) {
                AS400JDBCSQLXMLLocator xmlLocator;
                AS400JDBCSQLXMLLocator substring = xmlLocator = (AS400JDBCSQLXMLLocator)this.savedObject_;
                synchronized (substring) {
                    if (xmlLocator.clobLocatorValue_ != null && xmlLocator.clobLocatorValue_.savedObject_ != null) {
                        this.savedObject_ = xmlLocator.clobLocatorValue_.savedObject_;
                        this.scale_ = xmlLocator.clobLocatorValue_.savedScale_;
                        xmlLocator.clobLocatorValue_.savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                    if (xmlLocator.blobLocatorValue_ != null && xmlLocator.blobLocatorValue_.savedObject_ != null) {
                        this.savedObject_ = xmlLocator.blobLocatorValue_.savedObject_;
                        this.scale_ = xmlLocator.blobLocatorValue_.savedScale_;
                        xmlLocator.blobLocatorValue_.savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                }
            }
            if (!set) {
                String stringVal = xml.getString();
                byte[] inputBytes = JDUtilities.hasXMLDeclaration(stringVal) ? this.unicodeConverter_.stringToByteArray(JDUtilities.handleXMLDeclarationEncoding(stringVal)) : this.unicodeUtf8Converter_.stringToByteArray(stringVal);
                this.locator_.writeData(0L, inputBytes, 0, inputBytes.length, true);
            }
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObjectWrittenToServer_ = true;
    }

    @Override
    public int getSQLType() {
        return 40;
    }

    @Override
    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    @Override
    public int getDisplaySize() {
        return this.maxLength_;
    }

    @Override
    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCSQLXML";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "XML";
    }

    @Override
    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 2452;
    }

    @Override
    public int getPrecision() {
        return this.maxLength_;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 2009;
    }

    @Override
    public String getTypeName() {
        return "XML";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public int getActualSize() {
        return this.maxLength_;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public void clearTruncated() {
        this.truncated_ = 0;
    }

    @Override
    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.valueClob_));
            }
            ConvTableReader tmpUnicodeReader = new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true);
            return new ReaderInputStream((Reader)tmpUnicodeReader, 819);
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCInputStream(new JDLobLocator(this.locator_));
    }

    @Override
    public Blob getBlob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            if (this.valueBlob_ != null) {
                return new AS400JDBCBlob(this.valueBlob_, this.maxLength_);
            }
            try {
                return new AS400JDBCBlob(this.valueClob_.getBytes("UTF-8"), this.maxLength_);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCBlobLocator(new JDLobLocator(this.locator_), this.savedObject_, this.scale_);
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        int locatorLength;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            if (this.valueBlob_ != null) {
                return this.valueBlob_;
            }
        }
        if ((locatorLength = (int)this.locator_.getLength()) == 0) {
            return new byte[0];
        }
        DBLobData data = this.locator_.retrieveData(0L, locatorLength);
        int actualLength = data.getLength();
        byte[] bytes = new byte[actualLength];
        System.arraycopy(data.getRawBytes(), data.getOffset(), bytes, 0, actualLength);
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return bytes;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new StringReader(this.valueClob_);
            }
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true);
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCClob(this.valueClob_, this.maxLength_);
        }
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_, true);
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            return this.savedObject_;
        }
        return new AS400JDBCSQLXMLLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_, true);
    }

    @Override
    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.valueClob_;
        }
        DBLobData data = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String value = this.converter_.byteArrayToString(data.getRawBytes(), data.getOffset(), data.getLength());
        value = JDUtilities.stripXMLDeclaration(value);
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return value;
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ReaderInputStream((Reader)new StringReader(this.valueClob_), 13488);
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true), 13488);
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException("HY000", e);
            return null;
        }
    }

    @Override
    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new StringReader(this.valueClob_);
        }
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true);
        }
        catch (UnsupportedEncodingException e) {
            JDError.throwSQLException((Object)this, "HY000", e);
            return null;
        }
    }

    @Override
    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCNClob(this.valueClob_, this.maxLength_);
        }
        return new AS400JDBCNClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_, true);
    }

    @Override
    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.valueClob_;
        }
        DBLobData data = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String value = this.converter_.byteArrayToString(data.getRawBytes(), data.getOffset(), data.getLength());
        value = JDUtilities.stripXMLDeclaration(value);
        return value;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCSQLXMLLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_, true);
    }

    @Override
    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void updateSettings(SQLConversionSettings settings) {
        this.settings_ = settings;
    }

    @Override
    public void saveValue() throws SQLException {
        if (this.valueClob_ == null && this.valueBlob_ == null && this.savedObject_ != null) {
            this.doConversion();
        }
        this.savedValue_ = this.valueClob_ != null ? this.valueClob_ : (Object)this.valueBlob_;
    }

    @Override
    public Object getSavedValue() {
        return this.savedValue_;
    }
}

