/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLNumeric2
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private int precision_;
    private int scale_;
    private AS400ZonedDecimal typeConverter_;
    private double value_;
    private JDProperties properties_;
    private int vrm_;

    SQLNumeric2(int precision, int scale, SQLConversionSettings settings, int vrm, JDProperties properties) {
        super(settings);
        this.precision_ = precision;
        this.scale_ = scale;
        this.typeConverter_ = new AS400ZonedDecimal(this.precision_, this.scale_);
        this.value_ = 0.0;
        this.vrm_ = vrm;
        this.properties_ = properties;
    }

    @Override
    public Object clone() {
        return new SQLNumeric2(this.precision_, this.scale_, this.settings_, this.vrm_, this.properties_);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        this.value_ = this.typeConverter_.toDouble(rawBytes, offset);
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        this.typeConverter_.toBytes(this.value_, rawBytes, offset);
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (object instanceof String) {
            try {
                this.value_ = Double.valueOf((String)object);
            }
            catch (NumberFormatException nfe) {
                JDError.throwSQLException((Object)this, "07006", nfe);
            }
        } else if (object instanceof Number) {
            this.value_ = ((Number)object).doubleValue();
        } else if (object instanceof Boolean) {
            this.value_ = (Boolean)object != false ? 1.0 : 0.0;
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
    }

    @Override
    public int getSQLType() {
        return 23;
    }

    @Override
    public String getCreateParameters() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(AS400JDBCDriver.getResource("PRECISION", null));
        buffer.append(",");
        buffer.append(AS400JDBCDriver.getResource("SCALE", null));
        return buffer.toString();
    }

    @Override
    public int getDisplaySize() {
        return this.precision_ + 2;
    }

    @Override
    public String getJavaClassName() {
        return "java.math.BigDecimal";
    }

    @Override
    public String getLiteralPrefix() {
        return null;
    }

    @Override
    public String getLiteralSuffix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return "NUMERIC";
    }

    @Override
    public int getMaximumPrecision() {
        if (this.vrm_ >= JDUtilities.vrm530) {
            return this.properties_.getInt(53);
        }
        return 31;
    }

    @Override
    public int getMaximumScale() {
        if (this.vrm_ >= JDUtilities.vrm530) {
            return this.properties_.getInt(54);
        }
        return 31;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 488;
    }

    @Override
    public int getPrecision() {
        return this.precision_;
    }

    @Override
    public int getRadix() {
        return 10;
    }

    @Override
    public int getScale() {
        return this.scale_;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getTypeName() {
        return "NUMERIC";
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public int getActualSize() {
        return this.precision_;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new BigDecimal(this.value_);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_ != 0.0;
    }

    @Override
    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 127.0 || this.value_ < -128.0) {
            if (this.value_ > 32767.0 || this.value_ < -32768.0) {
                if (this.value_ > 2.147483647E9 || this.value_ < -2.147483648E9) {
                    this.truncated_ = 7;
                    this.outOfBounds_ = true;
                } else {
                    this.truncated_ = 3;
                    this.outOfBounds_ = true;
                }
            } else {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
        }
        return (byte)this.value_;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 3.4028234663852886E38 || this.value_ < -3.4028234663852886E38) {
            this.truncated_ = 4;
            this.outOfBounds_ = true;
        }
        return (float)this.value_;
    }

    @Override
    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 2.147483647E9 || this.value_ < -2.147483648E9) {
            this.truncated_ = 4;
            this.outOfBounds_ = true;
        }
        return (int)this.value_;
    }

    @Override
    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 9.223372036854776E18 || this.value_ < -9.223372036854776E18) {
            this.truncated_ = 1;
            this.outOfBounds_ = true;
        }
        return (long)this.value_;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    @Override
    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 32767.0 || this.value_ < -32768.0) {
            if (this.value_ > 2.147483647E9 || this.value_ < -2.147483648E9) {
                this.truncated_ = 6;
                this.outOfBounds_ = true;
            } else {
                this.truncated_ = 2;
                this.outOfBounds_ = true;
            }
        }
        return (short)this.value_;
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String stringRep = Double.toString(this.value_);
        int decimal = stringRep.indexOf(46);
        if (decimal == -1) {
            return stringRep;
        }
        return stringRep.substring(0, decimal) + this.settings_.getDecimalSeparator() + stringRep.substring(decimal + 1);
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

