/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.PSConfig;
import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.PSLoadBalancer;
import com.ibm.as400.access.PSServerSocketContainerAdapter;
import com.ibm.as400.access.ProxyServer;
import com.ibm.as400.access.PxBooleanParm;
import com.ibm.as400.access.PxConfigReqSV;
import com.ibm.as400.access.PxConnectReqSV;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxEndReqSV;
import com.ibm.as400.access.PxIntParm;
import com.ibm.as400.access.PxLoadReqSV;
import com.ibm.as400.access.PxRepSV;
import com.ibm.as400.access.PxReqSV;
import com.ibm.as400.access.PxSerializedObjectParm;
import com.ibm.as400.access.PxStringParm;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.StoppableThread;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

class PSController
extends StoppableThread {
    private static long nextConnectionId_ = 1000L;
    private static Object nextConnectionIdLock_ = new Object();
    private boolean closed_ = false;
    private Socket connectedSocket_;
    private long connectionId_ = -1L;
    private PxDSFactory factory_;
    private InputStream input_;
    private boolean ownSocket_ = false;
    private OutputStream output_;
    private boolean running_ = false;
    private PSServerSocketContainerAdapter serverSocket_;

    public PSController(Vector threadGroup, ProxyServer proxyServer, PSLoad load, PSLoadBalancer loadBalancer, PSConfig config, PSServerSocketContainerAdapter serverSocket) {
        super("PSController-" + String.valueOf(serverSocket));
        this.serverSocket_ = serverSocket;
        this.factory_ = new PxDSFactory();
        this.factory_.register(new PxBooleanParm());
        this.factory_.register(new PxIntParm());
        this.factory_.register(new PxStringParm());
        this.factory_.register(new PxSerializedObjectParm(null));
        this.factory_.register(new PxConnectReqSV(threadGroup, this, load, loadBalancer));
        this.factory_.register(new PxConfigReqSV(config, this));
        this.factory_.register(new PxEndReqSV(proxyServer, this));
        this.factory_.register(new PxLoadReqSV(load));
        if (Trace.isTraceOn()) {
            Trace.log(6, "Px server controller " + String.valueOf(this) + " opened.");
        }
    }

    public void closeServerSocket() {
        if (Trace.isTraceOn()) {
            Trace.log(6, "Px server controller " + String.valueOf(this) + " closed.");
        }
        this.closeSocket();
        try {
            this.serverSocket_.close();
        }
        catch (IOException e) {
            Trace.log(2, e.getMessage(), (Throwable)e);
        }
        this.closed_ = true;
    }

    public void closeSocket() {
        if (this.ownSocket_) {
            try {
                if (this.connectedSocket_ != null) {
                    this.connectedSocket_.close();
                }
            }
            catch (IOException e) {
                Trace.log(2, "Exception closing proxy socket:", (Throwable)e);
            }
            this.ownSocket_ = false;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed_) {
            this.closeServerSocket();
        }
        super.finalize();
    }

    public InetAddress getClientAddress() {
        return this.connectedSocket_.getInetAddress();
    }

    public Socket getConnectedSocket() {
        this.ownSocket_ = false;
        return this.connectedSocket_;
    }

    public long getConnectionId() {
        return this.connectionId_;
    }

    public InputStream getInputStream() {
        return this.input_;
    }

    public OutputStream getOutputStream() {
        return this.output_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running_ = true;
        while (this.canContinue()) {
            try {
                this.connectedSocket_ = this.serverSocket_.accept();
            }
            catch (Exception e) {
                Verbose.println(e);
                Trace.log(2, "Exception accepting proxy socket:", (Throwable)e);
                break;
            }
            try {
                PxRepSV reply;
                this.input_ = new BufferedInputStream(this.connectedSocket_.getInputStream());
                this.output_ = new BufferedOutputStream(this.connectedSocket_.getOutputStream());
                this.ownSocket_ = true;
                Object e = nextConnectionIdLock_;
                synchronized (e) {
                    this.connectionId_ = ++nextConnectionId_;
                }
                if (Trace.isTraceProxyOn()) {
                    Trace.log(6, this, "calling factory_.getNextDS");
                }
                PxReqSV request = (PxReqSV)this.factory_.getNextDS(this.input_);
                if (Trace.isTraceProxyOn()) {
                    request.dump(Trace.getPrintWriter());
                }
                if ((reply = request.process()) == null) continue;
                reply.setCorrelationId(request.getCorrelationId());
                OutputStream outputStream = this.output_;
                synchronized (outputStream) {
                    if (Trace.isTraceProxyOn()) {
                        reply.dump(Trace.getPrintWriter());
                    }
                    reply.writeTo(this.output_);
                    this.output_.flush();
                }
            }
            catch (Exception e) {
                Verbose.println(e);
                Trace.log(2, "Exception processing proxy request:", (Throwable)e);
            }
            finally {
                this.closeSocket();
            }
        }
        this.running_ = false;
    }

    @Override
    public void stopSafely() {
        super.stopSafely();
        this.closeServerSocket();
        try {
            while (this.running_) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Verbose.println(ResourceBundleLoader.getText("PROXY_SERVER_ENDED", this.serverSocket_));
    }

    @Override
    public String toString() {
        return this.serverSocket_.toString();
    }
}

