/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JobCCSIDNative;
import com.ibm.as400.access.Trace;
import java.io.IOException;

public class JobCCSID {
    private static final String CLASSNAME = "com.ibm.as400.access.JobCCSID";
    private AS400 system_ = null;
    private int ccsid_ = -1;

    public JobCCSID() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobCCSID object.");
        }
    }

    public JobCCSID(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobCCSID object, system: " + String.valueOf(system));
        }
        this.system_ = system;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + String.valueOf(this.system_));
        }
        return this.system_;
    }

    public int retrieveCcsid() throws AS400SecurityException, ErrorCompletingRequestException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving CCSID.");
        }
        if (this.ccsid_ == -1) {
            if (Trace.traceOn_) {
                Trace.log(1, "Retrieving CCSID from server...");
            }
            if (this.system_ == null) {
                try {
                    this.ccsid_ = JobCCSIDNative.retrieveCcsid();
                }
                catch (Throwable e) {
                    Trace.log(2, "Attempt to connect to server before setting system.");
                    throw new ExtendedIllegalStateException("system", 4);
                }
            } else {
                this.ccsid_ = this.system_.getJobCcsid();
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "CCSID:", this.ccsid_);
        }
        return this.ccsid_;
    }

    public void setSystem(AS400 system) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + String.valueOf(system));
        }
        if (this.ccsid_ != -1) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        this.system_ = system;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

